/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.intellij.plugins.markdown.editor.CodeFenceLanguageListCompletionProvider;
import org.intellij.plugins.markdown.injection.CodeFenceLanguageProvider;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageAliases;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageGuesser;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/editor/CodeFenceLanguageListCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "Companion", "MyInsertHandler", "intellij.markdown.core"})
public final class CodeFenceLanguageListCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        for (CodeFenceLanguageProvider provider : CodeFenceLanguageGuesser.INSTANCE.getCustomProviders()) {
            List<LookupElement> lookups = provider.getCompletionVariantsForInfoString(parameters);
            for (LookupElement lookupElement : lookups) {
                LookupElementDecorator element2 = LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, (InsertHandler)new InsertHandler(parameters, lookupElement){
                    final /* synthetic */ CompletionParameters $parameters;
                    final /* synthetic */ LookupElement $lookupElement;

                    public final void handleInsert(@NotNull InsertionContext context, @NotNull LookupElementDecorator<LookupElement> item) {
                        new MyInsertHandler(this.$parameters).handleInsert(context, (LookupElement)item);
                        this.$lookupElement.handleInsert(context);
                    }
                    {
                        this.$parameters = completionParameters;
                        this.$lookupElement = lookupElement;
                    }
                });
                result2.addElement((LookupElement)element2);
            }
        }
        for (Language language : LanguageUtil.getInjectableLanguages()) {
            LookupElement lookupElement;
            String alias = CodeFenceLanguageAliases.INSTANCE.findMainAlias(language.getID());
            lookupElement = LookupElementBuilder.create((String)alias).withIcon(Companion.createLanguageIcon(language)).withTypeText(language.getDisplayName(), true).withInsertHandler((InsertHandler)new MyInsertHandler(parameters));
            result2.addElement(lookupElement);
        }
    }

    @JvmStatic
    @NotNull
    public static final Icon createLanguageIcon(@NotNull Language language) {
        return Companion.createLanguageIcon(language);
    }

    @JvmStatic
    public static final boolean isInMiddleOfUnCollapsedFence(@Nullable PsiElement element2, int offset) {
        return Companion.isInMiddleOfUnCollapsedFence(element2, offset);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/editor/CodeFenceLanguageListCompletionProvider$MyInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "(Lcom/intellij/codeInsight/completion/CompletionParameters;)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "intellij.markdown.core"})
    private static final class MyInsertHandler
    implements InsertHandler<LookupElement> {
        private final CompletionParameters parameters;

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (Companion.isInMiddleOfUnCollapsedFence(this.parameters.getOriginalPosition(), context.getStartOffset())) {
                context.getDocument().insertString(context.getTailOffset(), (CharSequence)"\n\n");
                context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, false);
            }
        }

        public MyInsertHandler(@NotNull CompletionParameters parameters) {
            this.parameters = parameters;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/editor/CodeFenceLanguageListCompletionProvider$Companion;", "", "()V", "createLanguageIcon", "Ljavax/swing/Icon;", "language", "Lcom/intellij/lang/Language;", "isInMiddleOfUnCollapsedFence", "", "element", "Lcom/intellij/psi/PsiElement;", "offset", "", "intellij.markdown.core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Icon createLanguageIcon(@NotNull Language language) {
            return (Icon)new DeferredIconImpl(null, (Object)language, true, (Function)createLanguageIcon.1.INSTANCE);
        }

        @JvmStatic
        public final boolean isInMiddleOfUnCollapsedFence(@Nullable PsiElement element2, int offset) {
            boolean bl;
            if (element2 == null) {
                bl = false;
            } else if (PsiUtilsKt.hasType(element2, MarkdownTokenTypes.CODE_FENCE_START)) {
                TextRange range = element2.getTextRange();
                bl = range.getStartOffset() + range.getEndOffset() == offset * 2;
            } else if (PsiUtilsKt.hasType(element2, MarkdownTokenTypes.TEXT) && PsiUtilsKt.hasType(element2.getParent(), MarkdownElementTypes.CODE_SPAN)) {
                TextRange range = element2.getTextRange();
                TextRange parentRange = element2.getParent().getTextRange();
                bl = range.getStartOffset() - parentRange.getStartOffset() == parentRange.getEndOffset() - range.getEndOffset();
            } else {
                bl = false;
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

