/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ExternalProcessUtil;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.groovy.GroovyBuilder;
import org.jetbrains.jps.incremental.groovy.GroovycContinuation;
import org.jetbrains.jps.incremental.groovy.GroovycFlavor;
import org.jetbrains.jps.incremental.groovy.GroovycOutputParser;
import org.jetbrains.jps.incremental.groovy.JpsGroovySettings;
import org.jetbrains.jps.incremental.groovy.JpsGroovycRunner;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.service.SharedThreadPool;

final class ForkedGroovyc
implements GroovycFlavor {
    private final boolean myOptimizeClassLoading;
    private final ModuleChunk myChunk;

    ForkedGroovyc(boolean optimizeClassLoading, ModuleChunk chunk) {
        this.myOptimizeClassLoading = optimizeClassLoading;
        this.myChunk = chunk;
    }

    @Override
    public GroovycContinuation runGroovyc(Collection<String> compilationClassPath, boolean forStubs, CompileContext context, File tempFile, final GroovycOutputParser parser, String byteCodeTargetLevel) throws Exception {
        String grapeRoot;
        String configScript;
        int suggested;
        ArrayList<String> classpath = new ArrayList<String>();
        if (this.myOptimizeClassLoading) {
            classpath.addAll(GroovyBuilder.getGroovyRtRoots(true));
        } else {
            classpath.addAll(compilationClassPath);
        }
        JpsGroovySettings settings = JpsGroovycRunner.getGroovyCompilerSettings(context);
        ArrayList<String> vmParams = new ArrayList<String>();
        String heapSize = System.getProperty("groovyc.heap.size");
        if (heapSize == null && (suggested = Utils.suggestForkedCompilerHeapSize()) > 0) {
            heapSize = String.valueOf(suggested);
        }
        if (heapSize != null) {
            vmParams.add("-Xmx" + heapSize + "m");
        }
        vmParams.add("-Dfile.encoding=" + System.getProperty("file.encoding"));
        if ("false".equals(System.getProperty("groovyc.asm.resolving.only"))) {
            vmParams.add("-Dgroovyc.asm.resolving.only=false");
        }
        if (StringUtil.isNotEmpty((String)(configScript = settings.configScript))) {
            vmParams.add("-Dgroovyc.config.script=" + configScript);
        }
        if ((grapeRoot = System.getProperty("grape.root")) != null) {
            vmParams.add("-Dgrape.root=" + grapeRoot);
        }
        if (byteCodeTargetLevel != null) {
            vmParams.add("-Dgroovy.target.bytecode=" + byteCodeTargetLevel);
        }
        if ("true".equals(System.getProperty("groovyc.remove.annotations.for.stub.generation"))) {
            vmParams.add("-Dgroovyc.remove.annotations.for.stub.generation=true");
        }
        List cmd = ExternalProcessUtil.buildJavaCommandLine((String)ForkedGroovyc.getJavaExecutable(this.myChunk), (String)"org.jetbrains.groovy.compiler.rt.GroovycRunner", Collections.emptyList(), classpath, vmParams, this.getProgramParams(tempFile, settings, forStubs));
        Process process = Runtime.getRuntime().exec(ArrayUtilRt.toStringArray((Collection)cmd));
        BaseOSProcessHandler handler = new BaseOSProcessHandler(process, StringUtil.join((Collection)cmd, (String)" "), null){

            @NotNull
            public Future<?> executeTask(@NotNull Runnable task) {
                return SharedThreadPool.getInstance().submit(task);
            }

            public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
                parser.notifyTextAvailable(text, outputType);
            }
        };
        handler.startNotify();
        handler.waitFor();
        parser.notifyFinished(process.exitValue());
        return null;
    }

    private List<String> getProgramParams(File tempFile, JpsGroovySettings settings, boolean forStubs) {
        ArrayList programParams = ContainerUtil.newArrayList((Object[])new String[]{this.myOptimizeClassLoading ? "optimize" : "do_not_optimize", forStubs ? "stubs" : "groovyc", tempFile.getPath()});
        if (settings.invokeDynamic) {
            programParams.add("--indy");
        }
        return programParams;
    }

    private static String getJavaExecutable(ModuleChunk chunk) {
        JpsSdk<JpsDummyElement> sdk = GroovyBuilder.getJdk(chunk);
        return sdk != null ? JpsJavaSdkType.getJavaExecutable(sdk) : SystemProperties.getJavaHome() + "/bin/java";
    }
}

