/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.plugincomponents;

import com.intellij.application.options.codeStyle.cache.CodeStyleCachingService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CachedValueImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.Utils;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.core.EditorConfigException;
import org.editorconfig.core.ParserCallback;
import org.editorconfig.core.ParsingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class SettingsProviderComponent
extends SimpleModificationTracker {
    private static final Key<CachedValue<List<EditorConfig.OutPair>>> CACHED_PAIRS = Key.create((String)"editorconfig.cached.pairs");
    public static final String ERROR = "___error___";
    private final EditorConfig editorConfig = new EditorConfig();
    private static final Logger LOG = Logger.getInstance(SettingsProviderComponent.class);
    private static final long TIMEOUT = 3L;

    public static SettingsProviderComponent getInstance() {
        return (SettingsProviderComponent)((Object)ApplicationManager.getApplication().getService(SettingsProviderComponent.class));
    }

    public List<EditorConfig.OutPair> getOutPairs(Project project, VirtualFile file) {
        return this.getOutPairs(project, file, null);
    }

    public List<EditorConfig.OutPair> getOutPairs(Project project, VirtualFile file, @Nullable ParserCallback callback) {
        String filePath = Utils.getFilePath(project, file);
        if (filePath == null) {
            return Collections.emptyList();
        }
        UserDataHolder dataHolder = CodeStyleCachingService.getInstance((Project)project).getDataHolder(file);
        if (dataHolder == null) {
            return Collections.emptyList();
        }
        CachedValue cache = (CachedValue)dataHolder.getUserData(CACHED_PAIRS);
        if (cache == null) {
            Set<String> rootDirs = this.getRootDirs(project);
            cache = new CachedValueImpl((CachedValueProvider)new CachedPairsProvider(filePath, rootDirs, callback));
            dataHolder.putUserData(CACHED_PAIRS, (Object)cache);
        }
        return (List)cache.getValue();
    }

    public Set<String> getRootDirs(Project project) {
        if (!EditorConfigRegistry.shouldStopAtProjectRoot()) {
            return Collections.emptySet();
        }
        return (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            HashSet<String> dirs = new HashSet<String>();
            VirtualFile projectBase = project.getBaseDir();
            if (projectBase != null) {
                dirs.add(project.getBasePath());
                ReadAction.run(() -> {
                    for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                            if (VfsUtilCore.isAncestor((VirtualFile)projectBase, (VirtualFile)root, (boolean)false)) continue;
                            dirs.add(root.getPath());
                        }
                    }
                });
            }
            dirs.add(PathManager.getConfigPath());
            return new CachedValueProvider.Result(dirs, new Object[]{ProjectRootModificationTracker.getInstance((Project)project)});
        });
    }

    private class CachedPairsProvider
    implements CachedValueProvider<List<EditorConfig.OutPair>> {
        @NotNull
        private final String myFilePath;
        @NotNull
        private final Set<String> myRootDirs;
        @Nullable
        private final ParserCallback myCallback;
        @Nullable
        private Future<List<EditorConfig.OutPair>> myFuture;
        private long myParentModificationCount;

        private CachedPairsProvider(@NotNull String filePath, @Nullable Set<String> rootDirs, ParserCallback callback) {
            this.myFilePath = filePath;
            this.myRootDirs = rootDirs;
            this.myCallback = callback;
        }

        @Nullable
        public CachedValueProvider.Result<List<EditorConfig.OutPair>> compute() {
            try {
                List<EditorConfig.OutPair> outPairs = this.getProperties();
                return CachedValueProvider.Result.create(outPairs, (Object[])new Object[]{SettingsProviderComponent.this});
            }
            catch (TimeoutException timeoutException) {
                LOG.warn("Timeout processing .editorconfig for " + this.myFilePath);
                return CachedValueProvider.Result.create(Collections.singletonList(new EditorConfig.OutPair(SettingsProviderComponent.ERROR, "Timeout")), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
            }
            catch (Exception error) {
                ArrayList<EditorConfig.OutPair> errorResult = new ArrayList<EditorConfig.OutPair>();
                errorResult.add(new EditorConfig.OutPair(SettingsProviderComponent.ERROR, error.getMessage()));
                return CachedValueProvider.Result.create(errorResult, (Object[])new Object[]{SettingsProviderComponent.this});
            }
        }

        private synchronized List<EditorConfig.OutPair> getProperties() throws ExecutionException, InterruptedException, EditorConfigException, TimeoutException {
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return SettingsProviderComponent.this.editorConfig.getProperties(this.myFilePath, this.myRootDirs, this.myCallback);
            }
            long currParentModificationCount = SettingsProviderComponent.this.getModificationCount();
            if (this.myFuture == null || this.myParentModificationCount != currParentModificationCount) {
                this.myParentModificationCount = currParentModificationCount;
                if (this.myFuture != null && !this.myFuture.isDone()) {
                    this.myFuture.cancel(true);
                }
                this.myFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    ArrayList<EditorConfig.OutPair> pairs = new ArrayList<EditorConfig.OutPair>();
                    try {
                        pairs.addAll(SettingsProviderComponent.this.editorConfig.getProperties(this.myFilePath, this.myRootDirs, this.myCallback));
                    }
                    catch (ParsingException pe) {
                        pairs.add(new EditorConfig.OutPair(SettingsProviderComponent.ERROR, pe.getMessage()));
                    }
                    return pairs;
                });
            }
            return this.myFuture.get(3L, TimeUnit.SECONDS);
        }
    }
}

