/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.psi.impl;

import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Optional;
import kotlin.text.StringsKt;
import org.editorconfig.language.psi.EditorConfigCharClassLetter;
import org.editorconfig.language.psi.EditorConfigOptionValueList;
import org.editorconfig.language.psi.EditorConfigOptionValuePair;
import org.editorconfig.language.psi.impl.EditorConfigListDescriptorFinderVisitor;
import org.editorconfig.language.psi.impl.EditorConfigPairDescriptorFinderVisitor;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorConfigPsiImplUtils {
    private EditorConfigPsiImplUtils() {
    }

    public static boolean isEscape(@NotNull EditorConfigCharClassLetter letter) {
        return letter.textContains('\\');
    }

    public static boolean isValidEscape(@NotNull EditorConfigCharClassLetter letter) {
        if (!letter.isEscape()) {
            return false;
        }
        int length = letter.getTextLength();
        if (length == 3) {
            return letter.textMatches("\\\r\n");
        }
        if (length != 2) {
            return false;
        }
        String text = letter.getText();
        if (text.charAt(0) != '\\') {
            return false;
        }
        return StringsKt.contains((CharSequence)" \r\n\t\\#;!?*[]{}", (char)text.charAt(1), (boolean)false);
    }

    @Nullable
    public static EditorConfigDescriptor getDescriptor(@NotNull EditorConfigOptionValuePair pair, boolean smart) {
        EditorConfigDescribableElement parent = pair.getDescribableParent();
        if (parent == null) {
            return null;
        }
        EditorConfigDescriptor parentDescriptor = parent.getDescriptor(smart);
        if (parentDescriptor == null) {
            return null;
        }
        EditorConfigPairDescriptorFinderVisitor finder = new EditorConfigPairDescriptorFinderVisitor();
        parentDescriptor.accept(finder);
        return finder.getDescriptor();
    }

    @Nullable
    public static EditorConfigDescriptor getDescriptor(@NotNull EditorConfigOptionValueList list, boolean smart) {
        EditorConfigDescribableElement parent = list.getDescribableParent();
        if (parent == null) {
            return null;
        }
        EditorConfigDescriptor parentDescriptor = parent.getDescriptor(smart);
        if (parentDescriptor == null) {
            return null;
        }
        EditorConfigListDescriptorFinderVisitor finder = new EditorConfigListDescriptorFinderVisitor(list);
        parentDescriptor.accept(finder);
        return finder.getDescriptor();
    }

    @NotNull
    public static EditorConfigDescribableElement getFirst(@NotNull EditorConfigOptionValuePair pair) {
        Optional<PsiElement> first = Arrays.stream(pair.getChildren()).filter(child -> child instanceof EditorConfigDescribableElement).findFirst();
        if (first.isEmpty()) {
            throw new IllegalStateException();
        }
        return (EditorConfigDescribableElement)first.get();
    }

    @NotNull
    public static EditorConfigDescribableElement getSecond(@NotNull EditorConfigOptionValuePair pair) {
        Optional<PsiElement> second = Arrays.stream(pair.getChildren()).filter(child -> child instanceof EditorConfigDescribableElement).skip(1L).findFirst();
        if (second.isEmpty()) {
            throw new IllegalStateException();
        }
        return (EditorConfigDescribableElement)second.get();
    }
}

