/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.finder;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import org.editorconfig.configmanagement.finder.EditorConfigFinder;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigGotoFileContributor
implements ChooseByNameContributor {
    private static final String[] EDITOR_CONFIG_NAMES = new String[]{".editorconfig"};

    public String @NotNull [] getNames(Project project, boolean includeNonProjectItems) {
        return EDITOR_CONFIG_NAMES;
    }

    public NavigationItem @NotNull [] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        if (includeNonProjectItems) {
            NavigationItemFactory itemFactory = new NavigationItemFactory(project);
            EditorConfigFinder.searchParentEditorConfigs(project.getBaseDir(), itemFactory);
            return itemFactory.getItems();
        }
        return NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
    }

    @Nullable
    private static EditorConfigPsiFile getPsiFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        PsiFile psiFile;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document != null && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) instanceof EditorConfigPsiFile) {
            return (EditorConfigPsiFile)psiFile;
        }
        return null;
    }

    private static final class NavigationItemFactory
    implements EditorConfigFinder.Callback {
        private final List<NavigationItem> myItems = new ArrayList<NavigationItem>();
        private final Project myProject;

        private NavigationItemFactory(Project project) {
            this.myProject = project;
        }

        @Override
        public EditorConfigFinder.Callback.Result found(@NotNull VirtualFile editorConfigFile) {
            EditorConfigPsiFile psiFile = EditorConfigGotoFileContributor.getPsiFile(this.myProject, editorConfigFile);
            if (psiFile != null) {
                this.myItems.add((NavigationItem)psiFile);
            }
            return EditorConfigFinder.Callback.Result.Continue;
        }

        private NavigationItem[] getItems() {
            return this.myItems.isEmpty() ? NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY : this.myItems.toArray(NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY);
        }

        @Override
        public void done() {
        }
    }
}

