/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.finder;

import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorConfigFinder {
    private EditorConfigFinder() {
    }

    public static void searchParentEditorConfigs(@NotNull VirtualFile root, @NotNull Callback callback) {
        for (VirtualFile parentDir = root.getParent(); parentDir != null; parentDir = parentDir.getParent()) {
            VirtualFile editorConfig = EditorConfigFinder.getEditorConfigUnder(parentDir);
            if (editorConfig == null || callback.found(editorConfig) != Callback.Result.Stop) continue;
            return;
        }
    }

    @Nullable
    private static VirtualFile getEditorConfigUnder(@NotNull VirtualFile dir) {
        for (VirtualFile file : dir.getChildren()) {
            if (!EditorConfigFinder.isEditorConfig(file)) continue;
            return file;
        }
        return null;
    }

    private static boolean isEditorConfig(@NotNull VirtualFile file) {
        return ".editorconfig".equals(file.getName());
    }

    public static interface Callback {
        public Result found(@NotNull VirtualFile var1);

        public void done();

        public static enum Result {
            Stop,
            Continue;

        }
    }
}

