/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.export;

import com.intellij.openapi.options.SchemeExporter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.io.OutputStream;
import org.editorconfig.configmanagement.export.EditorConfigSettingsWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigExporter
extends SchemeExporter<CodeStyleScheme> {
    public void exportScheme(@Nullable Project project, @NotNull CodeStyleScheme scheme, @NotNull OutputStream outputStream) throws Exception {
        CodeStyleSettings settings = scheme.getCodeStyleSettings();
        try (EditorConfigSettingsWriter writer = new EditorConfigSettingsWriter(project, outputStream, settings, false, false);){
            writer.writeSettings();
        }
    }

    public String getExtension() {
        return "editorconfig";
    }

    public String getDefaultFileName(@NotNull String schemeName) {
        return "";
    }

    @NotNull
    public VirtualFile getDefaultDir(@Nullable Project project) {
        VirtualFile baseDir;
        if (project != null && (baseDir = project.getBaseDir()) != null) {
            return baseDir;
        }
        return super.getDefaultDir(project);
    }
}

