/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import java.util.Collections;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewManager;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigPreviewMarkerProvider
extends LineMarkerProviderDescriptor {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable(value="null means disabled")
    public @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable(value="null means disabled") String getName() {
        return EditorConfigBundle.message("line.marker.name.code.preview");
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element instanceof EditorConfigHeader && EditorConfigPreviewMarkerProvider.isEditorConfigEnabled(element)) {
            ActionGroup actionGroup = EditorConfigPreviewMarkerProvider.createActions((EditorConfigHeader)element);
            PsiElement child = element.getFirstChild();
            if (child != null && child.getNode().getElementType() == EditorConfigElementTypes.L_BRACKET) {
                return new SectionLineMarkerInfo(actionGroup, child, element.getTextRange(), null);
            }
        }
        return null;
    }

    private static boolean isEditorConfigEnabled(@NotNull PsiElement element) {
        return element.isValid() && Utils.isEnabled(element.getProject());
    }

    @NotNull
    private static ActionGroup createActions(@NotNull EditorConfigHeader header) {
        return new DefaultActionGroup(Collections.singletonList(new ChooseFileAction(header)));
    }

    private static String getPattern(@NotNull String header) {
        return StringUtil.trimEnd((String)StringUtil.trimStart((String)header, (String)"["), (String)"]");
    }

    @Nullable
    private static VirtualFile choosePreviewFile(@NotNull Project project, final @NotNull VirtualFile rootDir, final @NotNull String pattern) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return (showHiddenFiles || !FileElement.isFileHidden((VirtualFile)file)) && !".editorconfig".equals(file.getName()) && file.getLength() <= 10000L && EditorConfigPreviewMarkerProvider.matchesPattern(rootDir, pattern, file.getPath()) || file.isDirectory();
            }

            public boolean isFileSelectable(@Nullable VirtualFile file) {
                return file != null && !file.isDirectory();
            }
        }.withRoots(new VirtualFile[]{rootDir});
        descriptor.setForcedToUseIdeaFileChooser(true);
        FileChooserDialog fileChooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project, null);
        VirtualFile[] virtualFiles = fileChooser.choose(project, VirtualFile.EMPTY_ARRAY);
        return virtualFiles.length > 0 ? virtualFiles[0] : null;
    }

    private static boolean matchesPattern(@NotNull VirtualFile rootDir, @NotNull String pattern, @NotNull String filePath) {
        return EditorConfig.filenameMatches(rootDir.getPath(), pattern, filePath);
    }

    @NotNull
    private static VirtualFile getRootDir(@NotNull EditorConfigHeader header) {
        PsiFile psiFile = header.getContainingFile();
        return psiFile.getVirtualFile().getParent();
    }

    private static void openPreview(@NotNull Project project, @NotNull VirtualFile editorConfigFile, @NotNull VirtualFile previewFile) {
        FileEditorManager.getInstance((Project)project).closeFile(editorConfigFile);
        EditorConfigPreviewManager.getInstance(project).associateWithPreviewFile(editorConfigFile, previewFile);
        FileEditorManager.getInstance((Project)project).openFile(editorConfigFile, true);
    }

    private static final class ChooseFileAction
    extends DumbAwareAction {
        @NotNull
        private final EditorConfigHeader myHeader;

        private ChooseFileAction(@NotNull EditorConfigHeader header) {
            super(EditorConfigBundle.message("editor.preview.open"));
            this.myHeader = header;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VirtualFile previewFile;
            if (this.myHeader.isValid() && (previewFile = EditorConfigPreviewMarkerProvider.choosePreviewFile(this.myHeader.getProject(), EditorConfigPreviewMarkerProvider.getRootDir(this.myHeader), EditorConfigPreviewMarkerProvider.getPattern(this.myHeader.getText()))) != null) {
                VirtualFile editorConfigFile = this.myHeader.getContainingFile().getVirtualFile();
                EditorConfigPreviewMarkerProvider.openPreview(this.myHeader.getProject(), editorConfigFile, previewFile);
            }
        }
    }

    private static final class SectionLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final ActionGroup myActionGroup;

        private SectionLineMarkerInfo(@NotNull ActionGroup actionGroup, @NotNull PsiElement element, @NotNull TextRange range, @Nullable Function<? super PsiElement, String> tooltipProvider) {
            super(element, range, AllIcons.General.InspectionsEye, tooltipProvider, null, GutterIconRenderer.Alignment.LEFT);
            this.myActionGroup = actionGroup;
        }

        @Nullable
        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return null;
                }

                public boolean isNavigateAction() {
                    return true;
                }

                public ActionGroup getPopupMenuActions() {
                    return myActionGroup;
                }
            };
        }
    }
}

