/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.editorconfig.configmanagement.editor.DocumentChangeInactivityDetector;
import org.jetbrains.annotations.NotNull;

public class EditorConfigEditorWithPreview
extends TextEditorWithPreview {
    private final DocumentChangeInactivityDetector myInactivityDetector;
    private final DocumentSaveHandler myHandler = new DocumentSaveHandler();
    private final VirtualFile myFile;
    private final Project myProject;

    public EditorConfigEditorWithPreview(@NotNull VirtualFile file, @NotNull Project project, @NotNull TextEditor editor, @NotNull FileEditor preview) {
        super(editor, preview);
        this.myFile = file;
        this.myProject = project;
        this.myInactivityDetector = new DocumentChangeInactivityDetector(this.getEditor().getDocument());
        this.getEditor().getDocument().addDocumentListener((DocumentListener)this.myInactivityDetector);
        this.myInactivityDetector.addListener(this.myHandler);
        this.myInactivityDetector.start();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if ("org.editorconfig.editorconfigjetbrains".equals(pluginDescriptor.getPluginId().getIdString())) {
                    FileEditorManager.getInstance((Project)EditorConfigEditorWithPreview.this.myProject).closeFile(EditorConfigEditorWithPreview.this.myFile);
                }
            }
        });
    }

    public void dispose() {
        this.myInactivityDetector.stop();
        this.myInactivityDetector.removeListener(this.myHandler);
        this.getEditor().getDocument().removeDocumentListener((DocumentListener)this.myInactivityDetector);
        super.dispose();
    }

    private class DocumentSaveHandler
    implements DocumentChangeInactivityDetector.InactivityListener {
        private DocumentSaveHandler() {
        }

        @Override
        public void onInactivity() {
            ApplicationManager.getApplication().invokeLater(() -> FileDocumentManager.getInstance().saveDocumentAsIs(EditorConfigEditorWithPreview.this.getEditor().getDocument()));
        }
    }
}

