/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import org.editorconfig.configmanagement.EditorConfigActionUtil;
import org.editorconfig.configmanagement.EditorConfigIndentOptionsProvider;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigIndentStatusBarUIContributor
extends IndentStatusBarUIContributor {
    private final boolean myEditorConfigIndentOptions;

    public EditorConfigIndentStatusBarUIContributor(CommonCodeStyleSettings.IndentOptions options) {
        super(options);
        this.myEditorConfigIndentOptions = options.getFileIndentOptionsProvider() instanceof EditorConfigIndentOptionsProvider;
    }

    public boolean areActionsAvailable(@NotNull VirtualFile file) {
        return this.myEditorConfigIndentOptions;
    }

    public AnAction @Nullable [] getActions(@NotNull PsiFile file) {
        if (this.myEditorConfigIndentOptions) {
            return EditorConfigActionUtil.createNavigationActions(file);
        }
        return null;
    }

    @Nullable
    public AnAction createDisableAction(@NotNull Project project) {
        return EditorConfigActionUtil.createDisableAction(project, EditorConfigBundle.message("action.disable"));
    }

    @Nullable
    public String getHint() {
        return this.myEditorConfigIndentOptions ? "EditorConfig" : null;
    }

    public boolean isShowFileIndentOptionsEnabled() {
        return false;
    }
}

