/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.ObjectUtils;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.ConfigEncodingManager;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="editorConfigEncodings", storages={@Storage(value="$CACHE_FILE$")})
public class EditorConfigEncodingCache
implements PersistentStateComponent<Element> {
    private static final String ENTRY_ELEMENT = "file";
    private static final String URL_ATTR = "url";
    private static final String CHARSET_ATTR = "charset";
    private static final String IGNORE_ATTR = "ignore";
    private final Map<String, CharsetData> myCharsetMap = new ConcurrentHashMap<String, CharsetData>();

    public static EditorConfigEncodingCache getInstance() {
        return (EditorConfigEncodingCache)ApplicationManager.getApplication().getService(EditorConfigEncodingCache.class);
    }

    @Nullable
    public Element getState() {
        Element root = new Element("encodings");
        for (String url : this.myCharsetMap.keySet()) {
            String charsetStr;
            CharsetData charsetData = this.myCharsetMap.get(url);
            if (charsetData == null || (charsetStr = ConfigEncodingManager.toString(charsetData.charset, charsetData.useBom)) == null) continue;
            Element entryElement = new Element(ENTRY_ELEMENT);
            Attribute urlAttr = new Attribute(URL_ATTR, url);
            Attribute charsetAttr = new Attribute(CHARSET_ATTR, charsetStr);
            entryElement.setAttribute(urlAttr);
            entryElement.setAttribute(charsetAttr);
            if (charsetData.isIgnored()) {
                entryElement.setAttribute(IGNORE_ATTR, Boolean.toString(charsetData.isIgnored()));
            }
            root.addContent(entryElement);
        }
        return root;
    }

    public void loadState(@NotNull Element state) {
        this.myCharsetMap.clear();
        for (Element fileElement : state.getChildren(ENTRY_ELEMENT)) {
            Attribute urlAttr = fileElement.getAttribute(URL_ATTR);
            Attribute charsetAttr = fileElement.getAttribute(CHARSET_ATTR);
            if (urlAttr == null || charsetAttr == null) continue;
            String url = urlAttr.getValue();
            String charsetStr = charsetAttr.getValue();
            Charset charset = ConfigEncodingManager.toCharset(charsetStr);
            boolean useBom = "utf-8-bom".equals(charsetStr);
            if (charset == null) continue;
            CharsetData charsetData = new CharsetData(charset, useBom);
            this.myCharsetMap.put(url, charsetData);
            Attribute ignoreAttr = fileElement.getAttribute(IGNORE_ATTR);
            if (ignoreAttr == null) continue;
            try {
                charsetData.setIgnored(ignoreAttr.getBooleanValue());
            }
            catch (DataConversionException dataConversionException) {}
        }
    }

    public boolean getUseUtf8Bom(@Nullable Project project, @NotNull VirtualFile virtualFile) {
        return (Boolean)ObjectUtils.notNull((Object)((Boolean)ObjectUtils.doIfNotNull((Object)this.getCharsetData(project, virtualFile, true), CharsetData::isUseBom)), (Object)false);
    }

    @Nullable
    CharsetData getCharsetData(@Nullable Project project, @NotNull VirtualFile virtualFile, boolean withCache) {
        CharsetData cached;
        if (!Utils.isApplicableTo(virtualFile) || Utils.isEditorConfigFile(virtualFile)) {
            return null;
        }
        if (withCache && (cached = this.getCachedCharsetData(virtualFile)) != null) {
            return cached;
        }
        if (project != null) {
            return EditorConfigEncodingCache.computeCharsetData(project, virtualFile);
        }
        return null;
    }

    @Nullable
    private static CharsetData computeCharsetData(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        List<EditorConfig.OutPair> outPairs = SettingsProviderComponent.getInstance().getOutPairs(project, virtualFile);
        String charsetStr = Utils.configValueForKey(outPairs, CHARSET_ATTR);
        if (!charsetStr.isEmpty()) {
            Charset charset = ConfigEncodingManager.toCharset(charsetStr);
            boolean useBom = "utf-8-bom".equals(charsetStr);
            if (charset != null) {
                return new CharsetData(charset, useBom);
            }
        }
        return null;
    }

    public void computeAndCacheEncoding(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        String key = EditorConfigEncodingCache.getKey(virtualFile);
        CharsetData charsetData = this.getCharsetData(project, virtualFile, false);
        if (charsetData != null) {
            this.myCharsetMap.put(key, charsetData);
            virtualFile.setCharset(charsetData.charset);
        }
    }

    @Nullable
    public Charset getCachedEncoding(@NotNull VirtualFile virtualFile) {
        CharsetData charsetData = this.getCachedCharsetData(virtualFile);
        return charsetData != null && !charsetData.isIgnored ? charsetData.getCharset() : null;
    }

    @Nullable
    private CharsetData getCachedCharsetData(@NotNull VirtualFile virtualFile) {
        return this.myCharsetMap.get(EditorConfigEncodingCache.getKey(virtualFile));
    }

    public boolean isIgnored(@NotNull VirtualFile virtualFile) {
        CharsetData charsetData = this.getCachedCharsetData(virtualFile);
        return charsetData != null && charsetData.isIgnored();
    }

    public void setIgnored(@NotNull VirtualFile virtualFile) {
        CharsetData charsetData = this.getCachedCharsetData(virtualFile);
        if (charsetData == null) {
            charsetData = new CharsetData(Charset.defaultCharset(), false);
            charsetData.setIgnored(true);
            this.myCharsetMap.put(EditorConfigEncodingCache.getKey(virtualFile), charsetData);
        } else {
            charsetData.setIgnored(true);
        }
    }

    @NotNull
    private static String getKey(@NotNull VirtualFile virtualFile) {
        return virtualFile.getUrl();
    }

    public final void reset() {
        this.myCharsetMap.clear();
    }

    public static class VfsListener
    extends BulkVirtualFileListenerAdapter {
        public VfsListener() {
            super(new VirtualFileListener(){

                public void fileCreated(@NotNull VirtualFileEvent event) {
                    VirtualFile file = event.getFile();
                    Project project = ProjectLocator.getInstance().guessProjectForFile(file);
                    if (project != null && ConfigEncodingManager.isEnabledFor(project, file)) {
                        EditorConfigEncodingCache.getInstance().computeAndCacheEncoding(project, event.getFile());
                    }
                }
            });
        }
    }

    static class CharsetData {
        private final Charset charset;
        private final boolean useBom;
        private boolean isIgnored;

        CharsetData(Charset charset, boolean useBom) {
            this.charset = charset;
            this.useBom = useBom;
        }

        Charset getCharset() {
            return this.charset;
        }

        boolean isUseBom() {
            return this.useBom;
        }

        boolean isIgnored() {
            return this.isIgnored;
        }

        void setIgnored(boolean isIgnored) {
            this.isIgnored = isIgnored;
        }
    }
}

