/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant.filter;

import com.android.flags.Flag;
import com.android.tools.idea.flags.StudioFlags;
import com.google.targetsdkversionassistant.filter.Api31;
import com.google.targetsdkversionassistant.filter.FilterService;
import com.google.targetsdkversionassistant.filter.Predicates;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0003\u0018\u0019\u001aB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u00142\u0006\u0010\u0017\u001a\u00020\tR*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R6\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/google/targetsdkversionassistant/filter/FilterService;", "", "project", "Lcom/intellij/openapi/project/Project;", "enabled", "", "(Lcom/intellij/openapi/project/Project;Z)V", "filterMap", "", "", "Lcom/google/targetsdkversionassistant/filter/FilterService$Filter;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;)V", "(Lcom/intellij/openapi/project/Project;)V", "<set-?>", "Lkotlin/Function0;", "getEnabled", "()Lkotlin/jvm/functions/Function0;", "getFilterMap", "()Ljava/util/Map;", "filter", "", "Lcom/intellij/psi/PsiElement;", "Lcom/google/targetsdkversionassistant/filter/LocationProvider;", "key", "Filter", "FiltersDisabledException", "UnknownFilterException", "targetsdkversion-upgrade-assistant"})
public final class FilterService {
    @NotNull
    private final Project project;
    @NotNull
    private Function0<Boolean> enabled;
    @NotNull
    private Map<String, ? extends Filter> filterMap;

    public FilterService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Flag flag = StudioFlags.TSDKVUA_FILTERS;
        Intrinsics.checkNotNullExpressionValue((Object)flag, (String)"TSDKVUA_FILTERS");
        this.enabled = (Function0)new Function0<Boolean>((Object)flag){

            public final Boolean invoke() {
                return (Boolean)((Flag)this.receiver).get();
            }
        };
        Pair[] pairArray = new Pair[7];
        Function1 function1 = Predicates.INSTANCE.then(filterMap.1.INSTANCE, Api31.INSTANCE.getLegacyBluetoothPermissionUses());
        pairArray[0] = TuplesKt.to((Object)"legacyBluetooth", (Object)new Filter(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function;
            }

            public final /* synthetic */ List relevantLocations(Project p) {
                return (List)this.function.invoke((Object)p);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Filter ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        function1 = Predicates.INSTANCE.then(filterMap.2.INSTANCE, Api31.INSTANCE.getFineLocationRequestWithoutCoarse());
        pairArray[1] = TuplesKt.to((Object)"fineLocationWithoutCoarse", (Object)new /* invalid duplicate definition of identical inner class */);
        function1 = Predicates.INSTANCE.then(filterMap.3.INSTANCE, Api31.INSTANCE.getComponentIntentFilterMissings());
        pairArray[2] = TuplesKt.to((Object)"intentFilterMissing", (Object)new /* invalid duplicate definition of identical inner class */);
        function1 = Predicates.INSTANCE.then(filterMap.4.INSTANCE, Api31.INSTANCE.getPendingIntentMutabilityMissings());
        pairArray[3] = TuplesKt.to((Object)"pendingIntentMutability", (Object)new /* invalid duplicate definition of identical inner class */);
        function1 = Predicates.INSTANCE.then(filterMap.5.INSTANCE, Api31.INSTANCE.getCustomNotificationUses());
        pairArray[4] = TuplesKt.to((Object)"customNotifications", (Object)new /* invalid duplicate definition of identical inner class */);
        function1 = Predicates.INSTANCE.then(filterMap.6.INSTANCE, Api31.INSTANCE.getAppLinkVerificationUses());
        pairArray[5] = TuplesKt.to((Object)"appLinkVerification", (Object)new /* invalid duplicate definition of identical inner class */);
        function1 = Predicates.INSTANCE.then(filterMap.7.INSTANCE, Api31.INSTANCE.getSdkVersionUpdateMissing());
        pairArray[6] = TuplesKt.to((Object)"targetSdkVersion31", (Object)new /* invalid duplicate definition of identical inner class */);
        this.filterMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Function0<Boolean> getEnabled() {
        return this.enabled;
    }

    public FilterService(@NotNull Project project, final boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(project);
        this.enabled = (Function0)new Function0<Boolean>(){

            @NotNull
            public final Boolean invoke() {
                return enabled2;
            }
        };
    }

    @NotNull
    public final Map<String, Filter> getFilterMap() {
        return this.filterMap;
    }

    public FilterService(@NotNull Project project, @NotNull Map<String, ? extends Filter> filterMap2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(filterMap2, (String)"filterMap");
        this(project, true);
        this.filterMap = filterMap2;
    }

    @NotNull
    public final List<PsiElement> filter(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!((Boolean)this.enabled.invoke()).booleanValue()) {
            throw new FiltersDisabledException();
        }
        Object object = this.filterMap.get(key);
        if (object == null || (object = object.relevantLocations(this.project)) == null) {
            throw new UnknownFilterException(key);
        }
        return object;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/google/targetsdkversionassistant/filter/FilterService$Filter;", "", "relevantLocations", "", "Lcom/intellij/psi/PsiElement;", "Lcom/google/targetsdkversionassistant/filter/LocationProvider;", "p", "Lcom/intellij/openapi/project/Project;", "targetsdkversion-upgrade-assistant"})
    public static interface Filter {
        @NotNull
        public List<PsiElement> relevantLocations(@NotNull Project var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/google/targetsdkversionassistant/filter/FilterService$FiltersDisabledException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "targetsdkversion-upgrade-assistant"})
    public static final class FiltersDisabledException
    extends Exception {
        public FiltersDisabledException() {
            super("Filters are disabled");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/google/targetsdkversionassistant/filter/FilterService$UnknownFilterException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "key", "", "(Ljava/lang/String;)V", "targetsdkversion-upgrade-assistant"})
    public static final class UnknownFilterException
    extends Exception {
        public UnknownFilterException(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super("Attempted to call unknown filter: " + key);
        }
    }
}

