/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.wrapper.impl;

import com.intellij.debugger.streams.wrapper.CallArgument;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.wrapper.MethodCall;
import com.intellij.debugger.streams.wrapper.QualifierExpression;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.TerminatorStreamCall;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class StreamChainImpl
implements StreamChain {
    private final QualifierExpression myQualifierExpression;
    private final List<? extends IntermediateStreamCall> myIntermediateCalls;
    private final TerminatorStreamCall myTerminator;
    private final PsiElement myContext;

    public StreamChainImpl(@NotNull QualifierExpression qualifierExpression, @NotNull List<? extends IntermediateStreamCall> intermediateCalls, @NotNull TerminatorStreamCall terminator, @NotNull PsiElement context) {
        this.myQualifierExpression = qualifierExpression;
        this.myIntermediateCalls = intermediateCalls;
        this.myTerminator = terminator;
        this.myContext = context;
    }

    @Override
    @NotNull
    public QualifierExpression getQualifierExpression() {
        return this.myQualifierExpression;
    }

    @Override
    @NotNull
    public List<IntermediateStreamCall> getIntermediateCalls() {
        return Collections.unmodifiableList(this.myIntermediateCalls);
    }

    @Override
    @NotNull
    public StreamCall getCall(int index) {
        if (0 <= index && index < this.length()) {
            return this.doGetCall(index);
        }
        throw new IndexOutOfBoundsException("Call index out of bound: " + index);
    }

    @Override
    @NotNull
    public TerminatorStreamCall getTerminationCall() {
        return this.myTerminator;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getText() {
        Iterator iterator = StreamEx.of(this.myIntermediateCalls).map(x -> x).append((Object)this.myTerminator).iterator();
        StringBuilder builder = new StringBuilder();
        builder.append(this.myQualifierExpression.getText()).append("\n").append(".");
        while (iterator.hasNext()) {
            MethodCall call2 = (MethodCall)iterator.next();
            String args = StreamChainImpl.args2Text(call2.getArguments());
            builder.append(call2.getName()).append(args);
            if (!iterator.hasNext()) continue;
            builder.append("\n").append(".");
        }
        return builder.toString();
    }

    @Override
    @NotNull
    @NlsSafe
    public String getCompactText() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.myQualifierExpression.getText().replaceAll("\\s+", ""));
        for (StreamCall call2 : StreamEx.of(this.myIntermediateCalls).map(x -> x).append((Object)this.myTerminator)) {
            builder.append(" -> ").append(call2.getName());
        }
        return builder.toString();
    }

    @Override
    public int length() {
        return 1 + this.myIntermediateCalls.size();
    }

    @Override
    @NotNull
    public PsiElement getContext() {
        return this.myContext;
    }

    private StreamCall doGetCall(int index) {
        if (index < this.myIntermediateCalls.size()) {
            return this.myIntermediateCalls.get(index);
        }
        return this.myTerminator;
    }

    @NotNull
    private static String args2Text(@NotNull List<CallArgument> args) {
        return StreamEx.of(args).map(CallArgument::getText).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
    }
}

