/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl;

import com.intellij.debugger.streams.lib.ResolverFactory;
import com.intellij.debugger.streams.resolve.ResolvedStreamCall;
import com.intellij.debugger.streams.resolve.ResolvedStreamChain;
import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.resolve.impl.ResolvedIntermediateCallImpl;
import com.intellij.debugger.streams.resolve.impl.ResolvedStreamChainImpl;
import com.intellij.debugger.streams.resolve.impl.ResolvedTerminatorCallImpl;
import com.intellij.debugger.streams.trace.NextAwareState;
import com.intellij.debugger.streams.trace.PrevAwareState;
import com.intellij.debugger.streams.trace.ResolvedTracingResult;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.TracingResult;
import com.intellij.debugger.streams.trace.impl.FirstStateImpl;
import com.intellij.debugger.streams.trace.impl.IntermediateStateImpl;
import com.intellij.debugger.streams.trace.impl.TerminationStateImpl;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TracingResultImpl
implements TracingResult {
    private final TraceElement myStreamResult;
    private final List<TraceInfo> myTrace;
    private final boolean myIsResultException;
    private final StreamChain mySourceChain;

    TracingResultImpl(@NotNull StreamChain chain, @NotNull TraceElement streamResult2, @NotNull List<TraceInfo> trace, boolean isResultException) {
        this.myStreamResult = streamResult2;
        this.myTrace = trace;
        this.mySourceChain = chain;
        this.myIsResultException = isResultException;
    }

    @Override
    @NotNull
    public TraceElement getResult() {
        return this.myStreamResult;
    }

    @Override
    public boolean exceptionThrown() {
        return this.myIsResultException;
    }

    @Override
    @NotNull
    public List<TraceInfo> getTrace() {
        return this.myTrace;
    }

    @Override
    @NotNull
    public ResolvedTracingResult resolve(@NotNull ResolverFactory resolverFactory2) {
        assert (this.myTrace.size() == this.mySourceChain.length());
        List resolvedTraces = ContainerUtil.map(this.myTrace, x -> resolverFactory2.getResolver(x.getCall().getName()).resolve((TraceInfo)x));
        TraceInfo firstCallTrace = this.myTrace.get(0);
        List<IntermediateStreamCall> intermediateCalls = this.mySourceChain.getIntermediateCalls();
        ResolvedStreamChainImpl.Builder chainBuilder = new ResolvedStreamChainImpl.Builder();
        List<TraceElement> valuesBeforeFirstCall = TraceUtil.sortedByTime(firstCallTrace.getValuesOrderBefore().values());
        FirstStateImpl firstState = new FirstStateImpl(valuesBeforeFirstCall, firstCallTrace.getCall(), ((ValuesOrderResolver.Result)resolvedTraces.get(0)).getDirectOrder());
        if (intermediateCalls.isEmpty()) {
            chainBuilder.setTerminator(this.buildResolvedTerminationCall(this.myTrace.get(0), firstState, ((ValuesOrderResolver.Result)resolvedTraces.get(0)).getReverseOrder()));
        } else {
            int i;
            ArrayList<IntermediateStateImpl> states = new ArrayList<IntermediateStateImpl>();
            for (i = 0; i < intermediateCalls.size() - 1; ++i) {
                states.add(new IntermediateStateImpl(TraceUtil.sortedByTime(this.myTrace.get(i).getValuesOrderAfter().values()), intermediateCalls.get(i), intermediateCalls.get(i + 1), ((ValuesOrderResolver.Result)resolvedTraces.get(i)).getReverseOrder(), ((ValuesOrderResolver.Result)resolvedTraces.get(i + 1)).getDirectOrder()));
            }
            states.add(new IntermediateStateImpl(TraceUtil.sortedByTime(this.myTrace.get(this.myTrace.size() - 1).getValuesOrderBefore().values()), intermediateCalls.get(intermediateCalls.size() - 1), this.mySourceChain.getTerminationCall(), ((ValuesOrderResolver.Result)resolvedTraces.get(resolvedTraces.size() - 2)).getReverseOrder(), ((ValuesOrderResolver.Result)resolvedTraces.get(resolvedTraces.size() - 1)).getDirectOrder()));
            chainBuilder.addIntermediate(new ResolvedIntermediateCallImpl(intermediateCalls.get(0), firstState, (PrevAwareState)states.get(0)));
            for (i = 1; i < states.size(); ++i) {
                chainBuilder.addIntermediate(new ResolvedIntermediateCallImpl(intermediateCalls.get(i), (NextAwareState)states.get(i - 1), (PrevAwareState)states.get(i)));
            }
            chainBuilder.setTerminator(this.buildResolvedTerminationCall(this.myTrace.get(this.myTrace.size() - 1), (NextAwareState)states.get(states.size() - 1), ((ValuesOrderResolver.Result)resolvedTraces.get(resolvedTraces.size() - 1)).getReverseOrder()));
        }
        return new MyResolvedResult(chainBuilder.build());
    }

    private ResolvedStreamCall.Terminator buildResolvedTerminationCall(@NotNull TraceInfo terminatorTrace, @NotNull NextAwareState previousState, @NotNull Map<TraceElement, List<TraceElement>> terminationToPrevMapping) {
        List<TraceElement> after = TraceUtil.sortedByTime(terminatorTrace.getValuesOrderAfter().values());
        TerminationStateImpl terminatorState = new TerminationStateImpl(this.myStreamResult, previousState.getNextCall(), after, terminationToPrevMapping);
        return new ResolvedTerminatorCallImpl(this.mySourceChain.getTerminationCall(), previousState, terminatorState);
    }

    private class MyResolvedResult
    implements ResolvedTracingResult {
        @NotNull
        private final ResolvedStreamChain myChain;

        MyResolvedResult(ResolvedStreamChain resolvedStreamChain) {
            this.myChain = resolvedStreamChain;
        }

        @Override
        @NotNull
        public ResolvedStreamChain getResolvedChain() {
            return this.myChain;
        }

        @Override
        @NotNull
        public StreamChain getSourceChain() {
            return TracingResultImpl.this.mySourceChain;
        }

        @Override
        public boolean exceptionThrown() {
            return TracingResultImpl.this.myIsResultException;
        }

        @Override
        @NotNull
        public TraceElement getResult() {
            return TracingResultImpl.this.myStreamResult;
        }
    }
}

