/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class IdentityResolver
implements ValuesOrderResolver {
    private static final Object NULL_MARKER = ObjectUtils.sentinel((String)"IdentityResolver.NULL_MARKER");

    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Map<Integer, TraceElement> before = info.getValuesOrderBefore();
        Map<Integer, TraceElement> after = info.getValuesOrderAfter();
        HashMap<TraceElement, List<TraceElement>> direct = new HashMap<TraceElement, List<TraceElement>>();
        HashMap<TraceElement, List<TraceElement>> reverse = new HashMap<TraceElement, List<TraceElement>>();
        Map grouped = ((StreamEx)StreamEx.of(after.keySet()).sorted()).map(after::get).groupingBy(IdentityResolver::extractKey);
        HashMap<Object, Integer> key2Index = new HashMap<Object, Integer>();
        for (TraceElement element : before.values()) {
            Object key = IdentityResolver.extractKey(element);
            List elements2 = (List)grouped.get(key);
            if (elements2 == null || elements2.isEmpty()) {
                direct.put(element, Collections.emptyList());
                continue;
            }
            int nextIndex = key2Index.getOrDefault(key, -1) + 1;
            key2Index.put(key, nextIndex);
            TraceElement afterItem = (TraceElement)elements2.get(nextIndex);
            direct.put(element, Collections.singletonList(afterItem));
            reverse.put(afterItem, Collections.singletonList(element));
        }
        return ValuesOrderResolver.Result.of(direct, reverse);
    }

    @NotNull
    private static Object extractKey(@NotNull TraceElement element) {
        Object key = TraceUtil.extractKey(element);
        return key == null ? NULL_MARKER : key;
    }
}

