/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class EmptyResolver
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Map<Integer, TraceElement> orderBefore = info.getValuesOrderBefore();
        Map<Integer, TraceElement> orderAfter = info.getValuesOrderAfter();
        return ValuesOrderResolver.Result.of(EmptyResolver.toEmptyMap(orderBefore), EmptyResolver.toEmptyMap(orderAfter));
    }

    @NotNull
    private static Map<TraceElement, List<TraceElement>> toEmptyMap(@NotNull Map<Integer, TraceElement> order) {
        return order.keySet().stream().collect(Collectors.toMap(order::get, x -> Collections.emptyList()));
    }
}

