/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.lib.impl;

import com.intellij.debugger.streams.lib.HandlerFactory;
import com.intellij.debugger.streams.lib.InterpreterFactory;
import com.intellij.debugger.streams.lib.LibrarySupport;
import com.intellij.debugger.streams.lib.ResolverFactory;
import com.intellij.debugger.streams.resolve.EmptyResolver;
import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.IntermediateCallHandler;
import com.intellij.debugger.streams.trace.TerminatorCallHandler;
import com.intellij.debugger.streams.trace.dsl.Dsl;
import com.intellij.debugger.streams.trace.impl.handler.unified.PeekTraceHandler;
import com.intellij.debugger.streams.trace.impl.handler.unified.TerminatorTraceHandler;
import com.intellij.debugger.streams.trace.impl.interpret.SimplePeekCallTraceInterpreter;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.wrapper.TerminatorStreamCall;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/intellij/debugger/streams/lib/impl/DefaultLibrarySupport;", "Lcom/intellij/debugger/streams/lib/LibrarySupport;", "()V", "interpreterFactory", "Lcom/intellij/debugger/streams/lib/InterpreterFactory;", "getInterpreterFactory", "()Lcom/intellij/debugger/streams/lib/InterpreterFactory;", "resolverFactory", "Lcom/intellij/debugger/streams/lib/ResolverFactory;", "getResolverFactory", "()Lcom/intellij/debugger/streams/lib/ResolverFactory;", "createHandlerFactory", "Lcom/intellij/debugger/streams/lib/HandlerFactory;", "dsl", "Lcom/intellij/debugger/streams/trace/dsl/Dsl;", "intellij.java.debugger.streams"})
public final class DefaultLibrarySupport
implements LibrarySupport {
    @NotNull
    private final InterpreterFactory interpreterFactory = new InterpreterFactory(){

        @NotNull
        public CallTraceInterpreter getInterpreter(@NotNull String callName) {
            return new SimplePeekCallTraceInterpreter();
        }
    };
    @NotNull
    private final ResolverFactory resolverFactory = new ResolverFactory(){

        @NotNull
        public ValuesOrderResolver getResolver(@NotNull String callName) {
            return new EmptyResolver();
        }
    };

    @Override
    @NotNull
    public HandlerFactory createHandlerFactory(@NotNull Dsl dsl) {
        return new HandlerFactory(dsl){
            final /* synthetic */ Dsl $dsl;

            @NotNull
            public IntermediateCallHandler getForIntermediate(int number, @NotNull IntermediateStreamCall call2) {
                return new PeekTraceHandler(number, call2.getName(), call2.getTypeBefore(), call2.getTypeAfter(), this.$dsl);
            }

            @NotNull
            public TerminatorCallHandler getForTermination(@NotNull TerminatorStreamCall call2, @NotNull String resultExpression) {
                return new TerminatorTraceHandler(call2, this.$dsl);
            }
            {
                this.$dsl = $captured_local_variable$0;
            }
        };
    }

    @Override
    @NotNull
    public InterpreterFactory getInterpreterFactory() {
        return this.interpreterFactory;
    }

    @Override
    @NotNull
    public ResolverFactory getResolverFactory() {
        return this.resolverFactory;
    }
}

