/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.spellchecker;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sh.ShTypes;
import com.intellij.sh.lexer.ShTokenTypes;
import com.intellij.sh.spellchecker.ShIdentifierOwnerTokenizer;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class ShSpellcheckingStrategy
extends SpellcheckingStrategy {
    private static final TokenSet TOKENS_WITH_TEXT = TokenSet.create((IElementType[])new IElementType[]{ShTypes.STRING_CONTENT, ShTypes.RAW_STRING, ShTypes.HEREDOC_CONTENT, ShTokenTypes.COMMENT});

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        ASTNode node = element.getNode();
        if (node != null && TOKENS_WITH_TEXT.contains(node.getElementType())) {
            return TEXT_TOKENIZER;
        }
        if (element instanceof PsiNameIdentifierOwner) {
            return ShIdentifierOwnerTokenizer.INSTANCE;
        }
        return EMPTY_TOKENIZER;
    }
}

