/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck.intention;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sh.ShBundle;
import com.intellij.sh.shellcheck.ShShellcheckInspection;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ShDisableInspectionIntention
implements IntentionAction,
LowPriorityAction,
Iconable {
    private final String myInspectionCode;
    private final String myMessage;

    public ShDisableInspectionIntention(String message, String inspectionCode) {
        this.myInspectionCode = inspectionCode;
        this.myMessage = message;
    }

    @NotNull
    public String getText() {
        return ShBundle.message("sh.disable.inspection.text", this.myMessage);
    }

    @NotNull
    public String getFamilyName() {
        return ShBundle.message("sh.shell.script", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (file == null) {
            return;
        }
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, it -> {
            ShShellcheckInspection tool = (ShShellcheckInspection)it.getUnwrappedTool("ShellCheck", (PsiElement)file);
            if (tool != null) {
                tool.disableInspection(this.myInspectionCode);
            }
        });
        DaemonCodeAnalyzer.getInstance((Project)project).restart(file);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }
}

