/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.ExternalAnnotatorBatchInspection;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.sh.shellcheck.ShellcheckOptionsPanel;
import com.intellij.ui.EditorNotifications;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShShellcheckInspection
extends LocalInspectionTool
implements ExternalAnnotatorBatchInspection {
    @NonNls
    public static final String SHORT_NAME = "ShellCheck";
    @NonNls
    private static final String SHELLCHECK_SETTINGS_TAG = "shellcheck_settings";
    private static final String DELIMITER = ",";
    private final Set<@NlsSafe String> myDisabledInspections = new TreeSet<String>();
    private JComponent myOptionsPanel;

    public SuppressQuickFix @NotNull [] getBatchSuppressActions(@Nullable PsiElement element) {
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public void readSettings(@NotNull Element node) {
        String inspectionSettings = JDOMExternalizerUtil.readCustomField((Element)node, (String)SHELLCHECK_SETTINGS_TAG);
        if (StringUtil.isNotEmpty((String)inspectionSettings)) {
            this.myDisabledInspections.addAll(StringUtil.split((String)inspectionSettings, (String)DELIMITER));
        }
    }

    public void writeSettings(@NotNull Element node) {
        if (!this.myDisabledInspections.isEmpty()) {
            String joinedString = StringUtil.join(this.myDisabledInspections, (String)DELIMITER);
            JDOMExternalizerUtil.writeCustomField((Element)node, (String)SHELLCHECK_SETTINGS_TAG, (String)joinedString);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Project project = ProjectUtil.guessCurrentProject((JComponent)this.myOptionsPanel);
            EditorNotifications editorNotifications = EditorNotifications.getInstance((Project)project);
            editorNotifications.updateAllNotifications();
        }
    }

    @Nullable
    public JComponent createOptionsPanel() {
        this.myOptionsPanel = new ShellcheckOptionsPanel(this.getDisabledInspections(), this::onInspectionChange).getPanel();
        return this.myOptionsPanel;
    }

    @NotNull Set<@NlsSafe String> getDisabledInspections() {
        return new HashSet<String>(this.myDisabledInspections);
    }

    public void disableInspection(String inspectionCode) {
        if (StringUtil.isNotEmpty((String)inspectionCode)) {
            this.myDisabledInspections.add(inspectionCode);
        }
    }

    private void onInspectionChange(@NotNull String inspectionCode, boolean selected) {
        if (selected) {
            this.myDisabledInspections.add(inspectionCode);
        } else {
            this.myDisabledInspections.remove(inspectionCode);
        }
    }

    @NotNull
    static ShShellcheckInspection findShShellcheckInspection(@NotNull PsiElement element) {
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        ShShellcheckInspection tool = (ShShellcheckInspection)profile.getUnwrappedTool(SHORT_NAME, element);
        return tool == null ? new ShShellcheckInspection() : tool;
    }
}

