/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run.terminal;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.sh.run.ShRunner;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;

final class ShTerminalRunner
implements ShRunner {
    private static final Logger LOG = Logger.getInstance(ShTerminalRunner.class);

    ShTerminalRunner() {
    }

    @Override
    public void run(@NotNull Project project, @NotNull String command, @NotNull String workingDirectory, @NotNull @NlsContexts.TabTitle String title, boolean activateToolWindow) {
        TerminalView terminalView = TerminalView.getInstance((Project)project);
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal");
        if (window == null) {
            return;
        }
        ContentManager contentManager = window.getContentManager();
        Pair<Content, ShellTerminalWidget> pair = ShTerminalRunner.getSuitableProcess(contentManager, workingDirectory);
        try {
            if (pair == null) {
                terminalView.createLocalShellWidget(workingDirectory, title, activateToolWindow, activateToolWindow).executeCommand(command);
                return;
            }
            if (activateToolWindow) {
                window.activate(null);
            }
            ((Content)pair.first).setDisplayName(title);
            contentManager.setSelectedContent((Content)pair.first);
            ((ShellTerminalWidget)pair.second).executeCommand(command);
        }
        catch (IOException e) {
            LOG.warn("Cannot run command:" + command, (Throwable)e);
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project) {
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal");
        return window != null && window.isAvailable();
    }

    @Nullable
    private static Pair<Content, ShellTerminalWidget> getSuitableProcess(@NotNull ContentManager contentManager, @NotNull String workingDirectory) {
        Pair<Content, ShellTerminalWidget> pair;
        Content selectedContent = contentManager.getSelectedContent();
        if (selectedContent != null && (pair = ShTerminalRunner.getSuitableProcess(selectedContent, workingDirectory)) != null) {
            return pair;
        }
        return Arrays.stream(contentManager.getContents()).map(content -> ShTerminalRunner.getSuitableProcess(content, workingDirectory)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    private static Pair<Content, ShellTerminalWidget> getSuitableProcess(@NotNull Content content, @NotNull String workingDirectory) {
        JBTerminalWidget widget = TerminalView.getWidgetByContent((Content)content);
        if (!(widget instanceof ShellTerminalWidget)) {
            return null;
        }
        ShellTerminalWidget shellTerminalWidget = (ShellTerminalWidget)widget;
        if (!shellTerminalWidget.getTypedShellCommand().isEmpty() || shellTerminalWidget.hasRunningCommands()) {
            return null;
        }
        String currentWorkingDirectory = TerminalWorkingDirectoryManager.getWorkingDirectory((JBTerminalWidget)shellTerminalWidget, null);
        if (!FileUtil.pathsEqual((String)workingDirectory, (String)currentWorkingDirectory)) {
            return null;
        }
        return new Pair((Object)content, (Object)shellTerminalWidget);
    }
}

