/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.sh.ShBundle;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.run.ShRunConfigurationEditor;
import com.intellij.sh.run.ShRunConfigurationProfileState;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShRunConfiguration
extends LocatableConfigurationBase
implements RefactoringListenerProvider {
    @NonNls
    private static final String TAG_PREFIX = "INDEPENDENT_";
    @NonNls
    private static final String SCRIPT_TEXT_TAG = "SCRIPT_TEXT";
    @NonNls
    private static final String SCRIPT_PATH_TAG = "SCRIPT_PATH";
    @NonNls
    private static final String SCRIPT_OPTIONS_TAG = "SCRIPT_OPTIONS";
    @NonNls
    private static final String SCRIPT_WORKING_DIRECTORY_TAG = "SCRIPT_WORKING_DIRECTORY";
    @NonNls
    private static final String INTERPRETER_PATH_TAG = "INTERPRETER_PATH";
    @NonNls
    private static final String INTERPRETER_OPTIONS_TAG = "INTERPRETER_OPTIONS";
    @NonNls
    private static final String EXECUTE_IN_TERMINAL_TAG = "EXECUTE_IN_TERMINAL";
    @NonNls
    private static final String EXECUTE_SCRIPT_FILE_TAG = "EXECUTE_SCRIPT_FILE";
    private String myScriptText = "";
    private String myScriptPath = "";
    private String myScriptOptions = "";
    private String myInterpreterPath = "";
    private String myInterpreterOptions = "";
    private String myScriptWorkingDirectory = "";
    private boolean myExecuteInTerminal = true;
    private boolean myExecuteScriptFile = true;
    private EnvironmentVariablesData myEnvData = EnvironmentVariablesData.DEFAULT;

    ShRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        super(project, factory, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new ShRunConfigurationEditor(this.getProject());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.myExecuteScriptFile) {
            if (!FileUtil.exists((String)this.myScriptPath)) {
                throw new RuntimeConfigurationError(ShBundle.message("sh.run.script.not.found", new Object[0]));
            }
            if (StringUtil.isNotEmpty((String)this.myInterpreterPath) || !new File(this.myScriptPath).canExecute()) {
                if (this.myInterpreterPath.endsWith("sh") && ShRunConfiguration.getWSLDistributionIfNeeded(this.myInterpreterPath, this.myScriptPath) != null) {
                    return;
                }
                if (!FileUtil.exists((String)this.myInterpreterPath)) {
                    throw new RuntimeConfigurationError(ShBundle.message("sh.run.interpreter.not.found", new Object[0]));
                }
                if (!new File(this.myInterpreterPath).canExecute()) {
                    throw new RuntimeConfigurationError(ShBundle.message("sh.run.interpreter.should.be.executable", new Object[0]));
                }
            }
        }
        if (!FileUtil.exists((String)this.myScriptWorkingDirectory)) {
            throw new RuntimeConfigurationError(ShBundle.message("sh.run.working.dir.not.found", new Object[0]));
        }
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        return new ShRunConfigurationProfileState(environment.getProject(), this);
    }

    public void writeExternal(@NotNull Element element) {
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)SCRIPT_TEXT_TAG, (String)this.myScriptText);
        ShRunConfiguration.writePathWithMetadata(element, this.myScriptPath, SCRIPT_PATH_TAG);
        JDOMExternalizerUtil.writeField((Element)element, (String)SCRIPT_OPTIONS_TAG, (String)this.myScriptOptions);
        ShRunConfiguration.writePathWithMetadata(element, this.myScriptWorkingDirectory, SCRIPT_WORKING_DIRECTORY_TAG);
        ShRunConfiguration.writePathWithMetadata(element, this.myInterpreterPath, INTERPRETER_PATH_TAG);
        JDOMExternalizerUtil.writeField((Element)element, (String)INTERPRETER_OPTIONS_TAG, (String)this.myInterpreterOptions);
        JDOMExternalizerUtil.writeField((Element)element, (String)EXECUTE_IN_TERMINAL_TAG, (String)String.valueOf(this.myExecuteInTerminal));
        JDOMExternalizerUtil.writeField((Element)element, (String)EXECUTE_SCRIPT_FILE_TAG, (String)String.valueOf(this.myExecuteScriptFile));
        this.myEnvData.writeExternal(element);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myScriptText = ShRunConfiguration.readStringTagValue(element, SCRIPT_TEXT_TAG);
        this.myScriptPath = ShRunConfiguration.readPathWithMetadata(element, SCRIPT_PATH_TAG);
        this.myScriptOptions = ShRunConfiguration.readStringTagValue(element, SCRIPT_OPTIONS_TAG);
        this.myScriptWorkingDirectory = ShRunConfiguration.readPathWithMetadata(element, SCRIPT_WORKING_DIRECTORY_TAG);
        this.myInterpreterPath = ShRunConfiguration.readPathWithMetadata(element, INTERPRETER_PATH_TAG);
        this.myInterpreterOptions = ShRunConfiguration.readStringTagValue(element, INTERPRETER_OPTIONS_TAG);
        this.myExecuteInTerminal = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)EXECUTE_IN_TERMINAL_TAG, (String)Boolean.TRUE.toString()));
        this.myExecuteScriptFile = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)EXECUTE_SCRIPT_FILE_TAG, (String)Boolean.TRUE.toString()));
        this.myEnvData = EnvironmentVariablesData.readExternal((Element)element);
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (StringUtil.isEmpty((String)this.myScriptPath) || !(element instanceof ShFile) || !this.myScriptPath.equals(ShRunConfiguration.getPathByElement(element))) {
            return null;
        }
        return new RefactoringElementAdapter(){

            protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                if (newElement instanceof ShFile) {
                    ShRunConfiguration.this.setScriptPath(((ShFile)newElement).getVirtualFile().getPath());
                }
            }

            public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                this.elementRenamedOrMoved(newElement);
            }
        };
    }

    @Nullable
    private static String getPathByElement(@NotNull PsiElement element) {
        VirtualFile vfile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (vfile == null) {
            return null;
        }
        return vfile.getPath();
    }

    private static void writePathWithMetadata(@NotNull Element element, @NotNull String path, @NotNull String pathTag) {
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)path);
        JDOMExternalizerUtil.writeField((Element)element, (String)(TAG_PREFIX + pathTag), (String)Boolean.toString(systemIndependentPath.equals(path)));
        JDOMExternalizerUtil.writeField((Element)element, (String)pathTag, (String)systemIndependentPath);
    }

    private static String readPathWithMetadata(@NotNull Element element, @NotNull String pathTag) {
        return Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)(TAG_PREFIX + pathTag))) ? ShRunConfiguration.readStringTagValue(element, pathTag) : FileUtil.toSystemDependentName((String)ShRunConfiguration.readStringTagValue(element, pathTag));
    }

    @NotNull
    private static String readStringTagValue(@NotNull Element element, @NotNull String tagName) {
        return StringUtilRt.notNullize((String)JDOMExternalizerUtil.readField((Element)element, (String)tagName), (String)"");
    }

    public String getScriptText() {
        return this.myScriptText;
    }

    public void setScriptText(String scriptText) {
        this.myScriptText = scriptText;
    }

    public String getScriptPath() {
        return this.myScriptPath;
    }

    public void setScriptPath(@NotNull String scriptPath) {
        this.myScriptPath = scriptPath.trim();
    }

    public String getScriptOptions() {
        return this.myScriptOptions;
    }

    public void setScriptOptions(@NotNull String scriptOptions) {
        this.myScriptOptions = scriptOptions.trim();
    }

    public String getScriptWorkingDirectory() {
        return this.myScriptWorkingDirectory;
    }

    public void setScriptWorkingDirectory(String scriptWorkingDirectory) {
        this.myScriptWorkingDirectory = scriptWorkingDirectory.trim();
    }

    public boolean isExecuteInTerminal() {
        return this.myExecuteInTerminal;
    }

    public void setExecuteInTerminal(boolean executeInTerminal) {
        this.myExecuteInTerminal = executeInTerminal;
    }

    public boolean isExecuteScriptFile() {
        return this.myExecuteScriptFile;
    }

    public void setExecuteScriptFile(boolean executeScriptFile) {
        this.myExecuteScriptFile = executeScriptFile;
    }

    public EnvironmentVariablesData getEnvData() {
        return this.myEnvData;
    }

    public void setEnvData(EnvironmentVariablesData envData) {
        this.myEnvData = envData;
    }

    public String getInterpreterPath() {
        return this.myInterpreterPath;
    }

    public void setInterpreterPath(@NotNull String interpreterPath) {
        this.myInterpreterPath = interpreterPath.trim();
    }

    public String getInterpreterOptions() {
        return this.myInterpreterOptions;
    }

    public void setInterpreterOptions(@NotNull String interpreterOptions) {
        this.myInterpreterOptions = interpreterOptions.trim();
    }

    public static WSLDistribution getWSLDistributionIfNeeded(@Nullable String interpreterPath, @Nullable @NlsSafe String scriptPath) {
        String path;
        if (!WSLUtil.isSystemCompatible()) {
            return null;
        }
        if (EnvironmentUtil.getValue((String)"SHELL") != null) {
            return null;
        }
        if (scriptPath != null && (scriptPath.endsWith("cmd") || scriptPath.endsWith("bat"))) {
            return null;
        }
        if (interpreterPath != null && (path = FileUtil.toSystemDependentName((String)interpreterPath)).startsWith("\\\\wsl$\\")) {
            return (WSLDistribution)ContainerUtil.getFirstItem((List)WSLUtil.getAvailableDistributions());
        }
        if (scriptPath != null && (path = FileUtil.toSystemDependentName((String)scriptPath)).startsWith("\\\\wsl$\\")) {
            return (WSLDistribution)ContainerUtil.getFirstItem((List)WSLUtil.getAvailableDistributions());
        }
        return null;
    }
}

