/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.SimpleConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.sh.SHIcons;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShLanguage;
import com.intellij.sh.run.ShRunConfiguration;
import com.intellij.util.EnvironmentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShConfigurationType
extends SimpleConfigurationType {
    ShConfigurationType() {
        super("ShConfigurationType", ShLanguage.INSTANCE.getID(), ShBundle.message("sh.run.configuration.description.0.configuration", ShLanguage.INSTANCE.getID()), NotNullLazyValue.lazy(() -> SHIcons.ShFile));
    }

    @NotNull
    public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
        String projectPath;
        ShRunConfiguration configuration = new ShRunConfiguration(project, (ConfigurationFactory)this, ShLanguage.INSTANCE.getID());
        String defaultShell = ShConfigurationType.getDefaultShell();
        if (defaultShell != null) {
            configuration.setInterpreterPath(defaultShell);
        }
        if ((projectPath = project.getBasePath()) != null) {
            configuration.setScriptWorkingDirectory(projectPath);
        }
        return configuration;
    }

    public static ShConfigurationType getInstance() {
        return (ShConfigurationType)ConfigurationTypeUtil.findConfigurationType(ShConfigurationType.class);
    }

    public boolean isEditableInDumbMode() {
        return true;
    }

    @Nullable
    public static String getDefaultShell() {
        return EnvironmentUtil.getValue((String)"SHELL");
    }
}

