/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.rename;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.sh.highlighting.ShTextOccurrencesUtil;
import com.intellij.sh.rename.ShRenameDialog;
import com.intellij.sh.rename.ShTextRenameRefactoring;
import com.intellij.sh.rename.TextOccurrencesRenamer;
import java.util.Collection;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ShRenameAllOccurrencesHandler
extends EditorActionHandler {
    public static final ShRenameAllOccurrencesHandler INSTANCE = new ShRenameAllOccurrencesHandler();
    static final Key<TextOccurrencesRenamer> RENAMER_KEY = Key.create((String)"renamer");

    private ShRenameAllOccurrencesHandler() {
    }

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        return editor.getProject() != null;
    }

    public void doExecute(@NotNull Editor editor, @Nullable Caret c, DataContext dataContext) {
        ShTextRenameRefactoring rename;
        TextRange occurrenceAtCaret;
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        SelectionModel selectionModel = editor.getSelectionModel();
        boolean hasSelection = caret.hasSelection();
        TextRange textRange = occurrenceAtCaret = hasSelection ? new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()) : ShTextOccurrencesUtil.findTextRangeOfIdentifierAtCaret(editor);
        if (occurrenceAtCaret == null) {
            return;
        }
        CharSequence documentText = editor.getDocument().getImmutableCharSequence();
        CharSequence textToFind = occurrenceAtCaret.subSequence(documentText);
        Collection<TextRange> occurrences = ShTextOccurrencesUtil.findAllOccurrences(documentText, textToFind, !hasSelection);
        Project project = editor.getProject();
        assert (project != null);
        if (occurrences.size() < ShRenameAllOccurrencesHandler.getMaxInplaceRenameSegments() && documentText.length() < 0x100000 && (rename = ShTextRenameRefactoring.create(editor, project, textToFind.toString(), occurrences, occurrenceAtCaret)) != null) {
            rename.start();
            return;
        }
        TextOccurrencesRenamer renamer = new TextOccurrencesRenamer(editor, textToFind.toString(), occurrences, occurrenceAtCaret);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            editor.putUserData(RENAMER_KEY, (Object)renamer);
        } else {
            new ShRenameDialog(project, renamer).show();
        }
    }

    @NotNull
    static RegistryValue getMaxInplaceRenameSegmentsRegistryValue() {
        return Registry.get((String)"inplace.rename.segments.limit");
    }

    private static int getMaxInplaceRenameSegments() {
        try {
            return ShRenameAllOccurrencesHandler.getMaxInplaceRenameSegmentsRegistryValue().asInteger();
        }
        catch (MissingResourceException e) {
            return -1;
        }
    }
}

