/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.sh.psi.ShFunctionDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResolveUtil {
    public static boolean processChildren(@NotNull PsiElement element, @NotNull PsiScopeProcessor processor, @NotNull ResolveState substitutor, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        PsiElement[] children = element.getChildren();
        if (children.length == 0) {
            return true;
        }
        TextRange placeTextRange = place.getTextRange();
        for (int i = children.length - 1; i >= 0; --i) {
            PsiElement child = children[i];
            if (ResolveUtil.violateRestrictions(element) || ResolveUtil.violateTextRangeRestrictions(child.getTextRange(), placeTextRange) || child.processDeclarations(processor, substitutor, element, place)) continue;
            return false;
        }
        return true;
    }

    private static boolean violateTextRangeRestrictions(@NotNull TextRange elementTextRange, @NotNull TextRange lastParentTextRange) {
        return !elementTextRange.contains(lastParentTextRange) && elementTextRange.getEndOffset() > lastParentTextRange.getStartOffset();
    }

    private static boolean violateRestrictions(@NotNull PsiElement element) {
        return element instanceof ShFunctionDefinition;
    }
}

