/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.lexer;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergeFunction;
import com.intellij.lexer.MergingLexerAdapterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.sh.lexer.ShTokenTypes;
import com.intellij.sh.lexer._ShLexerGen;
import org.jetbrains.annotations.NotNull;

public class ShLexer
extends MergingLexerAdapterBase
implements ShTokenTypes {
    private static final MergeFunction FUNCTION = (type, lexer) -> {
        if (type != HEREDOC_CONTENT && type != STRING_CONTENT && type != PARAM_SEPARATOR && type != WORD) {
            return type;
        }
        if (type == WORD) {
            ShLexer.advanceLexerWhile(lexer, WORD);
            return WORD;
        }
        if (type == HEREDOC_CONTENT) {
            ShLexer.advanceLexerWhile(lexer, HEREDOC_CONTENT);
            return HEREDOC_CONTENT;
        }
        if (type == PARAM_SEPARATOR) {
            ShLexer.advanceLexerWhile(lexer, PARAM_SEPARATOR);
            return PARAM_SEPARATOR;
        }
        ShLexer.advanceLexerWhile(lexer, STRING_CONTENT);
        return STRING_CONTENT;
    };

    public ShLexer() {
        super((Lexer)new FlexAdapter((FlexLexer)new _ShLexerGen(null){

            @Override
            public void reset(CharSequence buffer, int start, int end, int initialState) {
                this.onReset();
                super.reset(buffer, start, end, initialState);
            }
        }));
    }

    public MergeFunction getMergeFunction() {
        return FUNCTION;
    }

    private static void advanceLexerWhile(@NotNull Lexer lexer, @NotNull IElementType condition) {
        IElementType current = lexer.getTokenType();
        while (current == condition) {
            lexer.advance();
            current = lexer.getTokenType();
        }
    }
}

