/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sh.highlighting.ShTextOccurrencesUtil;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShOccurrencesHighlightUsagesHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    ShOccurrencesHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file) {
        super(editor, file);
    }

    @NotNull
    public List<PsiElement> getTargets() {
        return Collections.singletonList(this.myFile);
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        selectionConsumer.consume(targets);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets) {
        TextRange textRange = ShTextOccurrencesUtil.findTextRangeOfIdentifierAtCaret(this.myEditor);
        if (textRange != null) {
            CharSequence documentText = StringUtil.newBombedCharSequence((CharSequence)this.myEditor.getDocument().getImmutableCharSequence(), (long)3000L);
            boolean hasSelection = this.myEditor.getCaretModel().getPrimaryCaret().hasSelection();
            ShTextOccurrencesUtil.consumeAllOccurrences(documentText, textRange.subSequence(documentText), !hasSelection, (Consumer<? super TextRange>)((Consumer)range -> this.myReadUsages.add(InjectedLanguageManager.getInstance((Project)this.myFile.getProject()).injectedToHost((PsiElement)this.myFile, range))));
        }
    }
}

