/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.sh.ShLanguage;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

abstract class ShBaseGenerateAction
extends CodeInsightAction
implements CodeInsightActionHandler {
    ShBaseGenerateAction() {
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        return file.getLanguage().is(ShLanguage.INSTANCE);
    }

    protected static void moveAtNewLineIfNeeded(@NotNull Editor editor) {
        Document document = editor.getDocument();
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        int line = caret.getLogicalPosition().line;
        if (DocumentUtil.isLineEmpty((Document)document, (int)line)) {
            return;
        }
        int lineEndOffset = DocumentUtil.getLineEndOffset((int)caret.getOffset(), (Document)document);
        caret.moveToOffset(lineEndOffset);
        EditorActionHandler actionHandler = EditorActionManager.getInstance().getActionHandler("EditorEnter");
        actionHandler.execute(editor, caret, EditorUtil.getEditorDataContext((Editor)editor));
    }
}

