/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.visuallint.analyzers;

import android.view.ViewGroup;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintErrorType;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.ViewWithParentBounds;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.WearMarginAnalyzerInspection;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/uibuilder/visual/visuallint/analyzers/WearMarginAnalyzer;", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer;", "()V", "backgroundEnabled", "", "getBackgroundEnabled", "()Z", "type", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "createIssueContent", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "findIssues", "", "renderResult", "Lcom/android/tools/idea/rendering/RenderResult;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "intellij.android.designer"})
public final class WearMarginAnalyzer
extends VisualLintAnalyzer {
    @NotNull
    public static final WearMarginAnalyzer INSTANCE = new WearMarginAnalyzer();

    private WearMarginAnalyzer() {
    }

    @Override
    @NotNull
    public VisualLintErrorType getType() {
        return VisualLintErrorType.WEAR_MARGIN;
    }

    @Override
    public boolean getBackgroundEnabled() {
        return WearMarginAnalyzerInspection.INSTANCE.getWearMarginBackground();
    }

    @Override
    @NotNull
    public List<VisualLintAnalyzer.VisualLintIssueContent> findIssues(@NotNull RenderResult renderResult, @NotNull NlModel model2) {
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        List issues = new ArrayList();
        ArrayDeque viewsToAnalyze = new ArrayDeque();
        Configuration configuration = model2.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"model.configuration");
        Configuration configuration2 = configuration;
        State state = configuration2.getDeviceState();
        Object object = state != null ? state.getOrientation() : null;
        if (object == null) {
            return issues;
        }
        ScreenOrientation orientation2 = object;
        Object object2 = configuration2.getDevice();
        if (object2 == null || (object2 = object2.getScreenSize(orientation2)) == null) {
            return issues;
        }
        int width2 = object2.width;
        Device device = configuration2.getDevice();
        boolean isRound = device != null ? device.isScreenRound() : false;
        double minPercent = isRound ? 0.052 : 0.025;
        double minLeft = minPercent * (double)width2;
        double maxRight = (double)width2 - minLeft;
        ImmutableList immutableList = renderResult.getRootViews();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"renderResult.rootViews");
        Iterable $this$forEach$iv = (Iterable)immutableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewInfo it = (ViewInfo)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            viewsToAnalyze.add((Object)new ViewWithParentBounds(it, 0, width2));
        }
        while (!((Collection)viewsToAnalyze).isEmpty()) {
            ViewWithParentBounds viewWithParentBounds = (ViewWithParentBounds)viewsToAnalyze.removeLast();
            int absoluteParentLeft = viewWithParentBounds.getAbsoluteParentLeft();
            int absoluteParentRight = viewWithParentBounds.getAbsoluteParentRight();
            if ((double)absoluteParentLeft >= minLeft && (double)absoluteParentRight <= maxRight) continue;
            ViewInfo view2 = viewWithParentBounds.getView();
            int absoluteViewLeft = view2.getLeft() + absoluteParentLeft;
            int absoluteViewRight = view2.getRight() + absoluteParentLeft;
            if (!((double)absoluteViewLeft < minLeft) && !((double)absoluteViewRight > maxRight)) continue;
            if (!(view2.getViewObject() instanceof ViewGroup)) {
                issues.add(this.createIssueContent(view2));
                continue;
            }
            List list = view2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"view.children");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                ViewInfo it = (ViewInfo)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                viewsToAnalyze.add((Object)new ViewWithParentBounds(it, absoluteViewLeft, absoluteViewRight));
            }
        }
        return issues;
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createIssueContent(ViewInfo view2) {
        String summary = "The view " + this.nameWithId(view2) + " is too close to the side of the device";
        Function1 provider2 = (Function1)new Function1<Integer, HtmlBuilder>(view2){
            final /* synthetic */ ViewInfo $view;
            {
                this.$view = $view;
                super(1);
            }

            public final HtmlBuilder invoke(int count) {
                return new HtmlBuilder().add("In " + WearMarginAnalyzer.access$previewConfigurations(WearMarginAnalyzer.INSTANCE, count) + ", the view " + WearMarginAnalyzer.access$simpleName(WearMarginAnalyzer.INSTANCE, this.$view) + " is closer to the side of the device than the recommended amount.").newline().add("It is recommended that, for Wear OS layouts, margins should be at least 2.5% for square devices, and 5.2% for round devices.");
            }
        };
        return new VisualLintAnalyzer.VisualLintIssueContent(view2, summary, (Function1<? super Integer, ? extends HtmlBuilder>)provider2);
    }

    public static final /* synthetic */ String access$previewConfigurations(WearMarginAnalyzer $this, int count) {
        return $this.previewConfigurations(count);
    }

    public static final /* synthetic */ String access$simpleName(WearMarginAnalyzer $this, ViewInfo view2) {
        return $this.simpleName(view2);
    }
}

