/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.visuallint.analyzers;

import android.widget.EditText;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintErrorType;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.TextFieldSizeAnalyzerInspection;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/uibuilder/visual/visuallint/analyzers/TextFieldSizeAnalyzer;", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer;", "()V", "backgroundEnabled", "", "getBackgroundEnabled", "()Z", "type", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "createIssueContent", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "findIssues", "", "renderResult", "Lcom/android/tools/idea/rendering/RenderResult;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "isWideTextField", "intellij.android.designer"})
public final class TextFieldSizeAnalyzer
extends VisualLintAnalyzer {
    @NotNull
    public static final TextFieldSizeAnalyzer INSTANCE = new TextFieldSizeAnalyzer();

    private TextFieldSizeAnalyzer() {
    }

    @Override
    @NotNull
    public VisualLintErrorType getType() {
        return VisualLintErrorType.TEXT_FIELD_SIZE;
    }

    @Override
    public boolean getBackgroundEnabled() {
        return TextFieldSizeAnalyzerInspection.INSTANCE.getTextFieldSizeBackground();
    }

    @Override
    @NotNull
    public List<VisualLintAnalyzer.VisualLintIssueContent> findIssues(@NotNull RenderResult renderResult, @NotNull NlModel model2) {
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        List issues = new ArrayList();
        ImmutableList immutableList = renderResult.getRootViews();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"renderResult.rootViews");
        ArrayDeque viewsToAnalyze = new ArrayDeque((Collection)immutableList);
        while (!((Collection)viewsToAnalyze).isEmpty()) {
            ViewInfo view2 = (ViewInfo)viewsToAnalyze.removeLast();
            List list = view2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"view.children");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ViewInfo it = (ViewInfo)element$iv;
                boolean bl = false;
                viewsToAnalyze.addLast((Object)it);
            }
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
            if (!this.isWideTextField(view2, model2)) continue;
            issues.add(this.createIssueContent(view2));
        }
        return issues;
    }

    private final boolean isWideTextField(ViewInfo view2, NlModel model2) {
        if (!(view2.getViewObject() instanceof EditText)) {
            return false;
        }
        int widthInDp = Coordinates.pxToDp(model2, view2.getRight() - view2.getLeft());
        return widthInDp > 488;
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createIssueContent(ViewInfo view2) {
        String summary = "The text field " + this.nameWithId(view2) + " is too wide";
        Function1 provider2 = (Function1)new Function1<Integer, HtmlBuilder>(view2){
            final /* synthetic */ ViewInfo $view;
            {
                this.$view = $view;
                super(1);
            }

            public final HtmlBuilder invoke(int count) {
                return new HtmlBuilder().add("The text field " + TextFieldSizeAnalyzer.access$simpleName(TextFieldSizeAnalyzer.INSTANCE, this.$view) + " is wider than 488dp in " + TextFieldSizeAnalyzer.access$previewConfigurations(TextFieldSizeAnalyzer.INSTANCE, count) + ".").newline().add("Material Design recommends text fields to be no wider than 488dp");
            }
        };
        return new VisualLintAnalyzer.VisualLintIssueContent(view2, summary, (Function1<? super Integer, ? extends HtmlBuilder>)provider2);
    }

    public static final /* synthetic */ String access$simpleName(TextFieldSizeAnalyzer $this, ViewInfo view2) {
        return $this.simpleName(view2);
    }

    public static final /* synthetic */ String access$previewConfigurations(TextFieldSizeAnalyzer $this, int count) {
        return $this.previewConfigurations(count);
    }
}

