/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.visuallint.analyzers;

import android.graphics.Rect;
import android.text.Layout;
import android.text.TextPaint;
import android.widget.TextView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderContext;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintBaseConfigIssues;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintErrorType;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.LocaleAnalyzerInspection;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0017\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\"J\u0012\u0010#\u001a\u00020\u00062\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006("}, d2={"Lcom/android/tools/idea/uibuilder/visual/visuallint/analyzers/LocaleAnalyzer;", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer;", "baseConfigIssues", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintBaseConfigIssues;", "(Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintBaseConfigIssues;)V", "backgroundEnabled", "", "getBackgroundEnabled", "()Z", "type", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "buildMap", "", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "createEllipsizedIssue", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "locale", "", "createTextTooBigIssue", "value", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintBaseConfigIssues$BaseConfigComponentState;", "findIssues", "", "renderResult", "Lcom/android/tools/idea/rendering/RenderResult;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "findLocaleIssues", "getKey", "", "root", "(Lcom/android/ide/common/rendering/api/ViewInfo;)Ljava/lang/Integer;", "isBaseConfig", "config", "Lcom/android/tools/idea/configurations/Configuration;", "isEllipsized", "isTextTooBig", "intellij.android.designer"})
public final class LocaleAnalyzer
extends VisualLintAnalyzer {
    @NotNull
    private final VisualLintBaseConfigIssues baseConfigIssues;

    public LocaleAnalyzer(@NotNull VisualLintBaseConfigIssues baseConfigIssues) {
        Intrinsics.checkNotNullParameter((Object)baseConfigIssues, (String)"baseConfigIssues");
        this.baseConfigIssues = baseConfigIssues;
    }

    @Override
    @NotNull
    public VisualLintErrorType getType() {
        return VisualLintErrorType.LOCALE_TEXT;
    }

    @Override
    public boolean getBackgroundEnabled() {
        return LocaleAnalyzerInspection.INSTANCE.getLocaleBackground();
    }

    @Override
    @NotNull
    public List<VisualLintAnalyzer.VisualLintIssueContent> findIssues(@NotNull RenderResult renderResult, @NotNull NlModel model2) {
        Configuration config;
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        List issues = new ArrayList();
        RenderContext renderContext = renderResult.getRenderContext();
        Object object = config = renderContext != null ? renderContext.getConfiguration() : null;
        if (this.isBaseConfig(config)) {
            ImmutableList immutableList = renderResult.getRootViews();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"renderResult.rootViews");
            ArrayDeque viewsToAnalyze = new ArrayDeque((Collection)immutableList);
            while (!((Collection)viewsToAnalyze).isEmpty()) {
                ViewInfo view2 = (ViewInfo)viewsToAnalyze.removeLast();
                List list = view2.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"view.children");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ViewInfo it = (ViewInfo)element$iv;
                    boolean bl = false;
                    viewsToAnalyze.addLast((Object)it);
                }
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
                this.buildMap(view2, this.baseConfigIssues);
            }
        } else {
            ImmutableList immutableList = renderResult.getRootViews();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"renderResult.rootViews");
            ArrayDeque viewsToAnalyze = new ArrayDeque((Collection)immutableList);
            while (!((Collection)viewsToAnalyze).isEmpty()) {
                ViewInfo view3 = (ViewInfo)viewsToAnalyze.removeLast();
                List list = view3.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"view.children");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ViewInfo it = (ViewInfo)element$iv;
                    boolean bl = false;
                    viewsToAnalyze.addLast((Object)it);
                }
                Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"view");
                issues.addAll((Collection)this.findLocaleIssues(view3, this.baseConfigIssues, model2));
            }
        }
        return issues;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildMap(ViewInfo view2, VisualLintBaseConfigIssues baseConfigIssues) {
        block2: {
            Object object;
            void $this$getOrPut$iv;
            Integer n = this.getKey(view2);
            if (n == null) break block2;
            int key = ((Number)n).intValue();
            boolean bl = false;
            Map<Integer, VisualLintBaseConfigIssues.BaseConfigComponentState> map = baseConfigIssues.getComponentState();
            Integer key$iv = key;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                VisualLintBaseConfigIssues.BaseConfigComponentState answer$iv = new VisualLintBaseConfigIssues.BaseConfigComponentState(false, false, 3, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((VisualLintBaseConfigIssues.BaseConfigComponentState)object).setHasI18NEllipsis(this.isEllipsized(view2));
            VisualLintBaseConfigIssues.BaseConfigComponentState baseConfigComponentState = baseConfigIssues.getComponentState().get(key);
            Intrinsics.checkNotNull((Object)baseConfigComponentState);
            baseConfigComponentState.setHasI18NTextTooBig(this.isTextTooBig(view2));
        }
    }

    private final Integer getKey(ViewInfo root) {
        Object object = root.getCookie();
        TagSnapshot tagSnapshot = object instanceof TagSnapshot ? (TagSnapshot)object : null;
        return tagSnapshot != null && (tagSnapshot = tagSnapshot.tag) != null ? Integer.valueOf(tagSnapshot.hashCode()) : null;
    }

    private final boolean isBaseConfig(Configuration config) {
        Configuration configuration = config;
        return Intrinsics.areEqual((Object)(configuration != null && (configuration = configuration.getLocale()) != null ? configuration.toString() : null), (Object)"__");
    }

    private final List<VisualLintAnalyzer.VisualLintIssueContent> findLocaleIssues(ViewInfo view2, VisualLintBaseConfigIssues baseConfigIssues, NlModel model2) {
        List issues = new ArrayList();
        Integer n = this.getKey(view2);
        if (n == null) {
            return issues;
        }
        int key = n;
        VisualLintBaseConfigIssues.BaseConfigComponentState value2 = baseConfigIssues.getComponentState().get(key);
        String string = model2.getConfiguration().getLocale().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"model.configuration.locale.toString()");
        String locale = string;
        if (this.isEllipsized(view2) && value2 != null && !value2.getHasI18NEllipsis()) {
            issues.add(this.createEllipsizedIssue(view2, locale));
        } else if (this.isTextTooBig(view2) && (value2 == null || !value2.getHasI18NTextTooBig())) {
            issues.add(this.createTextTooBigIssue(value2, view2, locale));
        }
        return issues;
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createEllipsizedIssue(ViewInfo view2, String locale) {
        String summary = "The text is ellipsized in locale \"" + locale + "\".";
        HtmlBuilder content2 = new HtmlBuilder().add("The text is ellipsized in locale \"" + locale + "\" but not in default locale.").newline().add("This might not be the intended behaviour. Consider increasing the text view size.");
        return new VisualLintAnalyzer.VisualLintIssueContent(view2, summary, (Function1<? super Integer, ? extends HtmlBuilder>)((Function1)new Function1<Integer, HtmlBuilder>(content2){
            final /* synthetic */ HtmlBuilder $content;
            {
                this.$content = $content;
                super(1);
            }

            @NotNull
            public final HtmlBuilder invoke(int it) {
                HtmlBuilder htmlBuilder = this.$content;
                Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"content");
                return htmlBuilder;
            }
        }));
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createTextTooBigIssue(VisualLintBaseConfigIssues.BaseConfigComponentState value2, ViewInfo view2, String locale) {
        String summary = "The text might be cut off.";
        HtmlBuilder content2 = value2 == null ? new HtmlBuilder().add("The text is too large in locale \"" + locale + "\" to fit inside the TextView.") : new HtmlBuilder().add("The text is too large in locale \"" + locale + "\" to fit inside the TextView.").newline().add("This behavior is different from default locale and might not be intended behavior.");
        return new VisualLintAnalyzer.VisualLintIssueContent(view2, summary, (Function1<? super Integer, ? extends HtmlBuilder>)((Function1)new Function1<Integer, HtmlBuilder>(content2){
            final /* synthetic */ HtmlBuilder $content;
            {
                this.$content = $content;
                super(1);
            }

            @NotNull
            public final HtmlBuilder invoke(int it) {
                HtmlBuilder htmlBuilder = this.$content;
                Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"content");
                return htmlBuilder;
            }
        }));
    }

    private final boolean isEllipsized(ViewInfo view2) {
        boolean bl;
        block4: {
            if (!(view2.getViewObject() instanceof TextView)) {
                return false;
            }
            Object object = view2.getViewObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.widget.TextView");
            TextView textView = (TextView)object;
            Layout layout2 = textView.getLayout();
            int lines = layout2.getLineCount();
            Iterable $this$any$iv = (Iterable)RangesKt.downTo((int)(lines - 1), (int)0);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(layout2.getEllipsisCount(it) > 0)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isTextTooBig(ViewInfo view2) {
        if (!(view2.getViewObject() instanceof TextView)) {
            return false;
        }
        Object object = view2.getViewObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.widget.TextView");
        TextView textView = (TextView)object;
        TextPaint paint = textView.getPaint();
        CharSequence text = textView.getText();
        int lineHeight = textView.getLineHeight();
        int lineCount = textView.getLineCount();
        int requiredTextBoundsHeight = lineHeight * lineCount;
        if (requiredTextBoundsHeight > textView.getHeight()) {
            return true;
        }
        int requiredTextBoundsWidth = 0;
        for (int line = 0; line < lineCount; ++line) {
            int start = textView.getLayout().getLineStart(line);
            int end = textView.getLayout().getLineEnd(line);
            Rect rect = new Rect();
            paint.getTextBounds(text, start, end, rect);
            requiredTextBoundsWidth = RangesKt.coerceAtLeast((int)requiredTextBoundsWidth, (int)rect.width());
        }
        return requiredTextBoundsWidth > textView.getWidth();
    }
}

