/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.visuallint;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.RenderAsyncActionExecutor;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.uibuilder.scene.NlModelHierarchyUpdater;
import com.android.tools.idea.uibuilder.visual.WearDeviceModelsProvider;
import com.android.tools.idea.uibuilder.visual.WindowSizeModelsProvider;
import com.android.tools.idea.uibuilder.visual.analytics.VisualLintUsageTracker;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintBaseConfigIssues;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintErrorType;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintIssueProvider;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintRenderIssue;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintServiceKt;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.AtfAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.BottomAppBarAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.BottomNavAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.BoundsAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.ButtonSizeAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.LocaleAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.LongTextAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.OverlapAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.TextFieldSizeAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.WearMarginAnalyzer;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u0015H\u0016J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000bH\u0002J\u0006\u0010'\u001a\u00020\u0015J6\u0010(\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J$\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u00172\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0006J.\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u00172\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00062\u0006\u0010.\u001a\u00020/H\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "adaptiveAnalyzers", "", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer;", "basicAnalyzers", "ignoredTypes", "", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "issueModel", "Lcom/android/tools/idea/common/error/IssueModel;", "getIssueModel", "()Lcom/android/tools/idea/common/error/IssueModel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "wearAnalyzers", "Lcom/android/tools/idea/uibuilder/visual/visuallint/analyzers/WearMarginAnalyzer;", "analyzeAfterModelUpdate", "", "targetIssueProvider", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintIssueProvider;", "result", "Lcom/android/tools/idea/rendering/RenderResult;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "baseConfigIssues", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintBaseConfigIssues;", "runningInBackground", "", "dispose", "getIgnoredTypesFromProfile", "profile", "Lcom/intellij/codeInspection/InspectionProfile;", "getSeverity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "type", "removeAllIssueProviders", "runAnalyzers", "analyzers", "runVisualLintAnalysis", "parentDisposable", "issueProvider", "models", "executorService", "Ljava/util/concurrent/ExecutorService;", "Companion", "intellij.android.designer"})
public final class VisualLintService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final IssueModel issueModel;
    @NotNull
    private final List<VisualLintAnalyzer> basicAnalyzers;
    @NotNull
    private final List<VisualLintAnalyzer> adaptiveAnalyzers;
    @NotNull
    private final List<WearMarginAnalyzer> wearAnalyzers;
    @NotNull
    private final List<VisualLintErrorType> ignoredTypes;

    public VisualLintService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.issueModel = new IssueModel(this, this.project);
        Object[] objectArray = new VisualLintAnalyzer[]{BoundsAnalyzer.INSTANCE, OverlapAnalyzer.INSTANCE, AtfAnalyzer.INSTANCE};
        this.basicAnalyzers = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new VisualLintAnalyzer[]{BottomNavAnalyzer.INSTANCE, BottomAppBarAnalyzer.INSTANCE, TextFieldSizeAnalyzer.INSTANCE, LongTextAnalyzer.INSTANCE, ButtonSizeAnalyzer.INSTANCE};
        this.adaptiveAnalyzers = CollectionsKt.listOf((Object[])objectArray);
        this.wearAnalyzers = CollectionsKt.listOf((Object)WearMarginAnalyzer.INSTANCE);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect()");
        MessageBusConnection connection = messageBusConnection;
        this.ignoredTypes = new ArrayList();
        InspectionProfileImpl inspectionProfileImpl = InspectionProfileManager.getInstance((Project)this.project).getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getInstance(project).currentProfile");
        this.getIgnoredTypesFromProfile((InspectionProfile)inspectionProfileImpl);
        Topic topic = ProfileChangeAdapter.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new ProfileChangeAdapter(){

            public void profileActivated(@Nullable InspectionProfile oldProfile, @Nullable InspectionProfile profile) {
                block0: {
                    InspectionProfile inspectionProfile = profile;
                    if (inspectionProfile == null) break block0;
                    InspectionProfile inspectionProfile2 = inspectionProfile;
                    VisualLintService visualLintService = this;
                    InspectionProfile it = inspectionProfile2;
                    boolean bl = false;
                    visualLintService.getIgnoredTypesFromProfile(it);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void profileChanged(@NotNull InspectionProfile profile) {
                void $this$filterNotTo$iv$iv;
                Object element$iv2;
                Iterator $this$filterNotTo$iv$iv2;
                Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
                List oldIgnoredTypes = CollectionsKt.toList((Iterable)ignoredTypes);
                this.getIgnoredTypesFromProfile(profile);
                Iterable $this$filterNot$iv = ignoredTypes;
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                Iterator iterator = $this$filterNotTo$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    VisualLintErrorType it = (VisualLintErrorType)((Object)element$iv$iv);
                    boolean bl = false;
                    if (oldIgnoredTypes.contains((Object)it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach22 = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    VisualLintErrorType it = (VisualLintErrorType)((Object)element$iv2);
                    boolean bl = false;
                    VisualLintUsageTracker.Companion.getInstance().trackRuleStatusChanged(it, false);
                }
                $this$forEach$iv = oldIgnoredTypes;
                VisualLintService $i$f$forEach22 = this;
                boolean $i$f$filterNot2 = false;
                element$iv2 = $this$filterNot$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterNotTo2 = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    VisualLintErrorType it = (VisualLintErrorType)((Object)element$iv$iv);
                    boolean bl = false;
                    if ($i$f$forEach22.ignoredTypes.contains((Object)it)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$forEach$iv = (List)destination$iv$iv2;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    VisualLintErrorType it = (VisualLintErrorType)((Object)element$iv2);
                    boolean bl = false;
                    VisualLintUsageTracker.Companion.getInstance().trackRuleStatusChanged(it, true);
                }
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final IssueModel getIssueModel() {
        return this.issueModel;
    }

    private final void getIgnoredTypesFromProfile(InspectionProfile profile) {
        this.ignoredTypes.clear();
        for (VisualLintErrorType type : VisualLintErrorType.values()) {
            boolean enabled = profile.isToolEnabled(HighlightDisplayKey.find((String)type.getShortName()));
            if (enabled) continue;
            this.ignoredTypes.add(type);
        }
    }

    public final void runVisualLintAnalysis(@NotNull Disposable parentDisposable, @NotNull VisualLintIssueProvider issueProvider2, @NotNull List<? extends NlModel> models2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)issueProvider2, (String)"issueProvider");
        Intrinsics.checkNotNullParameter(models2, (String)"models");
        this.runVisualLintAnalysis(parentDisposable, issueProvider2, models2, VisualLintServiceKt.access$getVisualLintExecutorService$p());
    }

    @VisibleForTesting
    public final void runVisualLintAnalysis(@NotNull Disposable parentDisposable, @NotNull VisualLintIssueProvider issueProvider2, @NotNull List<? extends NlModel> models2, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)issueProvider2, (String)"issueProvider");
        Intrinsics.checkNotNullParameter(models2, (String)"models");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        CompletableFuture.runAsync(new Runnable(this, issueProvider2, parentDisposable, models2){
            final /* synthetic */ VisualLintService this$0;
            final /* synthetic */ VisualLintIssueProvider $issueProvider;
            final /* synthetic */ Disposable $parentDisposable;
            final /* synthetic */ List<NlModel> $models;
            {
                this.this$0 = $receiver;
                this.$issueProvider = $issueProvider;
                this.$parentDisposable = $parentDisposable;
                this.$models = $models;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                this.this$0.removeAllIssueProviders();
                this.$issueProvider.clear();
                Disposer.register((Disposable)this.$parentDisposable, (Disposable)new Disposable(this.this$0, this.$issueProvider){
                    final /* synthetic */ VisualLintService this$0;
                    final /* synthetic */ VisualLintIssueProvider $issueProvider;
                    {
                        this.this$0 = $receiver;
                        this.$issueProvider = $issueProvider;
                    }

                    public final void dispose() {
                        this.this$0.getIssueModel().removeIssueProvider(this.$issueProvider);
                    }
                });
                this.this$0.getIssueModel().addIssueProvider(this.$issueProvider, true);
                if (this.$models.isEmpty()) {
                    return;
                }
                NlModel displayingModel = this.$models.get(0);
                ModelListener listener2 = new ModelListener(){

                    public void modelChanged(@NotNull NlModel model2) {
                        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
                        int numberOfCancelledActions = RenderService.getRenderAsyncActionExecutor().cancelLowerPriorityActions(RenderAsyncActionExecutor.RenderingPriority.LOW);
                        if (numberOfCancelledActions > 0) {
                            VisualLintUsageTracker.Companion.getInstance().trackCancelledBackgroundAnalysis();
                        }
                    }
                };
                displayingModel.addListener(listener2);
                try {
                    List<NlModel> list;
                    if (HardwareConfigHelper.isWear((Device)displayingModel.getConfiguration().getDevice())) {
                        Disposable disposable2 = displayingModel;
                        XmlFile xmlFile = displayingModel.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"displayingModel.file");
                        PsiFile psiFile2 = (PsiFile)xmlFile;
                        AndroidFacet androidFacet = displayingModel.getFacet();
                        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"displayingModel.facet");
                        list = WearDeviceModelsProvider.INSTANCE.createNlModels(disposable2, psiFile2, androidFacet);
                    } else {
                        Disposable disposable3 = displayingModel;
                        XmlFile xmlFile = displayingModel.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"displayingModel.file");
                        PsiFile psiFile3 = (PsiFile)xmlFile;
                        AndroidFacet androidFacet = displayingModel.getFacet();
                        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"displayingModel.facet");
                        list = WindowSizeModelsProvider.INSTANCE.createNlModels(disposable3, psiFile3, androidFacet);
                    }
                    List<NlModel> modelsToAnalyze = list;
                    CountDownLatch latch = new CountDownLatch(modelsToAnalyze.size());
                    VisualLintBaseConfigIssues visualLintBaseConfigIssues = new VisualLintBaseConfigIssues();
                    for (NlModel model2 : modelsToAnalyze) {
                        Object object = StudioFlags.NELE_ATF_IN_VISUAL_LINT.get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NELE_ATF_IN_VISUAL_LINT.get()");
                        boolean requireRender = (Boolean)object != false && !VisualLintService.access$getIgnoredTypes$p(this.this$0).contains((Object)((Object)VisualLintErrorType.ATF));
                        VisualLintServiceKt.createRenderResult(model2, requireRender).handleAsync(new BiFunction(model2, this.this$0, this.$issueProvider, visualLintBaseConfigIssues, latch){
                            final /* synthetic */ NlModel $model;
                            final /* synthetic */ VisualLintService this$0;
                            final /* synthetic */ VisualLintIssueProvider $issueProvider;
                            final /* synthetic */ VisualLintBaseConfigIssues $visualLintBaseConfigIssues;
                            final /* synthetic */ CountDownLatch $latch;
                            {
                                this.$model = $model;
                                this.this$0 = $receiver;
                                this.$issueProvider = $issueProvider;
                                this.$visualLintBaseConfigIssues = $visualLintBaseConfigIssues;
                                this.$latch = $latch;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void apply(RenderResult result, Throwable throwable) {
                                try {
                                    if (result != null) {
                                        NlModelHierarchyUpdater.updateHierarchy(result, this.$model);
                                        this.this$0.analyzeAfterModelUpdate(this.$issueProvider, result, this.$model, this.$visualLintBaseConfigIssues, true);
                                    }
                                }
                                finally {
                                    Disposer.dispose((Disposable)this.$model);
                                    this.$latch.countDown();
                                }
                            }
                        }, (Executor)VisualLintServiceKt.access$getVisualLintAnalyzerExecutorService$p());
                    }
                    latch.await(VisualLintServiceKt.access$getVisualLintTimeout$p(), TimeUnit.SECONDS);
                    this.this$0.getIssueModel().updateErrorsList();
                    VisualLintServiceKt.access$getLOG$p().debug("Visual Lint analysis finished, " + this.this$0.getIssueModel().getIssueCount() + " " + (this.this$0.getIssueModel().getIssueCount() > 1 ? "errors" : "error") + " found");
                }
                finally {
                    displayingModel.removeListener(listener2);
                }
            }
        }, executorService);
    }

    public final void analyzeAfterModelUpdate(@NotNull VisualLintIssueProvider targetIssueProvider, @NotNull RenderResult result, @NotNull NlModel model2, @NotNull VisualLintBaseConfigIssues baseConfigIssues, boolean runningInBackground) {
        Intrinsics.checkNotNullParameter((Object)targetIssueProvider, (String)"targetIssueProvider");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)baseConfigIssues, (String)"baseConfigIssues");
        this.runAnalyzers(targetIssueProvider, this.basicAnalyzers, result, model2, runningInBackground);
        if (HardwareConfigHelper.isWear((Device)model2.getConfiguration().getDevice())) {
            this.runAnalyzers(targetIssueProvider, this.wearAnalyzers, result, model2, runningInBackground);
        } else {
            this.runAnalyzers(targetIssueProvider, this.adaptiveAnalyzers, result, model2, runningInBackground);
            if (!this.ignoredTypes.contains((Object)VisualLintErrorType.LOCALE_TEXT)) {
                LocaleAnalyzer it = new LocaleAnalyzer(baseConfigIssues);
                boolean bl = false;
                targetIssueProvider.addAllIssues(it.getType(), it.analyze(result, model2, this.getSeverity(it.getType()), runningInBackground));
            }
        }
    }

    public static /* synthetic */ void analyzeAfterModelUpdate$default(VisualLintService visualLintService, VisualLintIssueProvider visualLintIssueProvider, RenderResult renderResult, NlModel nlModel, VisualLintBaseConfigIssues visualLintBaseConfigIssues, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        visualLintService.analyzeAfterModelUpdate(visualLintIssueProvider, renderResult, nlModel, visualLintBaseConfigIssues, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void runAnalyzers(VisualLintIssueProvider targetIssueProvider, List<? extends VisualLintAnalyzer> analyzers, RenderResult result, NlModel model2, boolean runningInBackground) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = analyzers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VisualLintAnalyzer it = (VisualLintAnalyzer)element$iv$iv;
            boolean bl = false;
            if (!(!this.ignoredTypes.contains((Object)it.getType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualLintAnalyzer it = (VisualLintAnalyzer)element$iv;
            boolean bl = false;
            List<VisualLintRenderIssue> issues = it.analyze(result, model2, this.getSeverity(it.getType()), runningInBackground);
            targetIssueProvider.addAllIssues(it.getType(), issues);
        }
    }

    private final HighlightSeverity getSeverity(VisualLintErrorType type) {
        HighlightSeverity highlightSeverity;
        HighlightSeverity highlightSeverity2;
        HighlightSeverity highlightSeverity3;
        HighlightDisplayKey key;
        HighlightDisplayKey highlightDisplayKey = key = HighlightDisplayKey.find((String)type.getShortName());
        if (highlightDisplayKey != null) {
            HighlightDisplayKey it = highlightDisplayKey;
            boolean bl = false;
            highlightSeverity3 = InspectionProfileManager.getInstance((Project)this.project).getCurrentProfile().getErrorLevel(it, null).getSeverity();
        } else {
            highlightSeverity3 = highlightSeverity2 = null;
        }
        if (highlightSeverity2 == null) {
            HighlightSeverity highlightSeverity4 = HighlightSeverity.WARNING;
            highlightSeverity = highlightSeverity4;
            Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity4, (String)"WARNING");
        } else {
            highlightSeverity = highlightSeverity2;
        }
        return highlightSeverity;
    }

    public final void removeAllIssueProviders() {
        this.issueModel.removeAllIssueProviders();
        this.issueModel.updateErrorsList();
    }

    public void dispose() {
        this.issueModel.removeAllIssueProviders();
    }

    @JvmStatic
    @NotNull
    public static final VisualLintService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintService$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final VisualLintService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(VisualLintService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(VisualLintService::class.java)");
            return (VisualLintService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

