/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.analytics;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.common.analytics.CommonUsageTrackerKt;
import com.android.tools.idea.uibuilder.visual.analytics.VisualLintUsageTracker;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintErrorType;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.VisualLintEvent;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/uibuilder/visual/analytics/VisualLintUsageTrackerImpl;", "Lcom/android/tools/idea/uibuilder/visual/analytics/VisualLintUsageTracker;", "()V", "executorService", "Ljava/util/concurrent/ThreadPoolExecutor;", "track", "", "issueEvent", "Lcom/google/wireless/android/sdk/stats/VisualLintEvent$IssueEvent;", "issueType", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "intellij.android.designer"})
final class VisualLintUsageTrackerImpl
implements VisualLintUsageTracker {
    @NotNull
    public static final VisualLintUsageTrackerImpl INSTANCE = new VisualLintUsageTrackerImpl();
    @NotNull
    private static final ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue(10));

    private VisualLintUsageTrackerImpl() {
    }

    @Override
    public void track(@NotNull VisualLintEvent.IssueEvent issueEvent, @Nullable VisualLintErrorType issueType, @Nullable AndroidFacet facet) {
        VisualLintEvent.IssueType issueType2;
        VisualLintErrorType visualLintErrorType;
        Intrinsics.checkNotNullParameter((Object)issueEvent, (String)"issueEvent");
        VisualLintErrorType visualLintErrorType2 = visualLintErrorType = issueType;
        switch (visualLintErrorType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[visualLintErrorType2.ordinal()]) {
            case 1: {
                issueType2 = VisualLintEvent.IssueType.BOUNDS;
                break;
            }
            case 2: {
                issueType2 = VisualLintEvent.IssueType.BOTTOM_NAV;
                break;
            }
            case 3: {
                issueType2 = VisualLintEvent.IssueType.BOTTOM_APP_BAR;
                break;
            }
            case 4: {
                issueType2 = VisualLintEvent.IssueType.OVERLAP;
                break;
            }
            case 5: {
                issueType2 = VisualLintEvent.IssueType.LONG_TEXT;
                break;
            }
            case 6: {
                issueType2 = VisualLintEvent.IssueType.ATF;
                break;
            }
            case 7: {
                issueType2 = VisualLintEvent.IssueType.LOCALE_TEXT;
                break;
            }
            case 8: {
                issueType2 = VisualLintEvent.IssueType.TEXT_FIELD_SIZE;
                break;
            }
            case 9: {
                issueType2 = VisualLintEvent.IssueType.BUTTON_SIZE;
                break;
            }
            case 10: {
                issueType2 = VisualLintEvent.IssueType.WEAR_MARGIN;
                break;
            }
            default: {
                issueType2 = VisualLintEvent.IssueType.UNKNOWN_TYPE;
            }
        }
        VisualLintEvent.IssueType metricsIssueType = issueType2;
        try {
            executorService.execute(new Runnable(metricsIssueType, issueEvent, facet){
                final /* synthetic */ VisualLintEvent.IssueType $metricsIssueType;
                final /* synthetic */ VisualLintEvent.IssueEvent $issueEvent;
                final /* synthetic */ AndroidFacet $facet;
                {
                    this.$metricsIssueType = $metricsIssueType;
                    this.$issueEvent = $issueEvent;
                    this.$facet = $facet;
                }

                public final void run() {
                    VisualLintEvent.Builder visualLintEventBuilder = VisualLintEvent.newBuilder().setIssueType(this.$metricsIssueType).setIssueEvent(this.$issueEvent);
                    LayoutEditorEvent.Builder layoutEditorEventBuilder = LayoutEditorEvent.newBuilder().setType(LayoutEditorEvent.LayoutEditorEventType.VISUAL_LINT).setVisualLintEvent(visualLintEventBuilder.build());
                    AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.LAYOUT_EDITOR).setKind(AndroidStudioEvent.EventKind.LAYOUT_EDITOR_EVENT).setLayoutEditorEvent(layoutEditorEventBuilder.build());
                    AndroidFacet androidFacet = this.$facet;
                    if (androidFacet != null) {
                        AndroidFacet it = androidFacet;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)studioEvent, (String)"studioEvent");
                        CommonUsageTrackerKt.setApplicationId(studioEvent, it);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)studioEvent, (String)"studioEvent");
                    UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VisualLintErrorType.values().length];
            nArray[VisualLintErrorType.BOUNDS.ordinal()] = 1;
            nArray[VisualLintErrorType.BOTTOM_NAV.ordinal()] = 2;
            nArray[VisualLintErrorType.BOTTOM_APP_BAR.ordinal()] = 3;
            nArray[VisualLintErrorType.OVERLAP.ordinal()] = 4;
            nArray[VisualLintErrorType.LONG_TEXT.ordinal()] = 5;
            nArray[VisualLintErrorType.ATF.ordinal()] = 6;
            nArray[VisualLintErrorType.LOCALE_TEXT.ordinal()] = 7;
            nArray[VisualLintErrorType.TEXT_FIELD_SIZE.ordinal()] = 8;
            nArray[VisualLintErrorType.BUTTON_SIZE.ordinal()] = 9;
            nArray[VisualLintErrorType.WEAR_MARGIN.ordinal()] = 10;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

