/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.common.editor.DesignToolsSplitEditor;
import com.android.tools.idea.common.editor.DesignerEditor;
import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceShortcut;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.InteractionHandlerKt;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.editor.LayoutNavigationManager;
import com.android.tools.idea.uibuilder.surface.PanInteraction;
import com.android.tools.idea.uibuilder.visual.CustomModelsProvider;
import com.android.tools.idea.uibuilder.visual.RemoveCustomModelAction;
import com.android.tools.idea.uibuilder.visual.VisualizationModelsProvider;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J$\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0001\u0010\u0012\u001a\u00020\u0010H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J$\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0001\u0010\u0012\u001a\u00020\u0010H\u0016J\"\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00102\b\b\u0001\u0010\u0012\u001a\u00020\u0010H\u0016J$\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0001\u0010\u0012\u001a\u00020\u0010H\u0016J\"\u0010\u001f\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0001\u0010\u0012\u001a\u00020\u0010H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\tH\u0016J\"\u0010%\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00102\b\b\u0001\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020(H\u0016J\"\u0010)\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00102\b\b\u0001\u0010\u0012\u001a\u00020\u0010H\u0016J\u0018\u0010*\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J \u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/idea/uibuilder/visual/VisualizationInteractionHandler;", "Lcom/android/tools/idea/common/surface/InteractionHandler;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "getModelsProviderFunc", "Lkotlin/Function0;", "Lcom/android/tools/idea/uibuilder/visual/VisualizationModelsProvider;", "(Lcom/android/tools/idea/common/surface/DesignSurface;Lkotlin/jvm/functions/Function0;)V", "applyConfiguration", "", "destination", "Lcom/android/tools/idea/configurations/Configuration;", "source", "createInteractionOnDrag", "Lcom/android/tools/idea/common/surface/Interaction;", "mouseX", "", "mouseY", "modifiersEx", "createInteractionOnDragEnter", "dragEvent", "Ljava/awt/dnd/DropTargetDragEvent;", "createInteractionOnMouseWheelMoved", "mouseWheelEvent", "Ljava/awt/event/MouseWheelEvent;", "createInteractionOnPressed", "doubleClick", "x", "y", "getCursorWhenNoInteraction", "Ljava/awt/Cursor;", "hoverWhenNoInteraction", "keyPressedWithoutInteraction", "keyEvent", "Ljava/awt/event/KeyEvent;", "keyReleasedWithoutInteraction", "mouseExited", "mouseReleaseWhenNoInteraction", "popupMenuTrigger", "mouseEvent", "Ljava/awt/event/MouseEvent;", "singleClick", "stayHovering", "zoom", "type", "Lcom/android/tools/adtui/actions/ZoomType;", "intellij.android.designer"})
public final class VisualizationInteractionHandler
implements InteractionHandler {
    @NotNull
    private final DesignSurface<?> surface;
    @NotNull
    private final Function0<VisualizationModelsProvider> getModelsProviderFunc;

    public VisualizationInteractionHandler(@NotNull DesignSurface<?> surface2, @NotNull Function0<? extends VisualizationModelsProvider> getModelsProviderFunc) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        Intrinsics.checkNotNullParameter(getModelsProviderFunc, (String)"getModelsProviderFunc");
        this.surface = surface2;
        this.getModelsProviderFunc = getModelsProviderFunc;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnPressed(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        return null;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDrag(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        return null;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDragEnter(@NotNull DropTargetDragEvent dragEvent) {
        Intrinsics.checkNotNullParameter((Object)dragEvent, (String)"dragEvent");
        return null;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnMouseWheelMoved(@NotNull MouseWheelEvent mouseWheelEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseWheelEvent, (String)"mouseWheelEvent");
        return null;
    }

    @Override
    public void mouseReleaseWhenNoInteraction(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
    }

    @Override
    public void singleClick(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        SceneView sceneView = this.surface.getSceneViewAt(x, y);
        if (sceneView == null) {
            return;
        }
        SceneView view2 = sceneView;
        int xDp = Coordinates.getAndroidXDip(view2, x);
        int yDp = Coordinates.getAndroidYDip(view2, y);
        SceneComponent sceneComponent = view2.getScene().findComponent(view2.getContext(), xDp, yDp);
        if (sceneComponent == null) {
            return;
        }
        SceneComponent clickedComponent = sceneComponent;
        NlComponent nlComponent = clickedComponent.getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"clickedComponent.nlComponent");
        InteractionHandlerKt.navigateToComponent(nlComponent, false);
    }

    @Override
    public void doubleClick(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        SceneView sceneView = this.surface.getSceneViewAt(x, y);
        if (sceneView == null) {
            return;
        }
        SceneView view2 = sceneView;
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.surface.getProject()).getSelectedEditor();
        if (fileEditor == null) {
            return;
        }
        FileEditor currentEditor = fileEditor;
        VirtualFile virtualFile2 = currentEditor.getFile();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile sourceFile = virtualFile2;
        VirtualFile virtualFile3 = view2.getSceneManager().getModel().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"view.sceneManager.model.virtualFile");
        VirtualFile targetFile = virtualFile3;
        if (!((Boolean)StudioFlags.NELE_VISUALIZATION_APPLY_CONFIG_TO_LAYOUT_EDITOR.get()).booleanValue()) {
            LayoutNavigationManager.getInstance(this.surface.getProject()).pushFile(sourceFile, targetFile);
            return;
        }
        if (Intrinsics.areEqual((Object)sourceFile, (Object)targetFile)) {
            Configuration configInLayoutEditor;
            Object object = currentEditor instanceof DesignToolsSplitEditor ? (DesignToolsSplitEditor)currentEditor : null;
            Disposable surfaceInLayoutEditor = object != null && (object = object.getDesignerEditor()) != null && (object = ((DesignerEditor)object).getComponent()) != null ? ((DesignerEditorPanel)object).getSurface() : null;
            Disposable disposable2 = surfaceInLayoutEditor;
            Configuration configuration = disposable2 != null && (disposable2 = disposable2.getModels()) != null && (disposable2 = (NlModel)CollectionsKt.firstOrNull((List)((List)disposable2))) != null ? disposable2.getConfiguration() : (configInLayoutEditor = null);
            if (configInLayoutEditor != null) {
                Configuration configuration2 = view2.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"view.configuration");
                this.applyConfiguration(configInLayoutEditor, configuration2);
                surfaceInLayoutEditor.zoomToFit();
            }
        } else {
            LayoutNavigationManager.getInstance(this.surface.getProject()).pushFile(sourceFile, targetFile, new Consumer(this, view2){
                final /* synthetic */ VisualizationInteractionHandler this$0;
                final /* synthetic */ SceneView $view;
                {
                    this.this$0 = $receiver;
                    this.$view = $view;
                }

                public final void accept(FileEditor newEditor) {
                    Configuration configInDestinationEditor;
                    Object object = newEditor instanceof DesignToolsSplitEditor ? (DesignToolsSplitEditor)newEditor : null;
                    Disposable surfaceInDestinationEditor = object != null && (object = object.getDesignerEditor()) != null && (object = ((DesignerEditor)object).getComponent()) != null ? ((DesignerEditorPanel)object).getSurface() : null;
                    Disposable disposable2 = surfaceInDestinationEditor;
                    Configuration configuration = disposable2 != null && (disposable2 = disposable2.getModels()) != null && (disposable2 = (NlModel)CollectionsKt.firstOrNull((List)((List)disposable2))) != null ? disposable2.getConfiguration() : (configInDestinationEditor = null);
                    if (configInDestinationEditor != null) {
                        Configuration configuration2 = this.$view.getConfiguration();
                        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"view.configuration");
                        VisualizationInteractionHandler.access$applyConfiguration(this.this$0, configInDestinationEditor, configuration2);
                        surfaceInDestinationEditor.zoomToFit();
                    }
                }
            });
        }
    }

    private final void applyConfiguration(Configuration destination, Configuration source) {
        Configuration $this$applyConfiguration_u24lambda_u2d0 = destination;
        boolean bl = false;
        $this$applyConfiguration_u24lambda_u2d0.startBulkEditing();
        $this$applyConfiguration_u24lambda_u2d0.setDevice(source.getDevice(), true);
        $this$applyConfiguration_u24lambda_u2d0.setDeviceState(source.getDeviceState());
        $this$applyConfiguration_u24lambda_u2d0.setNightMode(source.getNightMode());
        $this$applyConfiguration_u24lambda_u2d0.setUiMode(source.getUiMode());
        $this$applyConfiguration_u24lambda_u2d0.setLocale(source.getLocale());
        $this$applyConfiguration_u24lambda_u2d0.finishBulkEditing();
    }

    @Override
    public void zoom(@NotNull ZoomType type, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.surface.zoom(type, mouseX, mouseY);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void hoverWhenNoInteraction(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        SceneView sceneView = this.surface.getSceneViewAt(mouseX, mouseY);
        if (sceneView != null) {
            SceneContext sceneContext = sceneView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)sceneContext, (String)"sceneView.context");
            SceneContext context = sceneContext;
            context.setMouseLocation(mouseX, mouseY);
            sceneView.getScene().mouseHover(context, Coordinates.getAndroidXDip(sceneView, mouseX), Coordinates.getAndroidYDip(sceneView, mouseY), modifiersEx);
        }
        ImmutableList<?> immutableList = this.surface.getSceneManagers();
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"surface.sceneManagers");
        Iterable $this$flatMap$iv = (Iterable)immutableList;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SceneManager it = (SceneManager)element$iv$iv;
            boolean bl = false;
            List<SceneView> list = it.getSceneViews();
            Intrinsics.checkNotNullExpressionValue(list, (String)"it.sceneViews");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SceneView it = (SceneView)element$iv;
            boolean bl = false;
            it.onHover(mouseX, mouseY);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void stayHovering(int mouseX, int mouseY) {
        void $this$flatMapTo$iv$iv;
        ImmutableList<?> immutableList = this.surface.getSceneManagers();
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"surface.sceneManagers");
        Iterable $this$flatMap$iv = (Iterable)immutableList;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SceneManager it = (SceneManager)element$iv$iv;
            boolean bl = false;
            List<SceneView> list = it.getSceneViews();
            Intrinsics.checkNotNullExpressionValue(list, (String)"it.sceneViews");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SceneView it = (SceneView)element$iv;
            boolean bl = false;
            it.onHover(mouseX, mouseY);
        }
    }

    @Override
    public void popupMenuTrigger(@NotNull MouseEvent mouseEvent) {
        Component invoker;
        DefaultActionGroup defaultActionGroup;
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Object object = this.getModelsProviderFunc.invoke();
        CustomModelsProvider customModelsProvider = object instanceof CustomModelsProvider ? (CustomModelsProvider)object : null;
        if (customModelsProvider == null) {
            return;
        }
        CustomModelsProvider customModelsProvider2 = customModelsProvider;
        int mouseX = mouseEvent.getX();
        int mouseY = mouseEvent.getY();
        SceneView sceneView = this.surface.getSceneViewAt(mouseX, mouseY);
        if (sceneView == null) {
            return;
        }
        SceneView sceneView2 = sceneView;
        SceneManager sceneManager = sceneView2.getSceneManager();
        Intrinsics.checkNotNullExpressionValue((Object)sceneManager, (String)"sceneView.sceneManager");
        SceneManager hoveredManager = sceneManager;
        Object primarySceneManager = this.surface.getSceneManager();
        DefaultActionGroup $this$popupMenuTrigger_u24lambda_u2d5 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        NlModel nlModel = hoveredManager.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"hoveredManager.model");
        $this$popupMenuTrigger_u24lambda_u2d5.add((AnAction)new RemoveCustomModelAction(customModelsProvider2, nlModel, !Intrinsics.areEqual((Object)hoveredManager, primarySceneManager)));
        DefaultActionGroup group = defaultActionGroup;
        ActionManager actionManager = ActionManager.getInstance();
        Object object2 = mouseEvent.getSource();
        Component component = object2 instanceof Component ? (Component)object2 : null;
        if (component == null) {
            component = invoker = (Component)((Object)this.surface);
        }
        if (group.getChildrenCount() != 0) {
            ActionPopupMenu actionPopupMenu = actionManager.createActionPopupMenu("popup", (ActionGroup)group);
            Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"actionManager.createActi\u2026ctionPlaces.POPUP, group)");
            ActionPopupMenu popupMenu2 = actionPopupMenu;
            popupMenu2.getComponent().show(invoker, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    @Nullable
    public Cursor getCursorWhenNoInteraction(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        return null;
    }

    @Override
    @Nullable
    public Interaction keyPressedWithoutInteraction(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
        return keyEvent.getKeyCode() == DesignSurfaceShortcut.PAN.getKeyCode() ? (Interaction)new PanInteraction(this.surface) : null;
    }

    @Override
    public void keyReleasedWithoutInteraction(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mouseExited() {
        void $this$flatMapTo$iv$iv;
        ImmutableList<?> immutableList = this.surface.getSceneManagers();
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"surface.sceneManagers");
        Iterable $this$flatMap$iv = (Iterable)immutableList;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SceneManager it = (SceneManager)element$iv$iv;
            boolean bl = false;
            List<SceneView> list = it.getSceneViews();
            Intrinsics.checkNotNullExpressionValue(list, (String)"it.sceneViews");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SceneView it = (SceneView)element$iv;
            boolean bl = false;
            it.getScene().mouseHover(it.getContext(), Integer.MIN_VALUE, Integer.MIN_VALUE, 0);
            it.onHover(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
    }

    public static final /* synthetic */ void access$applyConfiguration(VisualizationInteractionHandler $this, Configuration destination, Configuration source) {
        $this.applyConfiguration(destination, source);
    }
}

