/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import com.android.tools.idea.uibuilder.visual.VisualizationContent;
import com.android.tools.idea.uibuilder.visual.VisualizationContentProvider;
import com.android.tools.idea.uibuilder.visual.VisualizationEditorChangeHandler;
import com.android.tools.idea.uibuilder.visual.VisualizationEditorChangeHandlerKt;
import com.android.tools.idea.uibuilder.visual.VisualizationToolSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/uibuilder/visual/SyncVisualizationEditorChangeHandler;", "Lcom/android/tools/idea/uibuilder/visual/VisualizationEditorChangeHandler;", "contentProvider", "Lcom/android/tools/idea/uibuilder/visual/VisualizationContentProvider;", "(Lcom/android/tools/idea/uibuilder/visual/VisualizationContentProvider;)V", "toolWindowContent", "Lcom/android/tools/idea/uibuilder/visual/VisualizationContent;", "visualizationContent", "getVisualizationContent", "()Lcom/android/tools/idea/uibuilder/visual/VisualizationContent;", "onFileClose", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "onFileEditorChange", "newEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.designer"})
public final class SyncVisualizationEditorChangeHandler
implements VisualizationEditorChangeHandler {
    @NotNull
    private final VisualizationContentProvider contentProvider;
    @Nullable
    private VisualizationContent toolWindowContent;

    public SyncVisualizationEditorChangeHandler(@NotNull VisualizationContentProvider contentProvider) {
        Intrinsics.checkNotNullParameter((Object)contentProvider, (String)"contentProvider");
        this.contentProvider = contentProvider;
    }

    @Override
    @Nullable
    public VisualizationContent getVisualizationContent() {
        return this.toolWindowContent;
    }

    @Override
    public void onFileEditorChange(@Nullable FileEditor newEditor, @NotNull Project project, @NotNull ToolWindow toolWindow) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
                if (toolWindow.isDisposed()) {
                    return;
                }
                if (this.toolWindowContent == null) {
                    VisualizationContent form;
                    this.toolWindowContent = form = this.contentProvider.createVisualizationForm(project, toolWindow);
                    MessageBusConnection messageBusConnection = project.getMessageBus().connect();
                    Topic topic = ToolWindowManagerListener.TOPIC;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                    messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(project, toolWindow, form){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ ToolWindow $toolWindow;
                        final /* synthetic */ VisualizationContent $form;
                        {
                            this.$project = $project;
                            this.$toolWindow = $toolWindow;
                            this.$form = $form;
                        }

                        public void stateChanged(@NotNull ToolWindowManager manager) {
                            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                            if (this.$project.isDisposed()) {
                                return;
                            }
                            if (VisualizationToolSettings.getInstance().getGlobalState().isFirstTimeOpen() && this.$toolWindow instanceof ToolWindowEx) {
                                int width2 = this.$toolWindow.getComponent().getWidth();
                                ((ToolWindowEx)this.$toolWindow).stretchWidth(500 - width2);
                            }
                            VisualizationToolSettings.getInstance().getGlobalState().setFirstTimeOpen(false);
                            boolean visible = this.$toolWindow.isVisible();
                            if (this.$toolWindow.isAvailable()) {
                                VisualizationToolSettings.getInstance().getGlobalState().setVisible(visible);
                            }
                            if (!Disposer.isDisposed((Disposable)this.$form)) {
                                if (visible) {
                                    this.$form.activate();
                                } else {
                                    this.$form.deactivate();
                                }
                            }
                        }
                    });
                }
                VisualizationContent visualizationContent = this.toolWindowContent;
                Intrinsics.checkNotNull((Object)visualizationContent);
                if (Disposer.isDisposed((Disposable)visualizationContent)) {
                    return;
                }
                if (newEditor == null) break block8;
                VisualizationContent visualizationContent2 = this.toolWindowContent;
                Intrinsics.checkNotNull((Object)visualizationContent2);
                if (visualizationContent2.setNextEditor(newEditor)) break block9;
            }
            toolWindow.setAvailable(false);
            return;
        }
        toolWindow.setAvailable(true);
        if (VisualizationToolSettings.getInstance().getGlobalState().isVisible() && !toolWindow.isVisible()) {
            Runnable restoreFocus = null;
            if (toolWindow.getType() == ToolWindowType.WINDOWED) {
                restoreFocus = new Runnable(project, newEditor){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ FileEditor $newEditor;
                    {
                        this.$project = $project;
                        this.$newEditor = $newEditor;
                    }

                    public final void run() {
                        IdeFocusManager.getInstance((Project)this.$project).doWhenFocusSettlesDown(new Runnable(this.$newEditor){
                            final /* synthetic */ FileEditor $newEditor;
                            {
                                this.$newEditor = $newEditor;
                            }

                            public final void run() {
                                VisualizationEditorChangeHandlerKt.access$restoreFocusToEditor(this.$newEditor);
                            }
                        });
                    }
                };
            }
            toolWindow.activate(restoreFocus, false, false);
        }
    }

    @Override
    public void onFileClose(@NotNull FileEditorManager source, @NotNull ToolWindow toolWindow, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (this.toolWindowContent != null) {
            VisualizationContent visualizationContent = this.toolWindowContent;
            Intrinsics.checkNotNull((Object)visualizationContent);
            if (!Disposer.isDisposed((Disposable)visualizationContent)) {
                VisualizationContent visualizationContent2 = this.toolWindowContent;
                Intrinsics.checkNotNull((Object)visualizationContent2);
                visualizationContent2.fileClosed(source, file2);
            }
        }
        VirtualFile[] virtualFileArray = source.getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"source.openFiles");
        if (((Object[])virtualFileArray).length == 0) {
            Project project = source.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"source.project");
            this.onFileEditorChange(null, project, toolWindow);
        }
    }
}

