/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import com.android.ide.common.resources.Locale;
import com.android.resources.NightMode;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.AdaptiveIconShape;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/uibuilder/visual/ModelsProviderConfigurationListener;", "Lcom/android/tools/idea/configurations/ConfigurationListener;", "sourceConfig", "Lcom/android/tools/idea/configurations/Configuration;", "responseConfig", "attributesMask", "", "(Lcom/android/tools/idea/configurations/Configuration;Lcom/android/tools/idea/configurations/Configuration;I)V", "changed", "", "flags", "intellij.android.designer"})
public final class ModelsProviderConfigurationListener
implements ConfigurationListener {
    @NotNull
    private final Configuration sourceConfig;
    @NotNull
    private final Configuration responseConfig;
    private final int attributesMask;

    public ModelsProviderConfigurationListener(@NotNull Configuration sourceConfig, @NotNull Configuration responseConfig, int attributesMask) {
        Intrinsics.checkNotNullParameter((Object)sourceConfig, (String)"sourceConfig");
        Intrinsics.checkNotNullParameter((Object)responseConfig, (String)"responseConfig");
        this.sourceConfig = sourceConfig;
        this.responseConfig = responseConfig;
        this.attributesMask = attributesMask;
    }

    public boolean changed(int flags) {
        int effectiveFlags = flags & this.attributesMask;
        if ((effectiveFlags & 0x800) != 0) {
            AdaptiveIconShape adaptiveIconShape = this.sourceConfig.getAdaptiveShape();
            Intrinsics.checkNotNullExpressionValue((Object)adaptiveIconShape, (String)"sourceConfig.adaptiveShape");
            AdaptiveIconShape adaptiveShape = adaptiveIconShape;
            this.responseConfig.setAdaptiveShape(adaptiveShape);
        }
        if ((effectiveFlags & 2) != 0) {
            Device device = this.sourceConfig.getDevice();
            this.responseConfig.setDevice(device, false);
        }
        if ((effectiveFlags & 4) != 0) {
            State state = this.sourceConfig.getDeviceState();
            if (state == null) {
                return false;
            }
            State sourceState = state;
            this.responseConfig.setDeviceStateName(sourceState.getName());
        }
        if ((effectiveFlags & 0x80) != 0) {
            UiMode uiMode = this.sourceConfig.getUiMode();
            Intrinsics.checkNotNullExpressionValue((Object)uiMode, (String)"sourceConfig.uiMode");
            UiMode uiMode2 = uiMode;
            this.responseConfig.setUiMode(uiMode2);
        }
        if ((effectiveFlags & 0x40) != 0) {
            NightMode nightMode = this.sourceConfig.getNightMode();
            Intrinsics.checkNotNullExpressionValue((Object)nightMode, (String)"sourceConfig.nightMode");
            NightMode nightMode2 = nightMode;
            this.responseConfig.setNightMode(nightMode2);
        }
        if ((effectiveFlags & 8) != 0) {
            String string = this.sourceConfig.getTheme();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceConfig.theme");
            String theme = string;
            this.responseConfig.setTheme(theme);
        }
        if ((effectiveFlags & 0x20) != 0) {
            IAndroidTarget target = this.sourceConfig.getTarget();
            this.responseConfig.setTarget(target);
        }
        if ((effectiveFlags & 0x10) != 0) {
            Locale locale = this.sourceConfig.getLocale();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"sourceConfig.locale");
            Locale locale2 = locale;
            this.responseConfig.setLocale(locale2);
        }
        if ((effectiveFlags & 0x400) != 0) {
            float fontScale = this.sourceConfig.getFontScale();
            this.responseConfig.setFontScale(fontScale);
        }
        return true;
    }
}

