/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.AndroidColorSet;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.BorderLayer;
import com.android.tools.idea.uibuilder.surface.CanvasResizeLayer;
import com.android.tools.idea.uibuilder.surface.DiagnosticsLayer;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.OverlayLayer;
import com.android.tools.idea.uibuilder.surface.ScreenViewBase;
import com.android.tools.idea.uibuilder.surface.ScreenViewLayer;
import com.android.tools.idea.uibuilder.type.LayoutEditorFileType;
import com.google.common.collect.ImmutableList;
import java.awt.Dimension;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ScreenView
extends ScreenViewBase {
    public static final ContentSizePolicy DEVICE_CONTENT_SIZE_POLICY = (screenView, outDimension) -> {
        State state;
        Configuration configuration = screenView.getConfiguration();
        Device device = configuration.getCachedDevice();
        if (device != null && (state = configuration.getDeviceState()) != null) {
            HardwareConfig config = new HardwareConfigHelper(device).setOrientation(state.getOrientation()).getConfig();
            if (((Boolean)StudioFlags.NELE_DP_SIZED_PREVIEW.get()).booleanValue()) {
                float densityRatio = (float)Density.DEFAULT_DENSITY * 1.0f / (float)config.getDensity().getDpiValue();
                int dpWidth = Math.round((float)config.getScreenWidth() * densityRatio);
                int dpHeight = Math.round((float)config.getScreenHeight() * densityRatio);
                outDimension.setSize(dpWidth, dpHeight);
            } else {
                outDimension.setSize(config.getScreenWidth(), config.getScreenHeight());
            }
        }
    };
    private static final Function<ScreenView, ImmutableList<Layer>> DEFAULT_LAYERS_PROVIDER = screenView -> {
        ImmutableList.Builder builder2 = ImmutableList.builder();
        if (screenView.hasBorderLayer()) {
            builder2.add((Object)new BorderLayer((SceneView)screenView));
        }
        builder2.add((Object)new ScreenViewLayer((ScreenView)screenView));
        NlDesignSurface surface2 = screenView.getSurface();
        SceneLayer sceneLayer = new SceneLayer(surface2, (SceneView)screenView, false);
        sceneLayer.setAlwaysShowSelection(true);
        builder2.add((Object)sceneLayer);
        if (((Boolean)StudioFlags.NELE_OVERLAY_PROVIDER.get()).booleanValue()) {
            builder2.add((Object)new OverlayLayer((SceneView)screenView));
        }
        if (screenView.myIsResizeable && screenView.getSceneManager().getModel().getType().isEditable()) {
            builder2.add((Object)new CanvasResizeLayer(surface2, (ScreenView)screenView));
        }
        if (((Boolean)StudioFlags.NELE_RENDER_DIAGNOSTICS.get()).booleanValue()) {
            builder2.add((Object)new DiagnosticsLayer(surface2));
        }
        return builder2.build();
    };
    private final boolean myHasBorderLayer;
    private final boolean myIsResizeable;
    @NotNull
    private final ColorSet myColorSet;
    @NotNull
    private final Function<ScreenView, ImmutableList<Layer>> myLayersProvider;
    @NotNull
    private final ContentSizePolicy myContentSizePolicy;

    @NotNull
    public static Builder newBuilder(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager) {
        return new Builder(surface2, manager);
    }

    private ScreenView(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager, @NotNull SceneView.ShapePolicy shapePolicy, boolean isResizeable, boolean hasBorderLayer, @NotNull ColorSet colorSet, @NotNull Function<ScreenView, ImmutableList<Layer>> layersProvider, @NotNull ContentSizePolicy contentSizePolicy) {
        super(surface2, manager, shapePolicy);
        this.myHasBorderLayer = hasBorderLayer;
        this.myIsResizeable = isResizeable;
        this.myColorSet = colorSet;
        this.myLayersProvider = layersProvider;
        this.myContentSizePolicy = contentSizePolicy;
    }

    @TestOnly
    public ScreenView(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager, @NotNull ContentSizePolicy contentSizePolicy) {
        this(surface2, manager, SQUARE_SHAPE_POLICY, true, false, new AndroidColorSet(), DEFAULT_LAYERS_PROVIDER, contentSizePolicy);
    }

    @Override
    @NotNull
    public Dimension getContentSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        this.myContentSizePolicy.measure(this, dimension);
        return dimension;
    }

    @Override
    @NotNull
    protected ImmutableList<Layer> createLayers() {
        return this.myLayersProvider.apply(this);
    }

    public boolean hasBorderLayer() {
        return this.myHasBorderLayer;
    }

    private static boolean isErrorResult(@NotNull RenderResult result) {
        ImagePool.Image image = result.getRenderedImage();
        return result.getLogger().hasErrors() && (!image.isValid() || image.getWidth() * image.getHeight() < 2);
    }

    @Override
    public boolean hasContentSize() {
        return this.myContentSizePolicy.hasContentSize(this);
    }

    @Override
    @NotNull
    public ColorSet getColorSet() {
        return this.myColorSet;
    }

    @Override
    public boolean isResizeable() {
        return this.myIsResizeable;
    }

    public static class Builder {
        @NotNull
        final NlDesignSurface mySurface;
        @NotNull
        final LayoutlibSceneManager myManager;
        boolean isResizeable = false;
        boolean hasBorderLayer;
        @Nullable
        ColorSet myColorSet = null;
        @NotNull
        Function<ScreenView, ImmutableList<Layer>> myLayersProvider = DEFAULT_LAYERS_PROVIDER;
        @NotNull
        private ContentSizePolicy myContentSizePolicy = DEVICE_CONTENT_SIZE_POLICY;
        @NotNull
        private SceneView.ShapePolicy myShapePolicy = SceneView.DEVICE_CONFIGURATION_SHAPE_POLICY;

        private Builder(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager) {
            this.mySurface = surface2;
            this.myManager = manager;
            this.hasBorderLayer = manager.getModel().getType() instanceof LayoutEditorFileType;
        }

        @NotNull
        public Builder resizeable() {
            this.isResizeable = true;
            return this;
        }

        @NotNull
        public Builder withColorSet(@NotNull ColorSet colorSet) {
            this.myColorSet = colorSet;
            return this;
        }

        @NotNull
        public Builder withLayersProvider(@NotNull Function<ScreenView, ImmutableList<Layer>> layersProvider) {
            this.myLayersProvider = layersProvider;
            return this;
        }

        @NotNull
        public Builder withContentSizePolicy(@NotNull ContentSizePolicy contentSizePolicy) {
            this.myContentSizePolicy = contentSizePolicy;
            return this;
        }

        @NotNull
        public Builder withShapePolicy(@NotNull SceneView.ShapePolicy shapePolicy) {
            this.myShapePolicy = shapePolicy;
            return this;
        }

        @NotNull
        public Builder decorateContentSizePolicy(@NotNull Function<ContentSizePolicy, ContentSizePolicy> contentSizePolicyProvider) {
            this.myContentSizePolicy = contentSizePolicyProvider.apply(this.myContentSizePolicy);
            return this;
        }

        @NotNull
        public Builder disableBorder() {
            this.hasBorderLayer = false;
            return this;
        }

        @NotNull
        public ScreenView build() {
            return new ScreenView(this.mySurface, this.myManager, this.myShapePolicy, this.isResizeable, this.hasBorderLayer, this.myColorSet == null ? new AndroidColorSet() : this.myColorSet, this.myLayersProvider, this.myContentSizePolicy);
        }
    }

    public static final class ImageContentSizePolicy
    implements ContentSizePolicy {
        @NotNull
        private final ContentSizePolicy mySizePolicyDelegate;
        private Dimension cachedDimension = null;

        public ImageContentSizePolicy(@NotNull ContentSizePolicy delegate) {
            this.mySizePolicyDelegate = delegate;
        }

        @Override
        public void measure(@NotNull ScreenView screenView, @NotNull Dimension outDimension) {
            RenderResult result = screenView.getSceneManager().getRenderResult();
            if (result != null && result.getSystemRootViews().size() == 1) {
                ViewInfo viewInfo = (ViewInfo)result.getSystemRootViews().get(0);
                try {
                    if (((Boolean)StudioFlags.NELE_DP_SIZED_PREVIEW.get()).booleanValue()) {
                        outDimension.setSize(Coordinates.pxToDp((SceneView)screenView, viewInfo.getRight()), Coordinates.pxToDp((SceneView)screenView, viewInfo.getBottom()));
                    } else {
                        outDimension.setSize(viewInfo.getRight(), viewInfo.getBottom());
                    }
                    if (this.cachedDimension == null) {
                        this.cachedDimension = new Dimension(outDimension);
                    } else {
                        this.cachedDimension.setSize(outDimension);
                    }
                    return;
                }
                catch (AssertionError assertionError) {
                    // empty catch block
                }
            }
            if (this.cachedDimension != null) {
                outDimension.setSize(this.cachedDimension);
                return;
            }
            this.mySizePolicyDelegate.measure(screenView, outDimension);
        }
    }

    public static interface ContentSizePolicy {
        public void measure(@NotNull ScreenView var1, @NotNull Dimension var2);

        default public boolean hasContentSize(@NotNull ScreenView screenView) {
            if (!screenView.isVisible()) {
                return false;
            }
            RenderResult result = screenView.getSceneManager().getRenderResult();
            return result != null && !ScreenView.isErrorResult(result);
        }
    }
}

