/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.resources.ResourceType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.error.NlComponentIssueSource;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.ui.resourcemanager.ResourcePickerDialog;
import com.android.tools.idea.uibuilder.lint.LintUtilKt;
import com.android.tools.idea.validator.ValidatorData;
import com.android.tools.lint.detector.api.Category;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.lang.annotation.HighlightSeverity;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 42\u00020\u0001:\u000245B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0007J\u0010\u00100\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u00101\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00102\u001a\u000203H\u0002R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000eR\u0014\u0010%\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000eR\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0015\u00a8\u00066"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlAtfIssue;", "Lcom/android/tools/idea/common/error/Issue;", "result", "Lcom/android/tools/idea/validator/ValidatorData$Issue;", "issueSource", "Lcom/android/tools/idea/common/error/IssueSource;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "eventListener", "Lcom/android/tools/idea/uibuilder/surface/NlAtfIssue$EventListener;", "(Lcom/android/tools/idea/validator/ValidatorData$Issue;Lcom/android/tools/idea/common/error/IssueSource;Lcom/android/tools/idea/common/model/NlModel;Lcom/android/tools/idea/uibuilder/surface/NlAtfIssue$EventListener;)V", "category", "", "getCategory", "()Ljava/lang/String;", "description", "getDescription", "fixes", "Ljava/util/stream/Stream;", "Lcom/android/tools/idea/common/error/Issue$Fix;", "getFixes", "()Ljava/util/stream/Stream;", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "getHyperlinkListener", "()Ljavax/swing/event/HyperlinkListener;", "getResult", "()Lcom/android/tools/idea/validator/ValidatorData$Issue;", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "getSeverity", "()Lcom/intellij/lang/annotation/HighlightSeverity;", "source", "getSource", "()Lcom/android/tools/idea/common/error/IssueSource;", "srcClass", "getSrcClass", "summary", "getSummary", "suppresses", "Lcom/android/tools/idea/common/error/Issue$Suppress;", "getSuppresses", "applyFixImpl", "", "fix", "Lcom/android/tools/idea/validator/ValidatorData$Fix;", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "applyFixWrapper", "applySetViewAttributeFixWithEmptySuggestedValue", "viewAttribute", "Lcom/android/tools/idea/validator/ValidatorData$ViewAttribute;", "Companion", "EventListener", "intellij.android.designer"})
public class NlAtfIssue
extends Issue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ValidatorData.Issue result;
    @NotNull
    private final NlModel model;
    @Nullable
    private final EventListener eventListener;
    @NotNull
    private final IssueSource source;
    @NotNull
    private final String category;
    @NotNull
    private final String srcClass;
    @NotNull
    private static final String CONTENT_LABELING = "CONTENT_LABELING";
    @NotNull
    private static final String TOUCH_TARGET_SIZE = "TOUCH_TARGET_SIZE";
    @NotNull
    private static final String LOW_CONTRAST = "LOW_CONTRAST";

    public NlAtfIssue(@NotNull ValidatorData.Issue result, @NotNull IssueSource issueSource, @NotNull NlModel model2, @Nullable EventListener eventListener) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)issueSource, (String)"issueSource");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.result = result;
        this.model = model2;
        this.eventListener = eventListener;
        this.source = issueSource;
        this.category = Category.A11Y.getName();
        String string = this.result.mSourceClass;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.mSourceClass");
        this.srcClass = string;
    }

    public /* synthetic */ NlAtfIssue(ValidatorData.Issue issue, IssueSource issueSource, NlModel nlModel, EventListener eventListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            eventListener = null;
        }
        this(issue, issueSource, nlModel, eventListener);
    }

    @NotNull
    public final ValidatorData.Issue getResult() {
        return this.result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getSummary() {
        String string;
        int n;
        String string2 = this.result.mSourceClass;
        if (string2 != null) {
            n = -1;
            switch (string2.hashCode()) {
                case 1267412697: {
                    if (!string2.equals("TextContrastCheck")) break;
                    n = 1;
                    break;
                }
                case -81065639: {
                    if (!string2.equals("RedundantDescriptionCheck")) break;
                    n = 2;
                    break;
                }
                case 1014273495: {
                    if (!string2.equals("TouchTargetSizeCheck")) break;
                    n = 3;
                    break;
                }
                case 415991192: {
                    if (!string2.equals("TraversalOrderCheck")) break;
                    n = 4;
                    break;
                }
                case 113969112: {
                    if (!string2.equals("LinkPurposeUnclearCheck")) break;
                    n = 5;
                    break;
                }
                case -1101169318: {
                    if (!string2.equals("DuplicateSpeakableTextCheck")) break;
                    n = 6;
                    break;
                }
                case -119857348: {
                    if (!string2.equals("ClickableSpanCheck")) break;
                    n = 7;
                    break;
                }
                case 2145583531: {
                    if (!string2.equals("ImageContrastCheck")) break;
                    n = 8;
                    break;
                }
                case 2064391942: {
                    if (!string2.equals("SpeakableTextPresentCheck")) break;
                    n = 9;
                    break;
                }
                case 97108677: {
                    if (!string2.equals("ClassNameCheck")) break;
                    n = 10;
                    break;
                }
                case -1393599710: {
                    if (!string2.equals("EditableContentDescCheck")) break;
                    n = 11;
                    break;
                }
                case 1762882716: {
                    if (!string2.equals("DuplicateClickableBoundsCheck")) break;
                    n = 12;
                    break;
                }
            }
            switch (n) {
                case 9: {
                    return "No speakable text present";
                }
                case 11: {
                    return "Editable text view with contentDescription";
                }
                case 3: {
                    return "Touch target size too small";
                }
                case 6: {
                    return "Duplicate speakable text present";
                }
                case 1: {
                    return "Insufficient text color contrast ratio";
                }
                case 7: {
                    return "Accessibility issue with clickable span";
                }
                case 12: {
                    return "Duplicated clickable Views";
                }
                case 2: {
                    return "Item labelled with type or state";
                }
                case 8: {
                    return "Insufficient image color contrast ratio";
                }
                case 10: {
                    return "Accessibility Issue";
                }
                case 4: {
                    return "Unpredictable traversal behavior";
                }
                case 5: {
                    return "Unclear text in link";
                }
            }
        }
        if ((string = this.result.mCategory) == null) return "Accessibility Issue";
        tmp = -1;
        switch (string.hashCode()) {
            case 811661716: {
                if (!string.equals(CONTENT_LABELING)) break;
                tmp = 1;
                break;
            }
            case 1384507309: {
                if (!string.equals(LOW_CONTRAST)) break;
                tmp = 2;
                break;
            }
            case -62747441: {
                if (!string.equals(TOUCH_TARGET_SIZE)) break;
                tmp = 3;
                break;
            }
        }
        switch (tmp) {
            case 1: {
                return "Content labels missing or ambiguous";
            }
            case 3: {
                return "Touch target size too small";
            }
            case 2: {
                return "Insufficient color contrast ratio";
            }
        }
        return "Accessibility Issue";
    }

    @Override
    @NotNull
    public String getDescription() {
        CharSequence charSequence = this.result.mHelpfulUrl;
        if (charSequence == null || charSequence.length() == 0) {
            String string = this.result.mMsg;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.mMsg");
            return string;
        }
        return this.result.mMsg + "<br><br>Learn more at <a href=\"" + this.result.mHelpfulUrl + "\">" + this.result.mHelpfulUrl + "</a>";
    }

    @Override
    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity;
        ValidatorData.Level level = this.result.mLevel;
        switch (level == null ? -1 : WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                HighlightSeverity highlightSeverity2 = HighlightSeverity.ERROR;
                highlightSeverity = highlightSeverity2;
                Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity2, (String)"ERROR");
                break;
            }
            case 2: {
                HighlightSeverity highlightSeverity3 = HighlightSeverity.WARNING;
                highlightSeverity = highlightSeverity3;
                Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity3, (String)"WARNING");
                break;
            }
            default: {
                HighlightSeverity highlightSeverity4 = HighlightSeverity.INFORMATION;
                highlightSeverity = highlightSeverity4;
                Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity4, (String)"INFORMATION");
            }
        }
        return highlightSeverity;
    }

    @Override
    @NotNull
    public IssueSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public String getCategory() {
        return this.category;
    }

    @Override
    @NotNull
    public Stream<Issue.Fix> getFixes() {
        ValidatorData.Fix fix2;
        IssueSource source = this.getSource();
        if (source instanceof NlAttributesHolder && (fix2 = this.result.mFix) != null) {
            ValidatorData.Fix it = fix2;
            boolean bl = false;
            String string = it.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.description");
            Issue.Fix fix3 = new Issue.Fix("Fix", string, new Runnable(this, it){
                final /* synthetic */ NlAtfIssue this$0;
                final /* synthetic */ ValidatorData.Fix $it;
                {
                    this.this$0 = $receiver;
                    this.$it = $it;
                }

                public final void run() {
                    block0: {
                        NlAtfIssue.access$applyFixWrapper(this.this$0, this.$it);
                        EventListener eventListener = NlAtfIssue.access$getEventListener$p(this.this$0);
                        if (eventListener == null) break block0;
                        eventListener.onApplyFixButtonClicked(this.this$0.getResult());
                    }
                }
            });
            Stream<Issue.Fix> stream = Stream.of(fix3);
            Intrinsics.checkNotNullExpressionValue(stream, (String)"of(fix)");
            return stream;
        }
        Stream<Issue.Fix> stream = Stream.empty();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"empty()");
        return stream;
    }

    @Override
    @NotNull
    public Stream<Issue.Suppress> getSuppresses() {
        IssueSource source = this.getSource();
        if (!(source instanceof NlAttributesHolder)) {
            Stream<Issue.Suppress> stream = Stream.empty();
            Intrinsics.checkNotNullExpressionValue(stream, (String)"empty()");
            return stream;
        }
        Issue.Suppress ignore2 = new Issue.Suppress("Suppress", "Suppress this check if it is false positive.", new Runnable(source, this){
            final /* synthetic */ IssueSource $source;
            final /* synthetic */ NlAtfIssue this$0;
            {
                this.$source = $source;
                this.this$0 = $receiver;
            }

            public final void run() {
                block0: {
                    String string = ((NlAttributesHolder)((Object)this.$source)).getAttribute("http://schemas.android.com/tools", "ignore");
                    NlAtfIssue nlAtfIssue = this.this$0;
                    String it = string;
                    boolean bl = false;
                    CharSequence charSequence = it;
                    Object attr2 = charSequence == null || charSequence.length() == 0 ? nlAtfIssue.getResult().mSourceClass : it + "," + nlAtfIssue.getResult().mSourceClass;
                    ((NlAttributesHolder)((Object)this.$source)).setAttribute("http://schemas.android.com/tools", "ignore", (String)attr2);
                    EventListener eventListener = NlAtfIssue.access$getEventListener$p(this.this$0);
                    if (eventListener == null) break block0;
                    eventListener.onIgnoreButtonClicked(this.this$0.getResult());
                }
            }
        });
        Stream<Issue.Suppress> stream = Stream.of(ignore2);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"of(ignore)");
        return stream;
    }

    @Override
    @Nullable
    public HyperlinkListener getHyperlinkListener() {
        CharSequence charSequence = this.result.mHelpfulUrl;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        return LintUtilKt.createDefaultHyperLinkListener();
    }

    @NotNull
    public final String getSrcClass() {
        return this.srcClass;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void applyFixWrapper(ValidatorData.Fix fix2) {
        IssueSource source = this.getSource();
        if (fix2 instanceof ValidatorData.SetViewAttributeFix) {
            String string = ((ValidatorData.SetViewAttributeFix)fix2).mSuggestedValue;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fix.mSuggestedValue");
            if (((CharSequence)string).length() == 0) {
                ValidatorData.ViewAttribute viewAttribute = ((ValidatorData.SetViewAttributeFix)fix2).mViewAttribute;
                Intrinsics.checkNotNullExpressionValue((Object)viewAttribute, (String)"fix.mViewAttribute");
                this.applySetViewAttributeFixWithEmptySuggestedValue(this.model, viewAttribute);
                return;
            }
        }
        if (!(source instanceof NlComponentIssueSource)) return;
        NlWriteCommandActionUtil.run(((NlComponentIssueSource)source).getComponent(), "Update issue source", new Runnable(this, fix2, source){
            final /* synthetic */ NlAtfIssue this$0;
            final /* synthetic */ ValidatorData.Fix $fix;
            final /* synthetic */ IssueSource $source;
            {
                this.this$0 = $receiver;
                this.$fix = $fix;
                this.$source = $source;
            }

            public final void run() {
                this.this$0.applyFixImpl(this.$fix, ((NlComponentIssueSource)this.$source).getComponent());
            }
        });
    }

    private final void applySetViewAttributeFixWithEmptySuggestedValue(NlModel model2, ValidatorData.ViewAttribute viewAttribute) {
        block1: {
            IssueSource source = this.getSource();
            AndroidFacet androidFacet = model2.getFacet();
            Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"model.facet");
            EnumSet<Enum> enumSet = EnumSet.of((Enum)ResourceType.STRING);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(ResourceType.STRING)");
            ResourcePickerDialog dialog = ResourceChooserHelperKt.createResourcePickerDialog((String)"Pick a Resource", null, (AndroidFacet)androidFacet, (Set)enumSet, null, (boolean)false, (boolean)false, (boolean)false, null);
            if (!dialog.showAndGet() || !(source instanceof NlComponentIssueSource)) break block1;
            String string = dialog.getResourceName();
            if (string != null) {
                String it = string;
                boolean bl = false;
                NlWriteCommandActionUtil.run(((NlComponentIssueSource)source).getComponent(), "Update issue source", new Runnable(source, viewAttribute, it){
                    final /* synthetic */ IssueSource $source;
                    final /* synthetic */ ValidatorData.ViewAttribute $viewAttribute;
                    final /* synthetic */ String $it;
                    {
                        this.$source = $source;
                        this.$viewAttribute = $viewAttribute;
                        this.$it = $it;
                    }

                    public final void run() {
                        ((NlComponentIssueSource)this.$source).getComponent().setAttribute(this.$viewAttribute.mNamespaceUri, this.$viewAttribute.mAttributeName, this.$it);
                    }
                });
            }
        }
    }

    @VisibleForTesting
    public final void applyFixImpl(@NotNull ValidatorData.Fix fix2, @NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)fix2, (String)"fix");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        ValidatorData.Fix fix3 = fix2;
        if (fix3 instanceof ValidatorData.RemoveViewAttributeFix) {
            component.removeAttribute(((ValidatorData.RemoveViewAttributeFix)fix2).mViewAttribute.mNamespaceUri, ((ValidatorData.RemoveViewAttributeFix)fix2).mViewAttribute.mAttributeName);
        } else if (fix3 instanceof ValidatorData.SetViewAttributeFix) {
            component.setAttribute(((ValidatorData.SetViewAttributeFix)fix2).mViewAttribute.mNamespaceUri, ((ValidatorData.SetViewAttributeFix)fix2).mViewAttribute.mAttributeName, ((ValidatorData.SetViewAttributeFix)fix2).mSuggestedValue);
        } else if (fix3 instanceof ValidatorData.CompoundFix) {
            List list = ((ValidatorData.CompoundFix)fix2).mFixes;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fix.mFixes");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ValidatorData.Fix it = (ValidatorData.Fix)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.applyFixImpl(it, component);
            }
        }
    }

    public static final /* synthetic */ EventListener access$getEventListener$p(NlAtfIssue $this) {
        return $this.eventListener;
    }

    public static final /* synthetic */ void access$applyFixWrapper(NlAtfIssue $this, ValidatorData.Fix fix2) {
        $this.applyFixWrapper(fix2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlAtfIssue$EventListener;", "", "onApplyFixButtonClicked", "", "issue", "Lcom/android/tools/idea/validator/ValidatorData$Issue;", "onIgnoreButtonClicked", "intellij.android.designer"})
    public static interface EventListener {
        public void onApplyFixButtonClicked(@NotNull ValidatorData.Issue var1);

        public void onIgnoreButtonClicked(@NotNull ValidatorData.Issue var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlAtfIssue$Companion;", "", "()V", "CONTENT_LABELING", "", "LOW_CONTRAST", "TOUCH_TARGET_SIZE", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValidatorData.Level.values().length];
            nArray[ValidatorData.Level.ERROR.ordinal()] = 1;
            nArray[ValidatorData.Level.WARNING.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

