/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssuePanelService;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.utils.SparseIntArray;
import com.intellij.ui.LightweightHint;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlTreeBadgeHandler {
    private static final int BADGE_MARGIN = 5;
    private static final int BADGE_ICON = 0;
    private static final int LOCK_ICON = 1;
    private static final String TOGGLE_LOCK_MESSAGE = "Toggle Tool Locking";
    private final BadgeMouseMotionListener myBadgeMouseMotionListener = new BadgeMouseMotionListener();
    @Nullable
    private LightweightHint myTooltipHint;
    @Nullable
    private TreePath myHoveredPath;
    private int myHoveredIcon = 0;
    private NlComponent myHoveredComponent;
    @Nullable
    private NlModel myNlModel;
    private int myBadgeX;
    private int myLockIconX;
    @Nullable
    private DesignSurface<?> mySurface;
    private final SparseIntArray myBadgeWidthForRows = new SparseIntArray();

    public void setNlModel(@Nullable NlModel nlModel) {
        this.myNlModel = nlModel;
    }

    public void setSurface(@Nullable DesignSurface<?> surface2) {
        this.mySurface = surface2;
    }

    public void paintBadges(@NotNull Graphics2D g, @NotNull NlComponentTree tree) {
        this.myBadgeX = Integer.MAX_VALUE;
        this.myBadgeWidthForRows.clear();
        if (this.myNlModel == null) {
            return;
        }
        for (int i = 0; i < tree.getRowCount(); ++i) {
            TreePath path = tree.getPathForRow(i);
            Object last = path.getLastPathComponent();
            if (!(last instanceof NlComponent)) continue;
            NlComponent component = (NlComponent)last;
            Rectangle pathBounds = tree.getPathBounds(path);
            Issue issue = null;
            if (this.mySurface != null) {
                issue = this.mySurface.getIssueModel().getHighestSeverityIssue(component);
            }
            if (pathBounds == null) continue;
            int y = pathBounds.y + pathBounds.height / 2;
            Icon firstIcon = null;
            if (issue == null || (firstIcon = IssueModel.getIssueIcon(issue.getSeverity(), tree.isRowSelected(i) && tree.hasFocus())) == null) continue;
            int x = tree.getWidth() - firstIcon.getIconWidth() - 5;
            int iy = y - firstIcon.getIconHeight() / 2;
            firstIcon.paintIcon((Component)((Object)tree), g, x, iy);
            this.myBadgeWidthForRows.put(i, firstIcon.getIconWidth());
            this.myBadgeX = Math.min(x, this.myBadgeX);
        }
    }

    @Nullable
    private String getIssueMessage(@NotNull TreePath path) {
        IssueModel issueModel;
        Object last = path.getLastPathComponent();
        if (!(last instanceof NlComponent)) {
            return null;
        }
        NlComponent component = (NlComponent)last;
        Issue max = null;
        IssueModel issueModel2 = issueModel = this.mySurface != null ? this.mySurface.getIssueModel() : null;
        if (issueModel != null) {
            max = issueModel.getHighestSeverityIssue(component);
        }
        if (max != null) {
            return "<html>" + max.getSummary() + "<br>Click the badge for detail.</html>";
        }
        return null;
    }

    @NotNull
    public MouseAdapter getBadgeMouseAdapter() {
        return this.myBadgeMouseMotionListener;
    }

    public int getTotalBadgeWidth(int row) {
        return this.myBadgeWidthForRows.get(row, 0) + 5;
    }

    private class BadgeMouseMotionListener
    extends MouseAdapter {
        private BadgeMouseMotionListener() {
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (NlTreeBadgeHandler.this.myTooltipHint != null) {
                NlTreeBadgeHandler.this.myTooltipHint.hide(true);
                NlTreeBadgeHandler.this.myTooltipHint = null;
            }
            NlTreeBadgeHandler.this.myHoveredComponent = null;
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            JTree tree = (JTree)event.getSource();
            this.handleShowBadge(event, tree);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            this.handleMouseClicked(event, (JTree)event.getSource());
        }

        private void handleMouseClicked(MouseEvent event, JTree tree) {
            Rectangle bounds2;
            IssueModel issueModel;
            int limit = NlTreeBadgeHandler.this.myBadgeX;
            IssueModel issueModel2 = issueModel = NlTreeBadgeHandler.this.mySurface != null ? NlTreeBadgeHandler.this.mySurface.getIssueModel() : null;
            if (event.getX() < limit || issueModel == null) {
                return;
            }
            TreePath path = tree.getClosestPathForLocation(event.getX(), event.getY());
            if (path == null || (bounds2 = tree.getPathBounds(path)) == null || event.getY() < bounds2.y || event.getY() > bounds2.y + bounds2.height) {
                return;
            }
            Object last = path.getLastPathComponent();
            if (!(last instanceof NlComponent)) {
                return;
            }
            NlComponent component = (NlComponent)last;
            if (event.getX() > NlTreeBadgeHandler.this.myBadgeX) {
                IssuePanelService.getInstance(component.getModel().getProject()).showIssueForComponent(NlTreeBadgeHandler.this.mySurface, true, component, true);
            }
        }

        private void toggleLocking(@NotNull NlComponent component) {
            boolean isLocked = SceneManager.isComponentLocked(component);
            if (component.getParent() == null) {
                return;
            }
            NlWriteCommandActionUtil.run(component, "", () -> component.setAttribute("http://schemas.android.com/tools", "locked", isLocked ? null : "true"));
        }

        private void handleShowBadge(@NotNull MouseEvent event, @NotNull JTree tree) {
            Rectangle bounds2;
            if (event.getX() < NlTreeBadgeHandler.this.myBadgeX) {
                NlTreeBadgeHandler.this.myHoveredPath = null;
                NlTreeBadgeHandler.this.myHoveredComponent = null;
                this.hideTooltip();
                return;
            }
            TreePath path = tree.getClosestPathForLocation(event.getX(), event.getY());
            if (path == null || (bounds2 = tree.getPathBounds(path)) == null || event.getY() < bounds2.y || event.getY() > bounds2.y + bounds2.height) {
                NlTreeBadgeHandler.this.myHoveredPath = null;
                NlTreeBadgeHandler.this.myHoveredComponent = null;
                this.hideTooltip();
                return;
            }
            Object last = path.getLastPathComponent();
            if (!(last instanceof NlComponent)) {
                return;
            }
            NlTreeBadgeHandler.this.myHoveredComponent = (NlComponent)last;
            boolean badgeIcon = true;
            if (NlTreeBadgeHandler.this.myHoveredPath == path) {
                if (badgeIcon && NlTreeBadgeHandler.this.myHoveredIcon == 0) {
                    return;
                }
                if (!badgeIcon && NlTreeBadgeHandler.this.myHoveredIcon == 1) {
                    return;
                }
            }
            NlTreeBadgeHandler.this.myHoveredPath = path;
            String message = null;
            if (badgeIcon) {
                message = NlTreeBadgeHandler.this.getIssueMessage(NlTreeBadgeHandler.this.myHoveredPath);
                NlTreeBadgeHandler.this.myHoveredIcon = 0;
            }
            if (message != null) {
                tree.setToolTipText(message);
            }
        }

        private void hideTooltip() {
            if (NlTreeBadgeHandler.this.myTooltipHint != null) {
                NlTreeBadgeHandler.this.myTooltipHint.hide(true);
            }
        }
    }
}

