/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.editor.LayoutNavigationManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackNavigationComponent
extends JPanel {
    public static final String BACK_NAVIGATION_COMPONENT_NAME = "BackNavigationComponent";
    private static final Color BACKGROUND = UIUtil.getPanelBackground();
    private static final Color HOVER_BACKGROUND = UIUtil.getPanelBackground().darker();
    private final DesignSurfaceListener mySurfaceListener;
    private final JLabel myBackLabel;
    @Nullable
    private DesignSurface<?> myDesignSurface;
    private final BackNavigationListener myMouseAdapter;

    public BackNavigationComponent() {
        super(new FlowLayout(0));
        this.setName(BACK_NAVIGATION_COMPONENT_NAME);
        this.mySurfaceListener = this.createDesignSurfaceListener();
        this.myBackLabel = new JLabel(AllIcons.Actions.Back);
        this.myBackLabel.setIconTextGap(8);
        this.myMouseAdapter = new BackNavigationListener();
        this.addMouseListener(this.myMouseAdapter);
        this.addMouseMotionListener(this.myMouseAdapter);
        this.setVisible(false);
        this.add(this.myBackLabel);
        this.setBorder(IdeBorderFactory.createBorder((int)8));
        this.setBackground(BACKGROUND);
    }

    private void updateBackNavigation() {
        if (this.myDesignSurface == null) {
            return;
        }
        NlModel model2 = this.myDesignSurface.getModel();
        if (model2 != null) {
            VirtualFile modelFile;
            LayoutNavigationManager layoutNavigationManager = LayoutNavigationManager.getInstance(this.myDesignSurface.getProject());
            VirtualFile parentFile = layoutNavigationManager.get(modelFile = model2.getVirtualFile());
            if (parentFile != null) {
                this.setVisible(true);
                this.myMouseAdapter.setNavigation(modelFile, parentFile, layoutNavigationManager);
                this.myBackLabel.setText(parentFile.getPresentableName());
            } else {
                this.setVisible(false);
            }
        }
    }

    @NotNull
    private DesignSurfaceListener createDesignSurfaceListener() {
        return new DesignSurfaceListener(){

            @Override
            @UiThread
            public void modelChanged(@NotNull DesignSurface<?> surface2, @Nullable NlModel model2) {
                BackNavigationComponent.this.updateBackNavigation();
            }

            @Override
            public boolean activatePreferredEditor(@NotNull DesignSurface<?> surface2, @NotNull NlComponent component) {
                return false;
            }
        };
    }

    public void setDesignSurface(@Nullable DesignSurface<?> designSurface) {
        if (this.myDesignSurface != null) {
            this.myDesignSurface.removeListener(this.mySurfaceListener);
        }
        this.myDesignSurface = designSurface;
        if (this.myDesignSurface != null) {
            this.myDesignSurface.addListener(this.mySurfaceListener);
            this.updateBackNavigation();
        }
    }

    @Nullable
    public DesignSurface<?> getDesignSurface() {
        return this.myDesignSurface;
    }

    private class BackNavigationListener
    extends MouseAdapter {
        private VirtualFile myFrom;
        private VirtualFile myTo;
        private LayoutNavigationManager myManager;

        private BackNavigationListener() {
        }

        private void setNavigation(@NotNull VirtualFile from, @NotNull VirtualFile to, @NotNull LayoutNavigationManager layoutNavigationManager) {
            this.myFrom = from;
            this.myTo = to;
            this.myManager = layoutNavigationManager;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.myManager.popFile(this.myFrom, this.myTo);
            BackNavigationComponent.this.setBackground(BACKGROUND);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            BackNavigationComponent.this.setBackground(HOVER_BACKGROUND);
            BackNavigationComponent.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BackNavigationComponent.this.setBackground(BACKGROUND);
            BackNavigationComponent.this.repaint();
        }
    }
}

