/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.ViewInfoTagSnapshotNode;
import com.android.tools.idea.uibuilder.type.MenuFileType;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlModelHierarchyUpdater {
    private static final int VISUAL_EMPTY_COMPONENT_SIZE = 1;

    public static void updateHierarchy(@NotNull RenderResult result, @NotNull NlModel model2) {
        NlModelHierarchyUpdater.updateHierarchy(NlModelHierarchyUpdater.getRootViews(result, model2.getType()), model2);
    }

    public static void updateHierarchy(@NotNull List<ViewInfo> views, @NotNull NlModel model2) {
        XmlTag root = NlModelHierarchyUpdater.getRootTag(model2);
        if (root != null) {
            NlModelHierarchyUpdater.updateHierarchy(root, views, model2);
        }
    }

    public static void updateHierarchy(@NotNull XmlTag rootTag, @NotNull List<ViewInfo> views, @NotNull NlModel model2) {
        model2.syncWithPsi(rootTag, ContainerUtil.map(views, ViewInfoTagSnapshotNode::new));
        NlModelHierarchyUpdater.updateBounds(views, model2);
    }

    @NotNull
    public static List<ViewInfo> getRootViews(@NotNull RenderResult result, @NotNull DesignerEditorFileType type) {
        return type == MenuFileType.INSTANCE ? result.getSystemRootViews() : result.getRootViews();
    }

    @Nullable
    private static XmlTag getRootTag(@NotNull NlModel model2) {
        if (Disposer.isDisposed((Disposable)model2)) {
            return null;
        }
        return AndroidPsiUtils.getRootTagSafely((XmlFile)model2.getFile());
    }

    private static void updateBounds(@NotNull List<ViewInfo> rootViews, @NotNull NlModel model2) {
        model2.flattenComponents().forEach(NlModelHierarchyUpdater::clearDerivedData);
        Map<TagSnapshot, NlComponent> snapshotToComponent = model2.flattenComponents().collect(Collectors.toMap(NlComponent::getSnapshot, Function.identity(), (n1, n2) -> n1));
        Map<XmlTag, NlComponent> tagToComponent = model2.flattenComponents().collect(Collectors.toMap(NlComponent::getTagDeprecated, Function.identity()));
        for (ViewInfo view2 : rootViews) {
            NlModelHierarchyUpdater.updateBounds(view2, 0, 0, snapshotToComponent, tagToComponent);
        }
        ImmutableList<NlComponent> components = model2.getComponents();
        if (!rootViews.isEmpty() && !components.isEmpty()) {
            NlModelHierarchyUpdater.fixBounds((NlComponent)components.get(0));
        }
    }

    private static void updateBounds(@NotNull ViewInfo view2, int parentX, int parentY, Map<TagSnapshot, NlComponent> snapshotToComponent, Map<XmlTag, NlComponent> tagToComponent) {
        ViewInfo bounds2 = RenderService.getSafeBounds((ViewInfo)view2);
        Object cookie = view2.getCookie();
        if (cookie != null && cookie instanceof TagSnapshot) {
            TagSnapshot snapshot = (TagSnapshot)cookie;
            NlComponent component = snapshotToComponent.get(snapshot);
            if (component == null) {
                component = tagToComponent.get(snapshot.tag);
            }
            if (component != null && NlComponentHelperKt.getViewInfo(component) == null) {
                NlComponentHelperKt.setViewInfo(component, view2);
                int left = parentX + bounds2.getLeft();
                int top = parentY + bounds2.getTop();
                int width2 = bounds2.getRight() - bounds2.getLeft();
                int height2 = bounds2.getBottom() - bounds2.getTop();
                NlComponentHelperKt.setBounds(component, left, top, Math.max(width2, 1), Math.max(height2, 1));
            }
        }
        parentX += bounds2.getLeft();
        parentY += bounds2.getTop();
        for (ViewInfo child : view2.getChildren()) {
            NlModelHierarchyUpdater.updateBounds(child, parentX, parentY, snapshotToComponent, tagToComponent);
        }
    }

    private static void fixBounds(@NotNull NlComponent root) {
        List<NlComponent> children;
        boolean computeBounds = false;
        if (NlComponentHelperKt.getW(root) == -1 && NlComponentHelperKt.getH(root) == -1) {
            computeBounds = true;
            NlComponent parent = root.getParent();
            if (parent != null && NlComponentHelperKt.getW(parent) >= 0) {
                NlComponentHelperKt.setBounds(root, NlComponentHelperKt.getX(parent), NlComponentHelperKt.getY(parent), 0, 0);
            }
        }
        if (!(children = root.getChildren()).isEmpty()) {
            for (NlComponent child : children) {
                NlModelHierarchyUpdater.fixBounds(child);
            }
            if (computeBounds) {
                Rectangle rectangle = new Rectangle(NlComponentHelperKt.getX(root), NlComponentHelperKt.getY(root), NlComponentHelperKt.getW(root), NlComponentHelperKt.getH(root));
                for (NlComponent child : children) {
                    rectangle = rectangle.union(new Rectangle(NlComponentHelperKt.getX(child), NlComponentHelperKt.getY(child), NlComponentHelperKt.getW(child), NlComponentHelperKt.getH(child)));
                }
                NlComponentHelperKt.setBounds(root, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private static void clearDerivedData(@NotNull NlComponent component) {
        NlComponentHelperKt.setBounds(component, 0, 0, -1, -1);
        NlComponentHelperKt.setViewInfo(component, null);
    }
}

