/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.tools.idea.uibuilder.scene.RenderingQueue;
import com.intellij.openapi.Disposable;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import org.jetbrains.annotations.NotNull;

public class MergingRenderingQueue
implements RenderingQueue {
    private MergingUpdateQueue myRenderingQueue;
    private static final int RENDER_DELAY_MS = 10;
    @NotNull
    private final Disposable myParentDisposable;

    MergingRenderingQueue(@NotNull Disposable parentDisposable) {
        this.myParentDisposable = parentDisposable;
    }

    @NotNull
    private synchronized MergingUpdateQueue getRenderingQueue() {
        if (this.myRenderingQueue == null) {
            this.myRenderingQueue = new MergingUpdateQueue("android.layout.rendering", 10, true, null, this.myParentDisposable, null, Alarm.ThreadToUse.POOLED_THREAD);
            this.myRenderingQueue.setRestartTimerOnAdd(true);
        }
        return this.myRenderingQueue;
    }

    @Override
    public synchronized void deactivate() {
        if (this.myRenderingQueue != null) {
            this.myRenderingQueue.cancelAllUpdates();
        }
    }

    @Override
    public void queue(@NotNull Update update) {
        this.getRenderingQueue().queue(update);
    }
}

