/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.tools.idea.common.surface.DesignSurface;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class DesignSurfaceProgressIndicator {
    private AndroidPreviewProgressIndicator myCurrentIndicator;
    private final DesignSurface<?> myDesignSurface;

    public DesignSurfaceProgressIndicator(@NotNull DesignSurface<?> designSurface) {
        this.myDesignSurface = designSurface;
    }

    public synchronized void start() {
        if (this.myCurrentIndicator == null) {
            this.myCurrentIndicator = new AndroidPreviewProgressIndicator();
            this.myCurrentIndicator.start();
        }
    }

    public synchronized void stop() {
        if (this.myCurrentIndicator != null) {
            this.myCurrentIndicator.stop();
            this.myCurrentIndicator = null;
        }
    }

    private class AndroidPreviewProgressIndicator
    extends ProgressIndicatorBase {
        private final Object myLock = new Object();

        private AndroidPreviewProgressIndicator() {
        }

        public void start() {
            super.start();
            UIUtil.invokeLaterIfNeeded(() -> {
                Timer timer = TimerUtil.createNamedTimer((String)"Android rendering progress timer", (int)0, event -> {
                    Object object = this.myLock;
                    synchronized (object) {
                        if (this.isRunning()) {
                            DesignSurfaceProgressIndicator.this.myDesignSurface.registerIndicator((ProgressIndicator)this);
                        }
                    }
                });
                timer.setRepeats(false);
                timer.start();
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.myLock;
            synchronized (object) {
                super.stop();
                ApplicationManager.getApplication().invokeLater(() -> DesignSurfaceProgressIndicator.this.myDesignSurface.unregisterIndicator((ProgressIndicator)this));
            }
        }
    }
}

