/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.idea.uibuilder.api.PaletteComponentHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.google.common.base.Splitter;
import com.intellij.openapi.util.IconLoader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="palette")
public class Palette {
    public static final Palette EMPTY = new Palette();
    @XmlElements(value={@XmlElement(name="group", type=Group.class), @XmlElement(name="item", type=Item.class)})
    private final List<BaseItem> myItems = new ArrayList<BaseItem>();
    private final Map<String, Item> myItemsById = new HashMap<String, Item>();

    private Palette() {
    }

    public static Palette parse(@NotNull Reader xmlReader, @NotNull ViewHandlerManager manager) throws JAXBException {
        Palette palette = Palette.unMarshal(xmlReader);
        palette.accept(item -> item.setUp(palette, manager));
        palette.setParentGroups();
        return palette;
    }

    private void setParentGroups() {
        this.accept(new Visitor(){

            @Override
            public void visit(@NotNull Item item) {
            }

            @Override
            public void visit(@NotNull Group group) {
                group.getItems().forEach(item -> item.setParent(group));
            }
        });
    }

    @NotNull
    public List<BaseItem> getItems() {
        return this.myItems;
    }

    @Nullable
    public Item getItemById(@NotNull String id2) {
        return this.myItemsById.get(id2);
    }

    @NotNull
    public Set<String> getGradleCoordinateIds() {
        HashSet<String> gradleCoordinateIds = new HashSet<String>();
        this.accept(item -> item.addGradleCoordinateId(gradleCoordinateIds));
        return gradleCoordinateIds;
    }

    private static Palette unMarshal(@NotNull Reader xmlReader) throws JAXBException {
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Palette.class}).createUnmarshaller();
        unmarshaller.setEventHandler(event -> {
            throw new RuntimeException(event.getLinkedException());
        });
        return (Palette)unmarshaller.unmarshal(xmlReader);
    }

    public void accept(@NotNull Visitor visitor) {
        for (BaseItem item : this.myItems) {
            item.accept(visitor);
        }
    }

    public static class XmlValuePart {
        @XmlValue
        @Language(value="XML")
        @Nullable
        private String myValue;
        @XmlAttribute(name="reuse")
        private String myReuse;

        @Nullable
        public String getValue() {
            return this.myValue;
        }

        public boolean reuseForDragPreview() {
            return this.myReuse != null && Splitter.on((String)",").trimResults().splitToList((CharSequence)this.myReuse).contains("drag-preview");
        }
    }

    public static class Item
    implements BaseItem {
        @XmlAttribute(required=true, name="tag")
        @NotNull
        private String myTagName;
        @XmlAttribute(name="id")
        @Nullable
        private String myId;
        @XmlAttribute(name="title")
        @Nullable
        private String myTitle;
        @XmlAttribute(name="icon")
        @Nullable
        private String myIconName;
        @XmlAttribute(name="coordinate")
        @Nullable
        private String myGradleCoordinateId;
        @XmlAttribute(name="handler-class")
        @Nullable
        private String myHandlerClass;
        @XmlAttribute(name="suggested")
        @Nullable
        private Boolean mySuggested;
        @XmlAttribute(name="meta")
        @Nullable
        private String myMeta;
        @XmlAttribute(name="materialReference")
        @Nullable
        private String myMaterialReference;
        @XmlAttribute(name="info")
        @Nullable
        private String myInfo;
        @XmlElement(name="xml", type=XmlValuePart.class)
        private XmlValuePart myXmlValuePart;
        @Language(value="XML")
        @Nullable
        private String myXml;
        @XmlElement(name="drag-preview")
        @Language(value="XML")
        @Nullable
        private String myDragPreviewXml;
        @Nullable
        private Group myParent;
        private List<String> myMetaTags;
        private PaletteComponentHandler myHandler;

        private Item() {
        }

        public Item(@NotNull String tagName, @NotNull ViewHandler handler) {
            this.myTagName = tagName;
            this.myHandler = handler;
        }

        @NotNull
        public String getTagName() {
            return this.myTagName;
        }

        @NotNull
        public String getId() {
            return this.myId != null ? this.myId : this.myTagName;
        }

        @NotNull
        public String getTitle() {
            if (this.myTitle != null) {
                return this.myTitle;
            }
            return this.myHandler.getTitle(this.myTagName);
        }

        @NotNull
        public Icon getIcon() {
            Icon icon2;
            if (this.myIconName != null && (icon2 = IconLoader.findIcon((String)this.myIconName, (ClassLoader)this.getClass().getClassLoader())) != null) {
                return icon2;
            }
            return this.myHandler.getIcon(this.myTagName);
        }

        public String getGradleCoordinateId() {
            if (this.myGradleCoordinateId != null) {
                return this.myGradleCoordinateId;
            }
            return this.myHandler.getGradleCoordinateId(this.myTagName);
        }

        public boolean isSuggested() {
            if (this.mySuggested != null) {
                return this.mySuggested;
            }
            return false;
        }

        @NotNull
        public List<String> getMetaTags() {
            return this.myMetaTags;
        }

        @Nullable
        public String getMaterialReference() {
            return this.myMaterialReference;
        }

        @Nullable
        public String getInfo() {
            return this.myInfo;
        }

        @NotNull
        @Language(value="XML")
        public String getXml() {
            if (this.myXml != null) {
                return this.myXml;
            }
            return this.myHandler.getXml(this.myTagName, XmlType.COMPONENT_CREATION);
        }

        @NotNull
        @Language(value="XML")
        public String getDragPreviewXml() {
            if (this.myDragPreviewXml != null) {
                return this.myDragPreviewXml;
            }
            return this.myHandler.getXml(this.myTagName, XmlType.DRAG_PREVIEW);
        }

        @Override
        @Nullable
        public Group getParent() {
            return this.myParent;
        }

        @Override
        public void setParent(@NotNull Group parent) {
            this.myParent = parent;
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            visitor.visit(this);
        }

        void setUp(@NotNull Palette palette, @NotNull ViewHandlerManager manager) {
            this.resolve();
            this.initHandler(manager);
            palette.myItemsById.put(this.getId(), this);
        }

        private void resolve() {
            if (this.myXmlValuePart != null) {
                this.myXml = this.myXmlValuePart.getValue();
                if (this.myDragPreviewXml == null && this.myXmlValuePart.reuseForDragPreview()) {
                    this.myDragPreviewXml = this.myXml;
                }
                this.myXmlValuePart = null;
            }
            if (this.myMetaTags == null) {
                this.myMetaTags = this.myMeta == null || this.myMeta.trim().isEmpty() ? Collections.emptyList() : (this.myMeta.indexOf(44) < 0 ? Collections.singletonList(this.myMeta.trim()) : Splitter.on((String)",").trimResults().splitToList((CharSequence)this.myMeta));
            }
        }

        private void initHandler(@NotNull ViewHandlerManager manager) {
            if (this.myHandlerClass != null) {
                try {
                    this.myHandler = (PaletteComponentHandler)Class.forName(this.myHandlerClass).newInstance();
                }
                catch (ReflectiveOperationException exception) {
                    this.myHandler = ViewHandlerManager.NONE;
                }
            } else {
                this.myHandler = manager.getHandlerOrDefault(this.myTagName);
            }
        }

        private void addGradleCoordinateId(@NotNull Set<String> coordinateIds) {
            String coordinateId = this.getGradleCoordinateId();
            if (!coordinateId.isEmpty()) {
                coordinateIds.add(coordinateId);
            }
        }

        @NotNull
        public String toString() {
            return this.getTitle();
        }
    }

    public static class Group
    implements BaseItem {
        @XmlAttribute(required=true, name="name")
        @NotNull
        private String myName;
        @XmlElements(value={@XmlElement(name="group", type=Group.class), @XmlElement(name="item", type=Item.class)})
        private List<BaseItem> myItems = new ArrayList<BaseItem>();
        @Nullable
        private Group myParent;

        private Group() {
        }

        public Group(@NotNull String name) {
            this.myName = name;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        @NotNull
        public List<BaseItem> getItems() {
            return this.myItems;
        }

        @NotNull
        public BaseItem getItem(int index) {
            return this.myItems.get(index);
        }

        @Override
        @Nullable
        public Group getParent() {
            return this.myParent;
        }

        @Override
        public void setParent(@NotNull Group parent) {
            this.myParent = parent;
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            visitor.visit(this);
            for (BaseItem item : this.myItems) {
                item.accept(visitor);
            }
            visitor.visitAfter(this);
        }

        @NotNull
        public String toString() {
            return this.myName;
        }
    }

    static interface BaseItem {
        public void accept(@NotNull Visitor var1);

        @Nullable
        public Group getParent();

        public void setParent(@NotNull Group var1);
    }

    public static interface Visitor {
        public void visit(@NotNull Item var1);

        default public void visit(@NotNull Group group) {
        }

        default public void visitAfter(@NotNull Group group) {
        }
    }
}

