/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.AndroidXConstants;
import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.projectsystem.ProjectSystemBuildManager;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ActionMenuViewHandler;
import com.android.tools.idea.uibuilder.handlers.BuiltinViewHandlerProvider;
import com.android.tools.idea.uibuilder.handlers.CustomViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.CustomViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintHelperHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceCategoryHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceHandler;
import com.android.tools.idea.uibuilder.menu.MenuHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.type.LayoutEditorFileType;
import com.android.tools.idea.uibuilder.type.LayoutFileType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.StudioIcons;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.swing.Icon;
import javax.xml.bind.JAXBException;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NlPaletteModel
implements Disposable {
    private boolean myDisposed;
    @VisibleForTesting
    static final String PROJECT_GROUP = "Project";
    private static final Function<Project, Query<PsiClass>> VIEW_CLASSES_QUERY = project -> {
        PsiClass viewClass = JavaPsiFacade.getInstance((Project)project).findClass("android.view.View", GlobalSearchScope.allScope((Project)project));
        if (viewClass == null) {
            return EmptyQuery.getEmptyQuery();
        }
        return ClassInheritorsSearch.search((PsiClass)viewClass, (SearchScope)ProjectScope.getProjectScope((Project)project), (boolean)true);
    };
    private final Map<LayoutEditorFileType, Palette> myTypeToPalette;
    private final Module myModule;
    private final List<UpdateListener> myListeners = ContainerUtil.createConcurrentList();

    public void dispose() {
        this.myListeners.clear();
        this.myTypeToPalette.clear();
        this.myDisposed = true;
    }

    @TestOnly
    public List<UpdateListener> getUpdateListeners() {
        return this.myListeners;
    }

    public static NlPaletteModel get(@NotNull AndroidFacet facet) {
        return (NlPaletteModel)facet.getModule().getComponent(NlPaletteModel.class);
    }

    private NlPaletteModel(@NotNull Module module) {
        this.myTypeToPalette = Collections.synchronizedMap(new HashMap());
        this.myModule = module;
        Disposer.register((Disposable)module, (Disposable)this);
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @Slow
    @NotNull
    public Palette getPalette(@NotNull LayoutEditorFileType type) {
        Palette palette = this.myTypeToPalette.get(type);
        if (palette == null) {
            palette = this.loadPalette(type);
            this.myTypeToPalette.put(type, palette);
            this.registerAdditionalComponents(type);
        }
        return palette;
    }

    private void registerAdditionalComponents(final @NotNull LayoutEditorFileType type) {
        this.loadAdditionalComponents(type, VIEW_CLASSES_QUERY);
        ProjectSystemService.getInstance((Project)this.myModule.getProject()).getProjectSystem().getBuildManager().addBuildListener((Disposable)this, new ProjectSystemBuildManager.BuildListener(){

            public void buildStarted(@NotNull ProjectSystemBuildManager.BuildMode mode) {
            }

            public void beforeBuildCompleted(@NotNull ProjectSystemBuildManager.BuildResult result) {
            }

            public void buildCompleted(@NotNull ProjectSystemBuildManager.BuildResult result) {
                NlPaletteModel.this.loadAdditionalComponents(type, VIEW_CLASSES_QUERY);
            }
        });
    }

    public void addUpdateListener(@Nullable UpdateListener updateListener) {
        this.myListeners.add(updateListener);
    }

    public void removeUpdateListener(@Nullable UpdateListener updateListener) {
        this.myListeners.remove(updateListener);
    }

    @Slow
    private void notifyUpdateListener(@NotNull LayoutEditorFileType layoutType) {
        if (!this.myListeners.isEmpty() && !this.myDisposed) {
            this.myListeners.forEach(listener2 -> listener2.update(this, layoutType));
        }
    }

    @VisibleForTesting
    @NotNull
    public static String getPaletteFileNameFromId(@NotNull String id2) {
        return id2 + "_palette.xml";
    }

    @Slow
    @NotNull
    private Palette loadPalette(@NotNull LayoutEditorFileType type) {
        Palette palette;
        String id2 = type.getPaletteId();
        if (id2 == null) {
            Logger.getInstance(NlPaletteModel.class).warn(type + " has no palette id. No palette will be used.");
            return Palette.EMPTY;
        }
        URL url = NlPaletteModel.class.getResource(NlPaletteModel.getPaletteFileNameFromId(id2));
        URLConnection connection = url.openConnection();
        InputStreamReader reader = new InputStreamReader(connection.getInputStream(), Charsets.UTF_8);
        try {
            palette = Palette.parse(reader, ViewHandlerManager.get(this.myModule.getProject()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        ((Reader)reader).close();
        return palette;
    }

    @VisibleForTesting
    void loadAdditionalComponents(@NotNull LayoutEditorFileType type, @NotNull Function<Project, Query<PsiClass>> viewClasses) {
        Application application = ApplicationManager.getApplication();
        Project project = this.myModule.getProject();
        ReadAction.nonBlocking(() -> CustomViewInfo.fromPsiClasses((Query<PsiClass>)((Query)viewClasses.apply(project)))).expireWhen(() -> Disposer.isDisposed((Disposable)this)).inSmartMode(project).submit((Executor)AppExecutorUtil.getAppExecutorService()).onSuccess(viewInfos -> application.executeOnPooledThread(() -> this.replaceProjectComponents(type, (Collection<CustomViewInfo>)viewInfos))).onError(error -> NlPaletteModel.getLogger().error(error));
    }

    @Slow
    private void replaceProjectComponents(@NotNull LayoutEditorFileType type, Collection<CustomViewInfo> viewInfos) {
        Palette palette = this.loadPalette(type);
        viewInfos.forEach(viewInfo -> this.addAdditionalComponent(type, PROJECT_GROUP, palette, StudioIcons.LayoutEditor.Palette.CUSTOM_VIEW, viewInfo.tagName, viewInfo.className, null, null, "", null, Collections.emptyList(), Collections.emptyList()));
        this.myTypeToPalette.put(type, palette);
        this.notifyUpdateListener(type);
    }

    @VisibleForTesting
    boolean addAdditionalComponent(@NotNull LayoutEditorFileType type, @NotNull String groupName, @NotNull Palette palette, @Nullable Icon icon16, @NotNull String tagName, @NotNull String className2, @Nullable @Language(value="XML") String xml, @Nullable @Language(value="XML") String previewXml, @NotNull String libraryCoordinate, @Nullable String preferredProperty, @NotNull List<String> properties2, @NotNull List<String> layoutProperties) {
        if (tagName.indexOf(46) < 0 || !NlComponentHelper.INSTANCE.viewClassToTag(tagName).equals(tagName) || AndroidXConstants.CONSTRAINT_LAYOUT.isEquals(tagName)) {
            return false;
        }
        ViewHandler handler = this.findOrCreateCustomHandler(tagName, icon16, className2, xml, previewXml, libraryCoordinate, preferredProperty, properties2, layoutProperties);
        if (type != LayoutFileType.INSTANCE || handler == null || handler instanceof PreferenceHandler || handler instanceof PreferenceCategoryHandler || handler instanceof MenuHandler || handler instanceof ActionMenuViewHandler) {
            return false;
        }
        List<Palette.BaseItem> groups2 = palette.getItems();
        Palette.Group group = groups2.stream().filter(Palette.Group.class::isInstance).map(Palette.Group.class::cast).filter(g -> groupName.equals(g.getName())).findFirst().orElse(null);
        if (group == null) {
            group = new Palette.Group(groupName);
            groups2.add(group);
        }
        ViewHandlerManager manager = ViewHandlerManager.get(this.myModule.getProject());
        Palette.Item item = new Palette.Item(tagName, handler);
        group.getItems().add(item);
        item.setUp(palette, manager);
        item.setParent(group);
        return true;
    }

    @Nullable
    private ViewHandler findOrCreateCustomHandler(@NotNull String tagName, @Nullable Icon icon16, @NotNull String className2, @Nullable @Language(value="XML") String xml, @Nullable @Language(value="XML") String previewXml, @NotNull String libraryCoordinate, @Nullable String preferredProperty, @NotNull List<String> properties2, @NotNull List<String> layoutProperties) {
        ViewHandler handler = BuiltinViewHandlerProvider.INSTANCE.findHandler(tagName);
        if (handler != null) {
            return handler;
        }
        ViewHandlerManager manager = ViewHandlerManager.get(this.myModule.getProject());
        handler = manager.getHandlerOrDefault(tagName);
        if (handler instanceof ConstraintHelperHandler) {
            return null;
        }
        if (handler instanceof CustomViewGroupHandler && ((CustomViewGroupHandler)handler).getTagName().equals(tagName)) {
            return handler;
        }
        if (handler instanceof CustomViewHandler && ((CustomViewHandler)handler).getTagName().equals(tagName)) {
            return handler;
        }
        handler = handler instanceof ViewGroupHandler ? new CustomViewGroupHandler((ViewGroupHandler)handler, icon16, tagName, className2, xml, previewXml, libraryCoordinate, preferredProperty, properties2, layoutProperties) : new CustomViewHandler(handler, icon16, tagName, className2, xml, previewXml, libraryCoordinate, preferredProperty, properties2);
        manager.registerHandler(tagName, handler);
        return handler;
    }

    private static Logger getLogger() {
        return Logger.getInstance(NlPaletteModel.class);
    }

    public static interface UpdateListener {
        public void update(@NotNull NlPaletteModel var1, @NotNull LayoutEditorFileType var2);
    }

    private static class CustomViewInfo {
        public final String description;
        public final String tagName;
        public final String className;

        CustomViewInfo(String description, String tagName, String className2) {
            this.description = description;
            this.tagName = tagName;
            this.className = className2;
        }

        static Collection<CustomViewInfo> fromPsiClasses(Query<PsiClass> psiClasses) {
            ArrayList<CustomViewInfo> componentInfos = new ArrayList<CustomViewInfo>();
            psiClasses.forEach(psiClass -> {
                String description = psiClass.getName();
                String tagName = psiClass.getQualifiedName();
                String className2 = PackageClassConverter.getQualifiedName((PsiClass)psiClass);
                if (description == null || tagName == null || className2 == null) {
                    return;
                }
                componentInfos.add(new CustomViewInfo(description, tagName, className2));
            });
            return componentInfos;
        }
    }
}

