/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.AndroidXConstants;
import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.uibuilder.palette.CategoryListModel;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.ItemListModel;
import com.android.tools.idea.uibuilder.palette.NlPaletteModel;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette.PatternFilter;
import com.android.tools.idea.uibuilder.type.LayoutEditorFileType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@UiThread
public class DataModel
implements Disposable {
    public static final Palette.Group COMMON = new Palette.Group("Common");
    public static final Palette.Group RESULTS = new Palette.Group("All Results");
    @VisibleForTesting
    public static final String FAVORITE_ITEMS = "Palette.Favorite.items";
    private final CategoryListModel myListModel;
    private final ItemListModel myItemModel;
    private final Condition<Palette.Item> myFilterCondition;
    private final PatternFilter myFilterPattern;
    private final DependencyManager myDependencyManager;
    private final List<String> myFavoriteItems;
    private final NlPaletteModel.UpdateListener myUpdateListener;
    private NlPaletteModel myPaletteModel;
    private LayoutEditorFileType myLayoutType;
    private final ReentrantReadWriteLock myPaletteLock = new ReentrantReadWriteLock();
    private Palette myPalette;
    private Palette.Group myCurrentSelectedGroup;
    private boolean myDisposed;

    public DataModel(@NotNull Disposable parent, @NotNull DependencyManager dependencyManager) {
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myListModel = new CategoryListModel();
        this.myItemModel = new ItemListModel();
        this.myFavoriteItems = DataModel.readFavoriteItems();
        this.myDependencyManager = dependencyManager;
        this.myPalette = Palette.EMPTY;
        this.myCurrentSelectedGroup = COMMON;
        this.myUpdateListener = this::update;
        this.myDependencyManager.addDependencyChangeListener(this::onDependenciesChanged);
        this.myFilterPattern = new PatternFilter();
        Condition androidxFilter = item -> {
            boolean isOldSupportLibTag;
            String tagName = item.getTagName();
            boolean isAndroidxTag = tagName.startsWith("androidx") || tagName.startsWith("com.google.android.material");
            boolean bl = isOldSupportLibTag = !isAndroidxTag && tagName.startsWith("android.support.");
            if (!isAndroidxTag && !isOldSupportLibTag) {
                return true;
            }
            return this.myDependencyManager.useAndroidXDependencies() ? isAndroidxTag : isOldSupportLibTag;
        };
        this.myFilterCondition = Conditions.and((Condition)androidxFilter, (Condition)this.myFilterPattern);
    }

    @NotNull
    public CategoryListModel getCategoryListModel() {
        return this.myListModel;
    }

    @NotNull
    public ItemListModel getItemListModel() {
        return this.myItemModel;
    }

    @NotNull
    public CompletableFuture<Void> setLayoutTypeAsync(@NotNull AndroidFacet facet, @NotNull LayoutEditorFileType layoutType) {
        NlPaletteModel paletteModel = NlPaletteModel.get(facet);
        if (layoutType.equals(this.myLayoutType) && paletteModel == this.myPaletteModel) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.myPaletteModel != null) {
            this.myPaletteModel.removeUpdateListener(this.myUpdateListener);
        }
        this.myLayoutType = layoutType;
        this.myPaletteModel = paletteModel;
        this.myPaletteModel.addUpdateListener(this.myUpdateListener);
        return CompletableFuture.runAsync(() -> {
            Palette palette = paletteModel.getPalette(layoutType);
            this.myPaletteLock.writeLock().lock();
            try {
                this.myPalette = palette;
                this.myDependencyManager.setPalette(this.myPalette, facet.getModule());
            }
            finally {
                this.myPaletteLock.writeLock().unlock();
            }
        }, AppExecutorUtil.getAppExecutorService()).thenRunAsync(this::update, (Executor)EdtExecutorService.getInstance());
    }

    public void dispose() {
        if (this.myPaletteModel != null) {
            this.myPaletteModel.removeUpdateListener(this.myUpdateListener);
        }
        this.myDisposed = true;
    }

    public void setFilterPattern(@NotNull String pattern) {
        if (this.myFilterPattern.setPattern(pattern)) {
            this.update();
        }
    }

    public boolean hasFilterPattern() {
        return this.myFilterPattern.hasPattern();
    }

    public int getMatchCount() {
        return this.myListModel.getMatchCountAt(0);
    }

    public void categorySelectionChanged(@NotNull Palette.Group selectedGroup) {
        this.createFilteredItems(selectedGroup);
        this.myCurrentSelectedGroup = selectedGroup;
    }

    public boolean isFavoriteItem(@NotNull Palette.Item item) {
        return this.myFavoriteItems.contains(item.getId());
    }

    public void addFavoriteItem(@NotNull Palette.Item item) {
        if (this.myFavoriteItems.contains(item.getId())) {
            return;
        }
        this.myFavoriteItems.add(item.getId());
        PropertiesComponent.getInstance().setList(FAVORITE_ITEMS, this.myFavoriteItems);
        this.update();
    }

    public void removeFavoriteItem(@NotNull Palette.Item item) {
        if (!this.myFavoriteItems.contains(item.getId())) {
            return;
        }
        this.myFavoriteItems.remove(item.getId());
        PropertiesComponent.getInstance().setList(FAVORITE_ITEMS, this.myFavoriteItems);
        this.update();
        if (this.myCurrentSelectedGroup == COMMON) {
            this.createFilteredItems(COMMON);
        }
    }

    @NotNull
    @VisibleForTesting
    Palette getPalette() {
        this.myPaletteLock.readLock().lock();
        try {
            Palette palette = this.myPalette;
            return palette;
        }
        finally {
            this.myPaletteLock.readLock().unlock();
        }
    }

    @NotNull
    private static List<String> readFavoriteItems() {
        List favorites = PropertiesComponent.getInstance().getList(FAVORITE_ITEMS);
        if (favorites == null) {
            return Lists.newArrayList((Object[])new String[]{"TextView", "Button", "ImageView", AndroidXConstants.RECYCLER_VIEW.oldName(), AndroidXConstants.RECYCLER_VIEW.newName(), "androidx.fragment.app.FragmentContainerView", "ScrollView", "Switch", "CheckBoxPreference", "EditTextPreference", "SwitchPreference", "PreferenceCategory"});
        }
        return favorites;
    }

    @Slow
    private void update(@NotNull NlPaletteModel paletteModel, @NotNull DesignerEditorFileType layoutType) {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (this.myPaletteModel != paletteModel || layoutType != this.myLayoutType || this.myDisposed || Disposer.isDisposed((Disposable)paletteModel)) {
            return;
        }
        this.myPaletteLock.writeLock().lock();
        try {
            this.myPalette = paletteModel.getPalette(this.myLayoutType);
            this.myDependencyManager.setPalette(this.myPalette, paletteModel.getModule());
        }
        finally {
            this.myPaletteLock.writeLock().unlock();
        }
        ApplicationManager.getApplication().invokeLater(this::update);
    }

    @UiThread
    private void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myLayoutType != null);
        final boolean isUserSearch = this.myFilterPattern.hasPattern();
        final ArrayList<Palette.Group> groups2 = new ArrayList<Palette.Group>();
        final ArrayList<Integer> matchCounts = isUserSearch ? new ArrayList<Integer>() : Collections.emptyList();
        groups2.add(isUserSearch ? RESULTS : COMMON);
        if (isUserSearch) {
            matchCounts.add(0);
        }
        this.getPalette().accept(new Palette.Visitor(){
            private Palette.Group currentGroup;
            private int matchCount;
            {
                this.currentGroup = isUserSearch ? RESULTS : COMMON;
            }

            @Override
            public void visit(@NotNull Palette.Group group) {
                this.currentGroup = group;
                this.matchCount = 0;
            }

            @Override
            public void visit(@NotNull Palette.Item item) {
                if (this.currentGroup.equals(item.getParent()) && DataModel.this.myFilterCondition.value((Object)item)) {
                    ++this.matchCount;
                }
            }

            @Override
            public void visitAfter(@NotNull Palette.Group group) {
                if (this.matchCount > 0) {
                    groups2.add(group);
                    if (isUserSearch) {
                        matchCounts.add(this.matchCount);
                        matchCounts.set(0, (Integer)matchCounts.get(0) + this.matchCount);
                    }
                }
            }
        });
        this.myListModel.update(groups2, matchCounts);
    }

    private void onDependenciesChanged() {
        this.update();
        this.categorySelectionChanged(this.myCurrentSelectedGroup);
    }

    private void createFilteredItems(@NotNull Palette.Group selectedGroup) {
        ArrayList<Palette.Item> items = new ArrayList<Palette.Item>();
        Palette.Visitor visitor = item -> {
            if (this.myFilterCondition.value((Object)item)) {
                items.add(item);
            }
        };
        if (selectedGroup != COMMON && selectedGroup != RESULTS) {
            selectedGroup.accept(visitor);
        } else if (this.myListModel.getSize() <= 1 || selectedGroup == RESULTS) {
            this.getPalette().accept(visitor);
        } else {
            Palette palette = this.getPalette();
            for (String id2 : this.myFavoriteItems) {
                Palette.Item item2 = palette.getItemById(id2);
                if (item2 == null) continue;
                visitor.visit(item2);
            }
        }
        this.updateItemModel(items);
    }

    private void updateItemModel(@NotNull List<Palette.Item> items) {
        UIUtil.invokeLaterIfNeeded(() -> this.myItemModel.update(items));
    }
}

