/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlDependencyManager;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlComponentData;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.psi.xml.XmlTag;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VisibleForTesting
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J&\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0016J\u0016\u0010\u001d\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/uibuilder/model/NlComponentMixin;", "Lcom/android/tools/idea/common/model/NlComponent$XmlModelComponentMixin;", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "(Lcom/android/tools/idea/common/model/NlComponent;)V", "data", "Lcom/android/tools/idea/uibuilder/model/NlComponentData;", "getData$intellij_android_designer", "()Lcom/android/tools/idea/uibuilder/model/NlComponentData;", "afterMove", "", "insertType", "Lcom/android/tools/idea/common/api/InsertType;", "previousParent", "receiver", "beforeMove", "ids", "", "", "canAddTo", "", "getAttribute", "namespace", "attribute", "getDependencies", "", "getIcon", "Ljavax/swing/Icon;", "getTooltipText", "maybeHandleDeletion", "children", "", "postCreate", "postCreateFromTransferrable", "dndComponent", "Lcom/android/tools/idea/common/model/DnDTransferComponent;", "toString", "intellij.android.designer"})
public final class NlComponentMixin
extends NlComponent.XmlModelComponentMixin {
    @NotNull
    private final NlComponentData data;

    public NlComponentMixin(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super(component);
        this.data = new NlComponentData(0, 0, 0, 0, null, null, null, 127, null);
    }

    public boolean maybeHandleDeletion(@NotNull Collection<? extends NlComponent> children) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(this.getComponent().getModel().getFacet());
        Intrinsics.checkNotNullExpressionValue((Object)viewHandlerManager, (String)"get(component.model.facet)");
        ViewHandlerManager viewHandlerManager2 = viewHandlerManager;
        ViewHandler handler = viewHandlerManager2.getHandler(this.getComponent());
        if (handler instanceof ViewGroupHandler) {
            return ((ViewGroupHandler)handler).deleteChildren(this.getComponent(), children);
        }
        return false;
    }

    @NotNull
    public final NlComponentData getData$intellij_android_designer() {
        return this.data;
    }

    @Override
    @NotNull
    public String toString() {
        String string = "%s (%s, %s) %s \u00d7 %s";
        Object[] objectArray = new Object[]{super.toString(), this.data.getX(), this.data.getY(), this.data.getW(), this.data.getH()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @Override
    @Nullable
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String string = this.getComponent().getAttribute(null, "style");
        if (string == null) {
            return null;
        }
        String styleAttributeValue = string;
        ResourceResolver resourceResolver = this.getComponent().getModel().getConfiguration().getResourceResolver();
        if (resourceResolver == null) {
            return null;
        }
        ResourceResolver resources = resourceResolver;
        ResourceValueImpl tmpResourceValue = new ResourceValueImpl(ResourceNamespace.TODO(), ResourceType.STYLE, this.getComponent().getTagName(), styleAttributeValue);
        ResourceValue resourceValue2 = resources.resolveResValue((ResourceValue)tmpResourceValue);
        StyleResourceValue styleResourceValue = resourceValue2 instanceof StyleResourceValue ? (StyleResourceValue)resourceValue2 : null;
        if (styleResourceValue == null) {
            return null;
        }
        StyleResourceValue styleResourceValue2 = styleResourceValue;
        ResourceValue resourceValue3 = resources.findItemInStyle(styleResourceValue2, attribute, true);
        if (resourceValue3 == null) {
            return null;
        }
        ResourceValue itemResourceValue = resourceValue3;
        return itemResourceValue.getValue();
    }

    @Override
    @Nullable
    public String getTooltipText() {
        String string = this.getComponent().getId();
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        NlComponent nlComponent = this.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"component");
        String string2 = NlComponentHelperKt.getComponentClassName(nlComponent);
        if (string2 == null) {
            return null;
        }
        String str = string2;
        String string3 = str.substring(StringsKt.lastIndexOf$default((CharSequence)str, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        return string3;
    }

    @Override
    public boolean canAddTo(@NotNull NlComponent receiver) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        if (!NlComponentHelperKt.getHasNlComponentInfo(receiver)) {
            return false;
        }
        ViewHandler viewHandler = NlComponentHelperKt.getViewHandler(receiver);
        ViewGroupHandler viewGroupHandler = viewHandler instanceof ViewGroupHandler ? (ViewGroupHandler)viewHandler : null;
        if (viewGroupHandler == null) {
            return false;
        }
        ViewGroupHandler parentHandler = viewGroupHandler;
        if (!parentHandler.acceptsChild(receiver, this.getComponent())) {
            return false;
        }
        ViewHandler handler = ViewHandlerManager.get(this.getComponent().getModel().getProject()).getHandler(this.getComponent());
        return handler == null || handler.acceptsParent(receiver, this.getComponent());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getDependencies() {
        void $this$flatMapTo$iv$iv;
        Set artifacts = new LinkedHashSet();
        ViewHandler viewHandler = ViewHandlerManager.get(this.getComponent().getModel().getProject()).getHandler(this.getComponent());
        if (viewHandler == null) {
            return SetsKt.emptySet();
        }
        ViewHandler handler = viewHandler;
        String string = handler.getGradleCoordinateId(this.getComponent().getTagDeprecated().getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"handler.getGradleCoordin\u2026onent.tagDeprecated.name)");
        String artifactId = string;
        if (!Intrinsics.areEqual((Object)artifactId, (Object)"")) {
            artifacts.add(artifactId);
        }
        List<NlComponent> list = this.getComponent().getChildren();
        Intrinsics.checkNotNullExpressionValue(list, (String)"component.children");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            NlComponent it = (NlComponent)element$iv$iv;
            boolean bl = false;
            Set<String> set = it.getDependencies();
            Intrinsics.checkNotNullExpressionValue(set, (String)"it.dependencies");
            Iterable list$iv$iv = set;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)artifacts);
        return CollectionsKt.toSet((Iterable)artifacts);
    }

    @Override
    public void beforeMove(@NotNull InsertType insertType, @NotNull NlComponent receiver, @NotNull Set<String> ids) {
        Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        NlComponent nlComponent = this.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"component");
        if (NlComponentHelperKt.needsDefaultId(nlComponent) && insertType != InsertType.MOVE) {
            this.getComponent().incrementId(ids);
        }
    }

    @Override
    public void afterMove(@NotNull InsertType insertType, @Nullable NlComponent previousParent, @NotNull NlComponent receiver) {
        block1: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            if (!Intrinsics.areEqual((Object)previousParent, (Object)receiver) && (object = previousParent) != null && (object = NlComponentHelperKt.getViewGroupHandler((NlComponent)object)) != null) {
                ((ViewGroupHandler)object).onChildRemoved(previousParent, this.getComponent(), insertType);
            }
            ViewGroupHandler viewGroupHandler = NlComponentHelperKt.getViewGroupHandler(receiver);
            if (viewGroupHandler == null) break block1;
            viewGroupHandler.onChildInserted(receiver, this.getComponent(), insertType);
        }
    }

    @Override
    public boolean postCreate(@NotNull InsertType insertType) {
        block11: {
            Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
            XmlTag xmlTag = this.getComponent().getTagDeprecated();
            Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"component.tagDeprecated");
            XmlTag realTag = xmlTag;
            if (this.getComponent().getParent() != null) {
                if (realTag.getAttribute("layout_width", "http://schemas.android.com/apk/res/android") == null) {
                    realTag.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", "wrap_content");
                }
                if (realTag.getAttribute("layout_height", "http://schemas.android.com/apk/res/android") == null) {
                    realTag.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", "wrap_content");
                }
            } else {
                if (realTag.getAttribute("android:layout_width") == null) {
                    realTag.setAttribute("android:layout_width", "wrap_content");
                }
                if (realTag.getAttribute("android:layout_height") == null) {
                    realTag.setAttribute("android:layout_height", "wrap_content");
                }
            }
            ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(this.getComponent().getModel().getProject());
            Intrinsics.checkNotNullExpressionValue((Object)viewHandlerManager, (String)"get(component.model.project)");
            ViewHandlerManager viewHandlerManager2 = viewHandlerManager;
            ViewHandler childHandler = viewHandlerManager2.getHandler(this.getComponent());
            if (childHandler != null) {
                boolean ok = childHandler.onCreate(this.getComponent().getParent(), this.getComponent(), insertType);
                if (this.getComponent().getParent() != null) {
                    NlDependencyManager nlDependencyManager = NlDependencyManager.Companion.getInstance();
                    Iterable iterable = CollectionsKt.listOf((Object)this.getComponent());
                    AndroidFacet androidFacet = this.getComponent().getModel().getFacet();
                    Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"component.model.facet");
                    ok &= NlDependencyManager.addDependencies$default(nlDependencyManager, iterable, androidFacet, true, null, 8, null);
                }
                if (!ok) {
                    NlComponent nlComponent = this.getComponent().getParent();
                    if (nlComponent != null) {
                        nlComponent.removeChild(this.getComponent());
                    }
                    realTag.delete();
                    return false;
                }
            }
            NlComponent nlComponent = this.getComponent().getParent();
            if (nlComponent == null) break block11;
            NlComponent it = nlComponent;
            boolean bl = false;
            ViewHandler parentHandler = viewHandlerManager2.getHandler(it);
            ViewGroupHandler viewGroupHandler = parentHandler instanceof ViewGroupHandler ? (ViewGroupHandler)parentHandler : null;
            if (viewGroupHandler != null) {
                viewGroupHandler.onChildInserted(it, this.getComponent(), insertType);
            }
        }
        return true;
    }

    @Override
    public void postCreateFromTransferrable(@NotNull DnDTransferComponent dndComponent) {
        Intrinsics.checkNotNullParameter((Object)dndComponent, (String)"dndComponent");
        NlComponent nlComponent = this.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"component");
        NlComponentHelperKt.setW(nlComponent, dndComponent.getWidth());
        NlComponent nlComponent2 = this.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent2, (String)"component");
        NlComponentHelperKt.setH(nlComponent2, dndComponent.getHeight());
    }

    @Override
    @NotNull
    public Icon getIcon() {
        ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(this.getComponent().getModel().getProject());
        Intrinsics.checkNotNullExpressionValue((Object)viewHandlerManager, (String)"get(component.model.project)");
        ViewHandlerManager manager = viewHandlerManager;
        ViewHandler viewHandler = manager.getHandler(this.getComponent());
        if (viewHandler == null) {
            Icon icon2 = StudioIcons.LayoutEditor.Palette.VIEW;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"VIEW");
            return icon2;
        }
        ViewHandler handler = viewHandler;
        Icon icon3 = handler.getIcon(this.getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"handler.getIcon(component)");
        return icon3;
    }
}

