/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.res.FloatResources;
import com.android.tools.idea.res.ResourceIdManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutParamsManager {
    private static final Object MISSING = new Object();
    private static final Cache<String, Map<String, Object>> ourDefaultValuesCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).softValues().build();
    private static final Map<String, Function<String, MappedField>> FIELD_MAPPERS = new HashMap<String, Function<String, MappedField>>();
    private static final Function<String, MappedField> CONSTRAINT_LAYOUT_MAPPER = attributeName -> {
        attributeName = StringUtil.trimStart((String)attributeName, (String)"constraint");
        attributeName = StringUtil.trimEnd((String)attributeName, (String)"Of");
        StringBuilder fieldName = new StringBuilder();
        boolean first = true;
        for (String component : Splitter.on((char)'_').split((CharSequence)attributeName)) {
            fieldName.append(first ? StringUtil.decapitalize((String)component) : StringUtil.capitalize((String)component));
            first = false;
        }
        return new MappedField(fieldName.toString(), null);
    };
    private static final Function<String, MappedField> COORDINATOR_LAYOUT_MAPPER = attributeName -> {
        if ("anchor".equals(attributeName)) {
            return new MappedField("anchorId", AttributeFormat.INTEGER);
        }
        return null;
    };

    public static void registerFieldMapper(@NotNull String layoutParamsClassName, @NotNull Function<String, MappedField> mapper) {
        FIELD_MAPPERS.put(layoutParamsClassName, mapper);
    }

    @NotNull
    private static EnumSet<AttributeFormat> attributeFormatFromType(@NotNull Class type) {
        if (type == Integer.class || type == Integer.TYPE) {
            return EnumSet.of(AttributeFormat.INTEGER);
        }
        if (type == Float.class || type == Float.TYPE) {
            return EnumSet.of(AttributeFormat.FLOAT);
        }
        if (type == String.class) {
            return EnumSet.of(AttributeFormat.STRING);
        }
        return EnumSet.noneOf(AttributeFormat.class);
    }

    private static boolean setField(@NotNull Object target, @NotNull MappedField fieldName, @Nullable Object value2) {
        try {
            target.getClass().getField(fieldName.name).set(target, value2);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            String setterName = "set" + StringUtil.capitalize((String)fieldName.name);
            Optional<Method> setterMethod = Arrays.stream(target.getClass().getMethods()).filter(method -> method.getParameterCount() == 1 && method.getName().equals(setterName)).findFirst();
            if (setterMethod.isPresent()) {
                try {
                    setterMethod.get().invoke(target, value2);
                    return true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    @NotNull
    private static Integer getDimensionValue(@NotNull String value2, @NotNull Configuration configuration) {
        switch (value2) {
            case "fill_parent": 
            case "match_parent": {
                return -1;
            }
            case "wrap_content": {
                return -2;
            }
        }
        FloatResources.TypedValue out = new FloatResources.TypedValue();
        if (FloatResources.parseFloatAttribute((String)value2, (FloatResources.TypedValue)out, (boolean)true)) {
            return FloatResources.TypedValue.complexToDimensionPixelSize((int)out.data, (Configuration)configuration);
        }
        return 0;
    }

    @NotNull
    private static EnumSet<AttributeFormat> inferTypeFromField(@NotNull Object layoutParams, @NotNull MappedField mappedField) {
        try {
            Field field = layoutParams.getClass().getField(mappedField.name);
            return LayoutParamsManager.attributeFormatFromType(field.getType());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return EnumSet.noneOf(AttributeFormat.class);
        }
    }

    @VisibleForTesting
    @Nullable
    static Object getDefaultValue(@NotNull Object layoutParams, @NotNull MappedField field) throws NoSuchElementException {
        Object defaultValue2;
        String layoutParamsClassName = layoutParams.getClass().getName();
        Map<String, Object> layoutParamsDefaults = (Map<String, Object>)ourDefaultValuesCache.getIfPresent((Object)layoutParamsClassName);
        if (layoutParamsDefaults == null) {
            layoutParamsDefaults = LayoutParamsManager.getDefaultValuesFromClass(layoutParams.getClass());
            ourDefaultValuesCache.put((Object)layoutParamsClassName, layoutParamsDefaults);
        }
        if ((defaultValue2 = layoutParamsDefaults.getOrDefault(field.name, MISSING)) == MISSING) {
            throw new NoSuchElementException();
        }
        return defaultValue2;
    }

    @NotNull
    private static EnumSet<AttributeFormat> inferTypeFromValue(@Nullable String value2) {
        if (value2 != null && (value2.endsWith("dp") || value2.endsWith("dip") || value2.endsWith("px"))) {
            return EnumSet.of(AttributeFormat.DIMENSION);
        }
        return EnumSet.noneOf(AttributeFormat.class);
    }

    @VisibleForTesting
    @NotNull
    static Map<String, Object> getDefaultValuesFromClass(@NotNull Class layoutParamsClass) {
        Object layoutParamsClassInstance = null;
        for (Constructor<?> constructor : layoutParamsClass.getConstructors()) {
            Object[] parameterDefaults;
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != (parameterDefaults = Arrays.stream(parameterTypes).map(type -> {
                if (type == Integer.class || type == Integer.TYPE) {
                    return 0;
                }
                return null;
            }).filter(Objects::nonNull).toArray()).length) continue;
            try {
                layoutParamsClassInstance = constructor.newInstance(parameterDefaults);
                break;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (layoutParamsClassInstance == null) {
            return Collections.emptyMap();
        }
        Field[] fields = layoutParamsClass.getFields();
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        Object finalLayoutParamsClassInstance = layoutParamsClassInstance;
        Arrays.stream(fields).filter(field -> !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers())).filter(field -> !"layoutAnimationParameters".equals(field.getName())).forEach(field -> {
            try {
                defaults.put(field.getName(), field.get(finalLayoutParamsClassInstance));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        });
        Method[] methods = layoutParamsClass.getMethods();
        Arrays.stream(methods).filter(method -> method.getParameterCount() == 0 && Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("get")).filter(method -> !method.getDeclaringClass().getName().startsWith("java.lang")).forEach(method -> {
            String propertyName = StringUtil.decapitalize((String)StringUtil.trimStart((String)method.getName(), (String)"get"));
            if (!defaults.containsKey(propertyName)) {
                try {
                    defaults.put(propertyName, method.invoke(finalLayoutParamsClassInstance, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        });
        return defaults;
    }

    @VisibleForTesting
    @NotNull
    static MappedField mapField(@NotNull Object layoutParams, @NotNull String attributeName) {
        Class<?> currentClass = layoutParams.getClass();
        while (!currentClass.equals(Object.class)) {
            MappedField mappedField;
            Function<String, MappedField> fieldMapper = FIELD_MAPPERS.get(currentClass.getName());
            if (fieldMapper != null && (mappedField = fieldMapper.apply(attributeName)) != null) {
                try {
                    currentClass.getDeclaredField(mappedField.name);
                    return mappedField;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    String setterName = "set" + StringUtil.capitalize((String)mappedField.name);
                    for (Method method : currentClass.getDeclaredMethods()) {
                        if (!setterName.equals(method.getName())) continue;
                        return mappedField;
                    }
                }
            }
            currentClass = currentClass.getSuperclass();
        }
        return new MappedField(attributeName, null);
    }

    @VisibleForTesting
    static boolean setAttribute(@Nullable AttributeDefinition attributeDefinition, @NotNull Object layoutParams, @NotNull String attributeName, @Nullable String value2, @NotNull Module module, @NotNull Configuration configuration) {
        ResourceValue resourceValue2;
        EnumSet<AttributeFormat> inferredTypes;
        EnumSet<Object> enumSet = inferredTypes = attributeDefinition != null && !attributeDefinition.getFormats().isEmpty() ? EnumSet.copyOf(attributeDefinition.getFormats()) : EnumSet.noneOf(AttributeFormat.class);
        if (value2 != null && (value2.startsWith("@") || value2.startsWith("?")) && configuration.getResourceResolver() != null && (resourceValue2 = configuration.getResourceResolver().findResValue(value2, false)) != null) {
            value2 = resourceValue2.getValue();
            switch (resourceValue2.getResourceType()) {
                case INTEGER: 
                case ID: 
                case DIMEN: {
                    inferredTypes.add(AttributeFormat.INTEGER);
                    break;
                }
                case FRACTION: {
                    inferredTypes.add(AttributeFormat.FLOAT);
                }
            }
            if (resourceValue2.getResourceType() == ResourceType.ID) {
                value2 = String.valueOf(ResourceIdManager.get((Module)module).getOrGenerateId(resourceValue2.asReference()));
            }
        }
        MappedField mappedField = LayoutParamsManager.mapField(layoutParams, attributeName);
        if (inferredTypes.isEmpty()) {
            inferredTypes.addAll(mappedField.type);
        }
        if (inferredTypes.isEmpty()) {
            inferredTypes.addAll(LayoutParamsManager.inferTypeFromValue(value2));
        }
        if (inferredTypes.isEmpty()) {
            inferredTypes.addAll(LayoutParamsManager.inferTypeFromField(layoutParams, mappedField));
        }
        Object defaultValue2 = null;
        try {
            defaultValue2 = LayoutParamsManager.getDefaultValue(layoutParams, mappedField);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (defaultValue2 != null && inferredTypes.isEmpty()) {
            inferredTypes.addAll(LayoutParamsManager.attributeFormatFromType(defaultValue2.getClass()));
        }
        if (value2 == null) {
            return LayoutParamsManager.setField(layoutParams, mappedField, defaultValue2);
        }
        boolean fieldSet = false;
        block19: for (AttributeFormat type : inferredTypes) {
            switch (type) {
                case DIMENSION: {
                    fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, LayoutParamsManager.getDimensionValue(value2, configuration));
                    break;
                }
                case INTEGER: {
                    try {
                        fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, Integer.parseInt(value2));
                    }
                    catch (NumberFormatException e) {
                        fieldSet = false;
                    }
                    break;
                }
                case STRING: {
                    fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, value2);
                    break;
                }
                case BOOLEAN: {
                    fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, Boolean.parseBoolean(value2));
                    break;
                }
                case FLOAT: {
                    try {
                        fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, Float.valueOf(Float.parseFloat(value2)));
                    }
                    catch (NumberFormatException e) {
                        fieldSet = false;
                    }
                    break;
                }
                case ENUM: {
                    Integer intValue;
                    Integer n = intValue = attributeDefinition != null ? attributeDefinition.getValueMapping(value2) : null;
                    if (intValue == null) break;
                    fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, intValue);
                    break;
                }
                case FLAGS: {
                    if (attributeDefinition == null) continue block19;
                    OptionalInt flagValue = Splitter.on((char)'|').splitToList((CharSequence)value2).stream().map(StringUtil::trim).map(arg_0 -> ((AttributeDefinition)attributeDefinition).getValueMapping(arg_0)).filter(Objects::nonNull).mapToInt(Integer::intValue).reduce((a, b) -> a | b);
                    if (!flagValue.isPresent()) break;
                    fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, flagValue.getAsInt());
                    break;
                }
            }
            if (!fieldSet) continue;
            return true;
        }
        return false;
    }

    public static boolean setAttribute(@NotNull Object layoutParams, @NotNull String attributeName, @Nullable String value2, @NotNull Module module, @NotNull Configuration configuration) {
        AttributeDefinition attributeDefinition = ResolutionUtils.getAttributeDefinition((Module)module, (Configuration)configuration, (String)("layout_" + attributeName));
        return LayoutParamsManager.setAttribute(attributeDefinition, layoutParams, attributeName, value2, module, configuration);
    }

    static {
        LayoutParamsManager.registerFieldMapper(ViewGroup.LayoutParams.class.getName(), attributeName -> {
            switch (attributeName) {
                case "width": 
                case "height": {
                    return new MappedField((String)attributeName, AttributeFormat.DIMENSION);
                }
                case "gravity": {
                    return new MappedField((String)attributeName, AttributeFormat.FLAGS);
                }
            }
            return null;
        });
        LayoutParamsManager.registerFieldMapper(LinearLayout.LayoutParams.class.getName(), attributeName -> "gravity".equals(attributeName) ? new MappedField((String)attributeName, AttributeFormat.FLAGS) : null);
        LayoutParamsManager.registerFieldMapper(ViewGroup.MarginLayoutParams.class.getName(), attributeName -> {
            switch (attributeName) {
                case "marginBottom": {
                    return new MappedField("bottomMargin", AttributeFormat.DIMENSION);
                }
                case "marginTop": {
                    return new MappedField("topMargin", AttributeFormat.DIMENSION);
                }
                case "marginLeft": {
                    return new MappedField("leftMargin", AttributeFormat.DIMENSION);
                }
                case "marginRight": {
                    return new MappedField("rightMargin", AttributeFormat.DIMENSION);
                }
                case "marginStart": {
                    return new MappedField((String)attributeName, AttributeFormat.DIMENSION);
                }
                case "marginEnd": {
                    return new MappedField((String)attributeName, AttributeFormat.DIMENSION);
                }
            }
            return null;
        });
        LayoutParamsManager.registerFieldMapper(AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_PARAMS.oldName(), CONSTRAINT_LAYOUT_MAPPER);
        LayoutParamsManager.registerFieldMapper(AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_PARAMS.newName(), CONSTRAINT_LAYOUT_MAPPER);
        LayoutParamsManager.registerFieldMapper(AndroidXConstants.CLASS_COORDINATOR_LAYOUT.oldName() + "$LayoutParams", COORDINATOR_LAYOUT_MAPPER);
        LayoutParamsManager.registerFieldMapper(AndroidXConstants.CLASS_COORDINATOR_LAYOUT.newName() + "$LayoutParams", COORDINATOR_LAYOUT_MAPPER);
    }

    @VisibleForTesting
    static class MappedField {
        @VisibleForTesting
        @NotNull
        final String name;
        @VisibleForTesting
        @NotNull
        final EnumSet<AttributeFormat> type;

        MappedField(@NotNull String fieldName, @Nullable AttributeFormat type) {
            this.name = fieldName;
            this.type = type != null ? EnumSet.of(type) : EnumSet.noneOf(AttributeFormat.class);
        }
    }
}

