/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.lint;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.error.NlComponentIssueSource;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.lint.LintUtilKt;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintIssueProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/uibuilder/lint/CommonProblemsPanelIssue;", "Lcom/android/tools/idea/common/error/Issue;", "issue", "(Lcom/android/tools/idea/common/error/Issue;)V", "category", "", "getCategory", "()Ljava/lang/String;", "description", "getDescription", "formattedDescription", "getFormattedDescription", "range", "Lcom/intellij/openapi/util/TextRange;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "getSeverity", "()Lcom/intellij/lang/annotation/HighlightSeverity;", "source", "Lcom/android/tools/idea/common/error/IssueSource;", "getSource", "()Lcom/android/tools/idea/common/error/IssueSource;", "summary", "getSummary", "equals", "", "other", "", "hashCode", "", "intellij.android.designer"})
public final class CommonProblemsPanelIssue
extends Issue {
    @NotNull
    private final String summary;
    @NotNull
    private final String description;
    @NotNull
    private final HighlightSeverity severity;
    @NotNull
    private final IssueSource source;
    @NotNull
    private final String category;

    public CommonProblemsPanelIssue(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        this.summary = issue.getSummary();
        this.description = issue.getDescription();
        this.severity = issue.getSeverity();
        this.source = issue.getSource();
        this.category = issue.getCategory();
    }

    @Override
    @NotNull
    public String getSummary() {
        return this.summary;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public HighlightSeverity getSeverity() {
        return this.severity;
    }

    @Override
    @NotNull
    public IssueSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public String getCategory() {
        return this.category;
    }

    @Nullable
    public final TextRange getRange() {
        IssueSource issueSource = this.getSource();
        if (issueSource instanceof VisualLintIssueProvider.VisualLintIssueSource) {
            Iterable $this$forEach$iv = ((VisualLintIssueProvider.VisualLintIssueSource)this.getSource()).getComponents();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NlComponent component = (NlComponent)element$iv;
                boolean bl = false;
                TextRange textRange = LintUtilKt.getTextRange(component);
                if (textRange == null) continue;
                TextRange it = textRange;
                boolean bl2 = false;
                return it;
            }
        } else if (issueSource instanceof NlComponentIssueSource) {
            return LintUtilKt.getTextRange(((NlComponentIssueSource)this.getSource()).getComponent());
        }
        return null;
    }

    @NotNull
    public final String getFormattedDescription() {
        String string = Jsoup.parse((String)this.getDescription()).text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parse(this.description).text()");
        return string;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CommonProblemsPanelIssue)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((CommonProblemsPanelIssue)other).getSeverity(), (Object)this.getSeverity()) && Intrinsics.areEqual((Object)((CommonProblemsPanelIssue)other).getSummary(), (Object)this.getSummary()) && Intrinsics.areEqual((Object)((CommonProblemsPanelIssue)other).getDescription(), (Object)this.getDescription()) && Intrinsics.areEqual((Object)((CommonProblemsPanelIssue)other).getCategory(), (Object)this.getCategory()) && Intrinsics.areEqual((Object)((CommonProblemsPanelIssue)other).getRange(), (Object)this.getRange());
    }

    @Override
    public int hashCode() {
        int result = 13;
        result += 17 * this.getSeverity().hashCode();
        result += 19 * this.getSummary().hashCode();
        result += 23 * this.getDescription().hashCode();
        result += 29 * this.getCategory().hashCode();
        TextRange textRange = this.getRange();
        return result += 31 * (textRange != null ? textRange.hashCode() : 0);
    }
}

