/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.ui;

import com.android.AndroidXConstants;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.ui.AppBarConfigurationUtilKt;
import com.android.tools.idea.uibuilder.handlers.ui.Templates;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppBarConfigurationDialog
extends JDialog {
    private static final String DIALOG_TITLE = "Configure App Bar";
    private static final String DEFAULT_BACKGROUND_IMAGE = "@android:drawable/sym_def_app_icon";
    private static final String DEFAULT_FAB_IMAGE = "@android:drawable/ic_input_add";
    private static final String PREVIEW_PLACEHOLDER_FILE = "preview.xml";
    private static final String SAMPLE_TEXT = "This text is present to test the Application Bar. ";
    private static final int SAMPLE_REPETITION = 200;
    private static final String PREVIEW_HEADER = "Preview:";
    private static final String RENDER_ERROR = "An error happened during rendering...";
    private static final String OVERLAP_TOP_FORMAT = "%1$s:behavior_overlapTop=\"%2$s\"";
    private static final double FUDGE_FACTOR = 0.95;
    private static final int MIN_WIDTH = 40;
    private static final int MIN_HEIGHT = 60;
    private static final int START_WIDTH = 225;
    private static final int START_HEIGHT = 400;
    private final NlModel myModel;
    private final Disposable myDisposable;
    private final JBLoadingPanel myLoadingPanel;
    private final boolean myUserAndroidxDependency;
    private JPanel myContentPane;
    private JButton myButtonOK;
    private JButton myButtonCancel;
    private JBLabel myPreview;
    private JCheckBox myCollapsing;
    private JCheckBox myShowBackgroundImage;
    private JCheckBox myFloatingActionButton;
    private JCheckBox myFitStatusBar;
    private JCheckBox myContentOverlap;
    private JCheckBox myWithTabs;
    private JButton myBackgroundImageSelector;
    private JButton myFloatingActionButtonImageSelector;
    private JPanel myPreviewPanel;
    private JBLabel myCollapsedPreview;
    private JBLabel myExpandedPreview;
    private Future<?> myCollapsedPreviewFuture;
    private Future<?> myExpandedPreviewFuture;
    private JBLabel myExpandedLabel;
    private JBLabel myCollapsedLabel;
    private JCheckBox myParallax;
    private JTextField myContentOverlapAmount;
    private JSpinner myTabCount;
    private boolean myWasAccepted;
    private BufferedImage myExpandedImage;
    private BufferedImage myCollapsedImage;
    private String myBackgroundImage;
    private String myFloatingActionButtonImage;

    public AppBarConfigurationDialog(@NotNull NlModel model2, boolean useAndroidxDependency) {
        this.myModel = model2;
        this.myUserAndroidxDependency = useAndroidxDependency;
        this.$$$setupUI$$$();
        this.myDisposable = Disposer.newDisposable();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.myDisposable, 20);
        this.myLoadingPanel.add((Component)this.myContentPane);
        Disposer.register((Disposable)model2, (Disposable)this.myDisposable);
        this.setTitle(DIALOG_TITLE);
        this.setContentPane((Container)this.myLoadingPanel);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.myButtonOK);
        this.myBackgroundImage = DEFAULT_BACKGROUND_IMAGE;
        this.myFloatingActionButtonImage = DEFAULT_FAB_IMAGE;
        ActionListener updatePreviewListener = event -> {
            this.updateControls();
            this.generatePreviews();
        };
        this.myWithTabs.addActionListener(updatePreviewListener);
        this.myTabCount.setValue(3);
        this.myCollapsing.addActionListener(updatePreviewListener);
        this.myShowBackgroundImage.addActionListener(updatePreviewListener);
        this.myFloatingActionButton.addActionListener(updatePreviewListener);
        this.myFitStatusBar.addActionListener(updatePreviewListener);
        this.myParallax.addActionListener(updatePreviewListener);
        this.myContentOverlap.addActionListener(updatePreviewListener);
        this.myContentOverlapAmount.addActionListener(updatePreviewListener);
        ((GridLayoutManager)this.myPreviewPanel.getLayout()).setRowStretch(0, 2);
        this.myTabCount.addChangeListener(event -> this.generatePreviews());
        ActionListener actionListener = event -> {
            if (event.getSource() == this.myBackgroundImageSelector) {
                String src = ViewEditor.displayResourceInput(this.myModel, EnumSet.of(ResourceType.DRAWABLE));
                if (src != null) {
                    this.myBackgroundImage = src;
                    this.generatePreviews();
                }
            } else if (event.getSource() == this.myFloatingActionButtonImageSelector) {
                String src = ViewEditor.displayResourceInput(this.myModel, EnumSet.of(ResourceType.DRAWABLE));
                if (src != null) {
                    this.myFloatingActionButtonImage = src;
                    this.generatePreviews();
                }
            } else if (event.getSource() == this.myButtonOK) {
                this.onOK();
            } else if (event.getSource() == this.myButtonCancel || event.getSource() == this.myContentPane) {
                this.onCancel();
            }
        };
        this.myBackgroundImageSelector.addActionListener(actionListener);
        this.myFloatingActionButtonImageSelector.addActionListener(actionListener);
        this.myButtonOK.addActionListener(actionListener);
        this.myButtonCancel.addActionListener(actionListener);
        this.myContentPane.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 1);
        this.myPreviewPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AppBarConfigurationDialog.this.updatePreviewImages();
            }
        });
        this.myCollapsedPreview.setName("CollapsedPreview");
        this.myExpandedPreview.setName("ExpandedPreview");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AppBarConfigurationDialog.this.onCancel();
            }
        });
    }

    public boolean open() {
        boolean hasDesignLib;
        Project project = this.myModel.getProject();
        Module module = this.myModel.getModule();
        boolean bl = hasDesignLib = DependencyManagementUtil.dependsOn((Module)module, (GoogleMavenArtifactId)GoogleMavenArtifactId.DESIGN) || DependencyManagementUtil.dependsOn((Module)module, (GoogleMavenArtifactId)GoogleMavenArtifactId.ANDROIDX_DESIGN);
        if (!hasDesignLib && !this.addDesignLibrary()) {
            return false;
        }
        this.myCollapsedPreview.setMinimumSize(new Dimension(225, 400));
        this.myExpandedPreview.setMinimumSize(new Dimension(225, 400));
        this.pack();
        this.myCollapsedPreview.setMinimumSize(null);
        this.myExpandedPreview.setMinimumSize(null);
        Dimension size = this.getSize();
        Rectangle screen = this.getGraphicsConfiguration().getBounds();
        this.setLocation(screen.x + (screen.width - size.width) / 2, screen.y + (screen.height - size.height) / 2);
        this.updateControls();
        this.myButtonOK.requestFocus();
        if (hasDesignLib) {
            this.generatePreviews();
        }
        this.setVisible(true);
        if (this.myWasAccepted) {
            XmlFile file2 = this.myModel.getFile();
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file2}).withName(DIALOG_TITLE).run(() -> this.applyChanges(file2));
        }
        return this.myWasAccepted;
    }

    private boolean addDesignLibrary() {
        this.myLoadingPanel.startLoading();
        Module module = this.myModel.getModule();
        GoogleMavenArtifactId artifact = this.myUserAndroidxDependency ? GoogleMavenArtifactId.ANDROIDX_DESIGN : GoogleMavenArtifactId.DESIGN;
        boolean designAdded = DependencyManagementUtil.addDependenciesWithUiConfirmation((Module)module, Collections.singletonList(artifact.getCoordinate("+")), (boolean)true, (boolean)false).isEmpty();
        if (!designAdded) {
            return false;
        }
        ListenableFuture syncResult = ProjectSystemUtil.getSyncManager((Project)module.getProject()).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
        Futures.addCallback((ListenableFuture)syncResult, (FutureCallback)new FutureCallback<ProjectSystemSyncManager.SyncResult>(){

            public void onSuccess(@Nullable ProjectSystemSyncManager.SyncResult result) {
                if (result != null && result.isSuccessful()) {
                    AppBarConfigurationDialog.this.onDesignSourcesGenerated();
                } else {
                    AppBarConfigurationDialog.this.onBuildError();
                }
            }

            public void onFailure(@NotNull Throwable t) {
                AppBarConfigurationDialog.this.onBuildError();
            }
        }, (Executor)MoreExecutors.directExecutor());
        return true;
    }

    private void onDesignSourcesGenerated() {
        if (this.isVisible()) {
            ApplicationManager.getApplication().invokeLater(this::generatePreviews);
        }
    }

    private void onBuildError() {
        this.myPreview.setText("Preview is unavailable until after a successful project sync");
        this.myPreview.setIcon(AllIcons.General.Warning);
        this.myCollapsedLabel.setVisible(false);
        this.myExpandedLabel.setVisible(false);
        this.myLoadingPanel.stopLoading();
    }

    private void onOK() {
        this.myWasAccepted = true;
        this.dispose();
    }

    private void onCancel() {
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myDisposable);
    }

    @NotNull
    private Project getProject() {
        return this.myModel.getProject();
    }

    private void updateControls() {
        this.myTabCount.setEnabled(this.myWithTabs.isSelected());
        this.myShowBackgroundImage.setEnabled(!this.myWithTabs.isSelected());
        this.myBackgroundImageSelector.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myFitStatusBar.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myParallax.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myFitStatusBar.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myContentOverlap.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myContentOverlapAmount.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected() && this.myContentOverlap.isSelected());
        this.myFloatingActionButtonImageSelector.setEnabled(this.myFloatingActionButton.isSelected());
    }

    private void generatePreviews() {
        this.myExpandedPreviewFuture = AppBarConfigurationDialog.cancel(this.myExpandedPreviewFuture);
        this.myCollapsedPreviewFuture = AppBarConfigurationDialog.cancel(this.myCollapsedPreviewFuture);
        this.myExpandedPreviewFuture = this.updateExpandedImage();
        this.myCollapsedPreviewFuture = this.updateCollapsedImage();
    }

    @Nullable
    private static Future<?> cancel(@Nullable Future<?> future2) {
        if (future2 != null) {
            future2.cancel(true);
        }
        return null;
    }

    @WorkerThread
    private PsiFile generateXml(boolean collapsed) {
        DumbService.getInstance((Project)this.getProject()).waitForSmartMode();
        StringBuilder text = new StringBuilder(200 * SAMPLE_TEXT.length());
        for (int i = 0; i < 200; ++i) {
            text.append(SAMPLE_TEXT);
        }
        Map<String, String> namespaces = AppBarConfigurationDialog.getNameSpaces(null, collapsed);
        String content2 = Templates.getTextView(namespaces.get("http://schemas.android.com/apk/res/android"), text.toString());
        String xml = this.getXml(content2, collapsed, namespaces);
        Project project = this.getProject();
        return (PsiFile)ReadAction.compute(() -> PsiFileFactory.getInstance((Project)project).createFileFromText(PREVIEW_PLACEHOLDER_FILE, (FileType)XmlFileType.INSTANCE, (CharSequence)xml));
    }

    private void updatePreviewImages() {
        if (this.myCollapsedImage != null) {
            this.updatePreviewImage(this.myCollapsedImage, this.myCollapsedPreview);
        }
        if (this.myExpandedImage != null) {
            this.updatePreviewImage(this.myExpandedImage, this.myExpandedPreview);
        }
    }

    private void applyChanges(@NotNull XmlFile file2) {
        Map<String, String> namespaces = AppBarConfigurationDialog.getNameSpaces(file2.getRootTag(), false);
        String xml = this.getXml(AppBarConfigurationDialog.getDesignContent(file2), false, namespaces);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)file2.getProject());
        XmlTag tag = elementFactory.createTagFromText((CharSequence)xml);
        if (file2.getRootTag() == null) {
            file2.add((PsiElement)tag);
        } else {
            file2.getRootTag().replace((PsiElement)tag);
        }
    }

    @NotNull
    private String getXml(@NotNull String content2, boolean collapsed, @NotNull Map<String, String> namespaces) {
        return this.myWithTabs.isSelected() ? this.getXmlWithTabs(content2, collapsed, namespaces) : this.getXmlWithoutTabs(content2, collapsed, namespaces);
    }

    @NotNull
    private String getXmlWithoutTabs(@NotNull String content2, boolean collapsed, @NotNull Map<String, String> namespaces) {
        return Templates.getCoordinatorLayout(this.getProject(), namespaces.get("http://schemas.android.com/apk/res/android"), namespaces.get("http://schemas.android.com/apk/res-auto"), AppBarConfigurationUtilKt.formatNamespaces(namespaces), this.getFitsSystemWindows(namespaces), this.getToolbarScrollBehavior(), this.getInterpolator(namespaces), this.getBackgroundImage(namespaces), this.getBehaviorOverlapTop(namespaces), AppBarConfigurationDialog.getScrollPos(collapsed, namespaces), content2, this.getFloatingActionButton(namespaces));
    }

    @NotNull
    private String getXmlWithTabs(@NotNull String content2, boolean collapsed, @NotNull Map<String, String> namespaces) {
        return Templates.getCoordinatorLayoutWithTabs(this.getProject(), namespaces.get("http://schemas.android.com/apk/res/android"), namespaces.get("http://schemas.android.com/apk/res-auto"), AppBarConfigurationUtilKt.formatNamespaces(namespaces), this.getTabLayoutScroll(namespaces), this.getTabItems(namespaces), AppBarConfigurationDialog.getScrollPos(collapsed, namespaces), content2, this.getFloatingActionButton(namespaces));
    }

    @NotNull
    private String getFitsSystemWindows(@NotNull Map<String, String> namespaces) {
        if (!this.myShowBackgroundImage.isSelected() || !this.myFitStatusBar.isSelected()) {
            return "";
        }
        return String.format("    %1$s:fitsSystemWindows=\"true\"\n", namespaces.get("http://schemas.android.com/apk/res/android"));
    }

    @NotNull
    private String getToolbarScrollBehavior() {
        return this.myCollapsing.isSelected() ? "scroll|enterAlways|enterAlwaysCollapsed" : "scroll|exitUntilCollapsed";
    }

    @NotNull
    private String getTabLayoutScroll(@NotNull Map<String, String> namespaces) {
        if (!this.myCollapsing.isSelected()) {
            return "";
        }
        return String.format("        %1$s:layout_scrollFlags=\"scroll|enterAlways\"\n", namespaces.get("http://schemas.android.com/apk/res-auto"));
    }

    @NotNull
    private String getTabItems(@NotNull Map<String, String> namespaces) {
        StringBuilder builder2 = new StringBuilder();
        for (int index = 0; index < (Integer)this.myTabCount.getValue(); ++index) {
            builder2.append(Templates.getTabItem(this.getProject(), namespaces.get("http://schemas.android.com/apk/res/android"), "Tab" + (index + 1)));
        }
        return builder2.toString();
    }

    @NotNull
    private String getInterpolator(@NotNull Map<String, String> namespaces) {
        if (!this.myShowBackgroundImage.isSelected()) {
            return "";
        }
        return String.format("        %2$s:layout_scrollInterpolator=\"@%1$s:anim/decelerate_interpolator\"\n", namespaces.get("http://schemas.android.com/apk/res/android"), namespaces.get("http://schemas.android.com/apk/res-auto"));
    }

    @NotNull
    private String getBackgroundImage(@NotNull Map<String, String> namespaces) {
        if (!this.myShowBackgroundImage.isSelected()) {
            return "";
        }
        return Templates.getImageView(namespaces.get("http://schemas.android.com/apk/res/android"), this.getBackgroundImageCollapseMode(namespaces), this.myBackgroundImage);
    }

    @NotNull
    private String getBehaviorOverlapTop(@NotNull Map<String, String> namespaces) {
        if (!this.myContentOverlap.isSelected()) {
            return "";
        }
        return String.format(OVERLAP_TOP_FORMAT, namespaces.get("http://schemas.android.com/apk/res-auto"), this.myContentOverlapAmount.getText());
    }

    @NotNull
    private static String getScrollPos(boolean collapsed, @NotNull Map<String, String> namespaces) {
        if (!collapsed) {
            return "";
        }
        return String.format("        %1$s:scrollY=\"830px\"\n", namespaces.get("http://schemas.android.com/tools"));
    }

    @NotNull
    private String getBackgroundImageCollapseMode(@NotNull Map<String, String> namespaces) {
        if (this.myParallax.isSelected()) {
            return "";
        }
        return String.format("    %1$s:layout_collapseMode=\"parallax\"\n", namespaces.get("http://schemas.android.com/apk/res-auto"));
    }

    @NotNull
    private String getFloatingActionButton(@NotNull Map<String, String> namespaces) {
        if (!this.myFloatingActionButton.isSelected()) {
            return "";
        }
        return Templates.getTagFloatingActionButton(this.getProject(), namespaces.get("http://schemas.android.com/apk/res/android"), this.myFloatingActionButtonImage);
    }

    @NotNull
    private static Map<String, String> getNameSpaces(@Nullable XmlTag root, boolean includeToolsNamespace) {
        HashMap<String, String> reverse = new HashMap<String, String>();
        if (root != null) {
            Map namespaces = root.getLocalNamespaceDeclarations();
            for (String prefix : namespaces.keySet()) {
                reverse.put((String)namespaces.get(prefix), prefix);
            }
        }
        if (!reverse.containsKey("http://schemas.android.com/apk/res/android")) {
            reverse.put("http://schemas.android.com/apk/res/android", "android");
        }
        if (!reverse.containsKey("http://schemas.android.com/apk/res-auto")) {
            reverse.put("http://schemas.android.com/apk/res-auto", "app");
        }
        if (includeToolsNamespace && !reverse.containsKey("http://schemas.android.com/tools")) {
            reverse.put("http://schemas.android.com/tools", "tools");
        }
        return reverse;
    }

    @NotNull
    private static String getDesignContent(@NotNull XmlFile file2) {
        XmlTag content2 = file2.getRootTag();
        if (content2 != null && AndroidXConstants.COORDINATOR_LAYOUT.isEquals(content2.getName())) {
            XmlTag root = content2;
            content2 = null;
            XmlTag[] xmlTagArray = root.getSubTags();
            int n = xmlTagArray.length;
            for (int i = 0; i < n; ++i) {
                XmlTag tag = xmlTagArray[i];
                if (AndroidXConstants.APP_BAR_LAYOUT.isEquals(tag.getName()) || AndroidXConstants.FLOATING_ACTION_BUTTON.isEquals(tag.getName())) continue;
                if (AndroidXConstants.CLASS_NESTED_SCROLL_VIEW.isEquals(tag.getName())) {
                    content2 = tag.getSubTags().length > 0 ? tag.getSubTags()[0] : null;
                    break;
                }
                content2 = tag;
                break;
            }
        }
        if (content2 == null) {
            return "";
        }
        for (XmlAttribute attribute : content2.getAttributes()) {
            if (attribute == null || !attribute.getName().startsWith("xmlns:")) continue;
            attribute.delete();
        }
        return content2.getText();
    }

    private CompletableFuture<Void> updateCollapsedImage() {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.generateXml(true), AppExecutorUtil.getAppExecutorService()).thenCompose(file2 -> this.updateImage((PsiFile)file2, this.myCollapsedPreview))).thenAccept(image -> {
            this.myCollapsedImage = image;
        });
    }

    private CompletableFuture<Void> updateExpandedImage() {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.generateXml(false), AppExecutorUtil.getAppExecutorService()).thenCompose(file2 -> this.updateImage((PsiFile)file2, this.myExpandedPreview))).thenAcceptAsync(image -> {
            this.myExpandedImage = image;
            this.myLoadingPanel.stopLoading();
        }, (Executor)EdtExecutorService.getInstance());
    }

    @NotNull
    private CompletableFuture<BufferedImage> updateImage(@NotNull PsiFile xmlFile, @NotNull JBLabel preview) {
        return this.renderImage(xmlFile).whenCompleteAsync((image, ex) -> this.updatePreviewImage((BufferedImage)image, preview), (Executor)EdtExecutorService.getInstance());
    }

    private CompletableFuture<BufferedImage> renderImage(@NotNull PsiFile xmlFile) {
        AndroidFacet facet = this.myModel.getFacet();
        RenderService renderService = RenderService.getInstance((Project)this.getProject());
        RenderLogger logger2 = renderService.createLogger(facet);
        CompletableFuture taskFuture = renderService.taskBuilder(facet, this.myModel.getConfiguration()).withLogger(logger2).withPsiFile(xmlFile).build();
        return taskFuture.thenCompose(task2 -> {
            if (task2 != null) {
                task2.setRenderingMode(SessionParams.RenderingMode.NORMAL);
                task2.getContext().setFolderType(ResourceFolderType.LAYOUT);
                return ((CompletableFuture)task2.render().thenApply(result -> {
                    ImagePool.Image image = result.getRenderedImage();
                    if (!image.isValid() || image.getWidth() < 40 || image.getHeight() < 60) {
                        return null;
                    }
                    return result.getRenderedImage().getCopy();
                })).whenCompleteAsync((image, ex) -> task2.dispose(), (Executor)AppExecutorUtil.getAppExecutorService());
            }
            return null;
        });
    }

    private void updatePreviewImage(@Nullable BufferedImage image, @NotNull JBLabel view2) {
        if (image == null) {
            view2.setIcon(null);
            this.myPreview.setText(RENDER_ERROR);
            return;
        }
        double width2 = (double)this.myPreviewPanel.getWidth() / 2.0;
        double height2 = this.myPreviewPanel.getHeight() - this.myPreview.getHeight() - Math.max(this.myExpandedLabel.getHeight(), this.myCollapsedLabel.getHeight());
        if (width2 < 40.0 || height2 < 60.0) {
            view2.setIcon(null);
        }
        double scale = Math.min(width2 / (double)image.getWidth(), height2 / (double)image.getHeight()) * 0.95;
        image = ImageUtils.scale((BufferedImage)image, (double)scale, (double)scale);
        view2.setIcon((Icon)new ImageIcon(image));
        this.myPreview.setText(PREVIEW_HEADER);
    }

    private static Logger getLogger() {
        return Logger.getInstance(AppBarConfigurationDialog.class);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JPanel jPanel;
        JSpinner jSpinner;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JButton jButton;
        JButton jButton2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JButton jButton3;
        JButton jButton4;
        JPanel jPanel2;
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myButtonOK = jButton4 = new JButton();
        jButton4.setText("OK");
        jPanel4.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myButtonCancel = jButton3 = new JButton();
        jButton3.setText("Cancel");
        jPanel4.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JSplitPane jSplitPane = new JSplitPane();
        jPanel5.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(16, 8, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCollapsing = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Collapsing Toolbar");
        jPanel7.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myShowBackgroundImage = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Image Background");
        jPanel7.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFloatingActionButton = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Floating Action Button");
        jPanel7.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myWithTabs = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("With Tabs");
        jPanel7.add((Component)jCheckBox4, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 12, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myFitStatusBar = jCheckBox3 = new JCheckBox();
        jCheckBox3.setActionCommand("");
        jCheckBox3.setText("Fit Status Bar on Image");
        jCheckBox3.setToolTipText("Makes the toolbar with the image appear below the status bar. The status bar can be set to draw transparent by setting the theme value for: statusBarColor to color/transparent.");
        jPanel8.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.myParallax = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Parallax Scrolling");
        jCheckBox2.setToolTipText("Makes the image scroll slower than the TabBar (only visible at runtime).");
        jPanel8.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundImageSelector = jButton2 = new JButton();
        Font font = this.$$$getFont$$$(null, -1, 8, jButton2.getFont());
        if (font != null) {
            jButton2.setFont(font);
        }
        jButton2.setText("...");
        jPanel7.add((Component)jButton2, new GridConstraints(1, 1, 1, 2, 4, 0, 3, 0, null, null, null));
        this.myFloatingActionButtonImageSelector = jButton = new JButton();
        Font font2 = this.$$$getFont$$$(null, -1, 8, jButton.getFont());
        if (font2 != null) {
            jButton.setFont(font2);
        }
        jButton.setText("...");
        jPanel7.add((Component)jButton, new GridConstraints(3, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myContentOverlap = jCheckBox = new JCheckBox();
        jCheckBox.setText("Overlapping content");
        jPanel7.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myContentOverlapAmount = jTextField = new JTextField();
        jTextField.setText("32dp");
        jPanel7.add((Component)jTextField, new GridConstraints(4, 2, 1, 1, 8, 1, 1, 0, null, new Dimension(60, -1), null));
        this.myTabCount = jSpinner = new JSpinner();
        jPanel7.add((Component)jSpinner, new GridConstraints(5, 1, 1, 2, 8, 1, 6, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel);
        this.myPreview = jBLabel5 = new JBLabel();
        jBLabel5.setText(PREVIEW_HEADER);
        jPanel.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 2, 2, 0, 7, 7, null, null, null));
        this.myExpandedLabel = jBLabel4 = new JBLabel();
        jBLabel4.setAlignmentX(0.0f);
        jBLabel4.setText("Expanded");
        jPanel.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 1, 0, 7, 7, null, null, null));
        this.myCollapsedLabel = jBLabel3 = new JBLabel();
        jBLabel3.setAlignmentX(0.0f);
        jBLabel3.setText("Collapsed");
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 1, 1, 1, 1, 0, 7, 7, null, null, null));
        this.myExpandedPreview = jBLabel2 = new JBLabel();
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 7, 7, null, null, null));
        this.myCollapsedPreview = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 0, 0, 7, 7, null, null, null, 1));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

